/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.operations;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.ErrorCondition;
import it.jrc.osint.operations.Operation;
import it.jrc.osint.operations.OperationStatus;
import java.util.ArrayList;
import java.util.List;

public class OperationContext {
    private static final Logger log = LogManager.getLogger((String)OperationContext.class.getName());
    private String label;
    private List<Operation> operations = new ArrayList<Operation>();

    public OperationContext(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void add(Operation anOperation) {
        this.operations.add(anOperation);
    }

    public OperationStatus executeOperations() {
        ArrayList<Operation> executedOperations = new ArrayList<Operation>();
        for (Operation o : this.operations) {
            try {
                OperationStatus status = o.execute();
                if (!status.isOK()) {
                    this.undoOperations(executedOperations);
                    return status;
                }
                executedOperations.add(0, o);
            }
            catch (Throwable t) {
                log.error("Failed to execute operation " + o, t);
                OperationStatus status = new OperationStatus(4, new ErrorCondition(0, "Failed to execute operation " + o, "Try again. If problem persists you may contact the software provider.", t));
                this.undoOperations(executedOperations);
                return status;
            }
        }
        return OperationStatus.OK_STATUS;
    }

    private void undoOperations(List<Operation> operations) {
        for (Operation o : operations) {
            try {
                o.undo();
            }
            catch (Throwable t) {
                log.error("Failed to undo operation " + o, t);
            }
        }
    }
}

