/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";

    public static String getFormattedChannelPubDate(Date aDate) {
        return DateUtil.getRFC822DateFormat().format(aDate);
    }

    public static String getFormattedItemPubDate(Date aDate) {
        return DateUtil.getRSSDateFormat().format(aDate);
    }

    public static String getFormattedFileSuffixDate(Date aDate) {
        return DateUtil.getFileSuffixDateFormat().format(aDate);
    }

    public static String getFormattedTimestamp(Date aDate) {
        return DateUtil.getDisplayTimestampFormat().format(aDate);
    }

    public static String getFormattedDate(Date aDate) {
        return DateUtil.getDisplayDateFormat().format(aDate);
    }

    private static SimpleDateFormat getDisplayTimestampFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm");
    }

    private static SimpleDateFormat getFileSuffixDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm");
    }

    private static SimpleDateFormat getRSSDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
    }

    private static SimpleDateFormat getRFC822DateFormat() {
        return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    }

    private static SimpleDateFormat getDisplayDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }
}

