/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.concurrent;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.Consumer;
import it.jrc.osint.util.concurrent.DaemonThreadFactory;
import it.jrc.osint.util.concurrent.DefaultProcessingContext;
import it.jrc.osint.util.concurrent.ProcessingContext;
import it.jrc.osint.util.concurrent.ProcessingException;
import it.jrc.osint.util.concurrent.Processor;
import it.jrc.osint.util.concurrent.ProcessorParameters;
import it.jrc.osint.util.concurrent.Producer;
import it.jrc.osint.util.concurrent.Task;
import it.jrc.osint.util.concurrent.TaskToken;
import it.jrc.osint.util.concurrent.TerminalTaskToken;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ParallelProcessor<I>
implements Processor<I> {
    private final Logger log = LogManager.getLogger((String)ParallelProcessor.class.getName());
    private ExecutorService consumerExecutorService;
    private ExecutorService producerExecutorService;
    private ExecutorService taskExecutorService;
    private ProcessorParameters params;
    private Producer<I> producer;
    private BlockingQueue<TaskToken<I>> consQ;
    private BlockingQueue<TaskToken<I>> prodQ;
    private List<I> failedInputList;
    private Task<I> processingTask;
    private Consumer<I> consumer;
    private ProcessingContext context;
    private String taskDescriptor = "Processing";
    private String itemsDescriptor = "Items";
    private volatile boolean done = false;
    private volatile boolean producerFinished = false;
    private volatile boolean cancelled = false;
    private IProgressMonitor monitor;
    private String name = "parallel-processor";
    private String taskName = "taskName";

    public ParallelProcessor(Producer<I> aProducer, Consumer<I> aConsumer, Task<I> task) {
        this.setParameters(new ProcessorParameters());
        this.setProducer(aProducer);
        this.setConsumer(aConsumer);
        this.setTask(task);
    }

    public void setParameters(ProcessorParameters params) {
        this.params = params;
        this.failedInputList = new ArrayList<I>();
        this.consQ = new LinkedBlockingQueue<TaskToken<I>>(params.getConsumerQueueCapacity());
        this.prodQ = new LinkedBlockingQueue<TaskToken<I>>(params.getProducerQueueCapacity());
    }

    public void setThreadPoolSize(int concurrentThreads) {
        this.getParameters().setThreadPoolSize(concurrentThreads);
    }

    public ProcessorParameters getParameters() {
        return this.params;
    }

    public void setConsumer(Consumer<I> consumer) {
        this.consumer = consumer;
    }

    public void setContext(ProcessingContext context) {
        this.context = context;
    }

    public void setProducer(Producer<I> producer) {
        this.producer = producer;
    }

    public void setTask(Task<I> task) {
        this.processingTask = task;
        if (task.getName() != null) {
            this.taskName = task.getName();
        }
    }

    private void startTasks() throws ProcessingException {
        Task<I> task = this.processingTask;
        if (task == null) {
            throw new IllegalStateException("No task instance has been defined");
        }
        if (this.context != null) {
            task.init(this.context);
        }
        TaskRunner taskRunner = new TaskRunner(task);
        int i = 0;
        while (i < this.params.getThreadPoolSize()) {
            this.taskExecutorService.submit(taskRunner);
            ++i;
        }
    }

    @Override
    public Future<Consumer<I>> start(IProgressMonitor monitor) throws ProcessingException {
        this.monitor = monitor;
        this.failedInputList.clear();
        this.prodQ = new LinkedBlockingQueue<TaskToken<I>>(this.params.getProducerQueueCapacity());
        this.consQ = new LinkedBlockingQueue<TaskToken<I>>(this.params.getConsumerQueueCapacity());
        int expectedItemCount = this.producer.expectedItemCount();
        this.producerExecutorService = Executors.newSingleThreadExecutor(DaemonThreadFactory.getThreadFactory(String.valueOf(this.name) + "_producer"));
        this.consumerExecutorService = Executors.newSingleThreadExecutor(DaemonThreadFactory.getThreadFactory(String.valueOf(this.name) + "_consumer"));
        this.taskExecutorService = Executors.newCachedThreadPool(DaemonThreadFactory.getThreadFactory(String.valueOf(this.taskName) + "_task"));
        if (this.context == null) {
            this.context = new DefaultProcessingContext();
        }
        this.context.init();
        this.producer.setContext(this.context);
        this.consumer.setContext(this.context);
        this.producer.reset();
        this.consumer.reset();
        this.producerExecutorService.submit(new ProducerRunner(this.producer));
        this.monitorStart(expectedItemCount);
        this.startTasks();
        Future<Consumer<I>> consumerFuture = this.consumerExecutorService.submit(new ConsumerRunner(this.consumer, this.producer.expectedItemCount()), this.consumer);
        ProcessorFuture processorFuture = new ProcessorFuture(consumerFuture);
        return processorFuture;
    }

    private void handleFailedInput(I failedInput) {
        this.failedInputList.add(failedInput);
    }

    @Override
    public List<I> getFailedInput() {
        return this.failedInputList;
    }

    public void setName(String nameOfProcessor) {
        this.name = nameOfProcessor;
    }

    public void setTaskDescriptor(String taskDescriptor) {
        this.taskDescriptor = taskDescriptor;
    }

    public void setItemsDescriptor(String itemDescriptor) {
        this.itemsDescriptor = itemDescriptor;
    }

    private synchronized void cancel() {
        this.log.debug("Cancel request received");
        this.cancelled = true;
    }

    private void shutdown() {
        if (this.producerExecutorService != null) {
            this.producerExecutorService.shutdownNow();
            this.producerExecutorService = null;
        }
        if (this.taskExecutorService != null) {
            this.taskExecutorService.shutdownNow();
            this.taskExecutorService = null;
        }
        if (this.consumerExecutorService != null) {
            this.consumerExecutorService.shutdownNow();
            this.consumerExecutorService = null;
        }
    }

    @Override
    public synchronized boolean isCanceled() {
        if (this.cancelled) {
            return true;
        }
        if (this.monitor != null) {
            return this.monitor.isCanceled();
        }
        return false;
    }

    public boolean isDone() {
        return this.done;
    }

    private boolean isProducerFinished() {
        return this.producerFinished;
    }

    private void monitorStart(int expectedItemCount) {
        if (this.monitor != null) {
            this.monitor.beginTask(this.taskDescriptor, expectedItemCount);
        }
    }

    private void monitorSubTask(String message) {
        if (this.monitor != null) {
            if (this.monitor instanceof SubProgressMonitor) {
                this.monitor.subTask(String.valueOf(this.taskDescriptor) + message);
            } else {
                this.monitor.subTask(message);
            }
        }
    }

    private synchronized void monitorItemWorked() {
        if (this.isCanceled()) {
            return;
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
    }

    private void monitorDone() {
        if (this.monitor != null) {
            this.monitor.done();
        }
    }

    protected class ConsumerRunner
    implements Runnable {
        private Consumer<I> consumerToRun;
        private int itemsConsumed;
        private int terminalTokensConsumed;
        private int expectedItemCount;

        public ConsumerRunner(Consumer<I> consumerToRun, int expectedItemCount) {
            this.consumerToRun = consumerToRun;
            this.expectedItemCount = expectedItemCount;
        }

        @Override
        public void run() {
            this.itemsConsumed = 0;
            this.terminalTokensConsumed = 0;
            boolean terminated = false;
            try {
                while (!terminated) {
                    if (this.terminalTokensConsumed >= ParallelProcessor.this.params.getThreadPoolSize()) {
                        ParallelProcessor.this.log.debug("Terminal Tokens for all threads received, exiting");
                        terminated = true;
                        continue;
                    }
                    TaskToken nextItem = this.nextOutput();
                    if (nextItem == null) continue;
                    if (nextItem.isTerminalToken()) {
                        ++this.terminalTokensConsumed;
                        continue;
                    }
                    this.consumerToRun.consume(nextItem.getItem());
                    ParallelProcessor.this.monitorItemWorked();
                    ++this.itemsConsumed;
                    ParallelProcessor.this.monitorSubTask(" - finished " + this.itemsConsumed + " of " + this.expectedItemCount + " " + ParallelProcessor.this.itemsDescriptor);
                }
            }
            finally {
                this.consumerToRun.finish();
                ParallelProcessor.this.monitorDone();
            }
        }

        private TaskToken<I> nextOutput() {
            TaskToken nextOutputToken = null;
            try {
                nextOutputToken = (TaskToken)ParallelProcessor.this.consQ.poll(ParallelProcessor.this.params.getPollConsumerQueueTimeoutMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                ParallelProcessor.this.log.debug("Polling of next input item interrupted", (Throwable)e);
            }
            return nextOutputToken;
        }
    }

    protected class InterruptThreadTimerTask
    extends TimerTask {
        private Thread threadToInterrupt;

        public InterruptThreadTimerTask(Thread threadToInterrupt) {
            this.threadToInterrupt = threadToInterrupt;
        }

        @Override
        public void run() {
            ParallelProcessor.this.log.debug("Interrupting thread " + this.threadToInterrupt.getName());
            this.threadToInterrupt.interrupt();
        }
    }

    protected class ProcessorFuture
    implements Future<Consumer<I>> {
        private Future<Consumer<I>> consumerFuture;

        public ProcessorFuture(Future<Consumer<I>> consumerFuture) {
            this.consumerFuture = consumerFuture;
        }

        @Override
        public boolean cancel(boolean immediately) {
            ParallelProcessor.this.log.debug("Cancellation request received");
            ParallelProcessor.this.cancel();
            return true;
        }

        @Override
        public Consumer<I> get() throws InterruptedException, ExecutionException {
            try {
                if (this.isCancelled() || this.isDone()) {
                    Consumer consumer = ParallelProcessor.this.consumer;
                    return consumer;
                }
                Consumer finishedConsumer = this.consumerFuture.get();
                ParallelProcessor.this.done = true;
                Consumer consumer = finishedConsumer;
                return consumer;
            }
            finally {
                ParallelProcessor.this.shutdown();
            }
        }

        @Override
        public Consumer<I> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            if (this.isCancelled() || this.isDone()) {
                return ParallelProcessor.this.consumer;
            }
            try {
                Consumer finishedConsumer = this.consumerFuture.get(timeout, unit);
                ParallelProcessor.this.done = true;
                Consumer consumer = finishedConsumer;
                return consumer;
            }
            catch (TimeoutException e) {
                ParallelProcessor.this.log.debug("ProcessorFuture: timeout waiting for consumer to finish: shutting down and returning consumer");
                ParallelProcessor.this.cancel();
                Consumer consumer = ParallelProcessor.this.consumer;
                return consumer;
            }
            finally {
                ParallelProcessor.this.shutdown();
            }
        }

        @Override
        public boolean isCancelled() {
            return ParallelProcessor.this.isCanceled();
        }

        @Override
        public boolean isDone() {
            return ParallelProcessor.this.isDone();
        }
    }

    protected class ProducerRunner
    implements Runnable {
        private Producer<I> producerToRun;

        public ProducerRunner(Producer<I> producerToRun) {
            this.producerToRun = producerToRun;
        }

        @Override
        public void run() {
            boolean terminated = false;
            while (!terminated) {
                if (!this.producerToRun.hasNext()) {
                    terminated = true;
                    continue;
                }
                if (ParallelProcessor.this.isCanceled()) {
                    terminated = true;
                    continue;
                }
                Object anItem = this.producerToRun.next();
                if (anItem == null) continue;
                try {
                    ParallelProcessor.this.prodQ.put(new TaskToken(anItem));
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            try {
                int i = 0;
                while (i < ParallelProcessor.this.params.getThreadPoolSize()) {
                    ParallelProcessor.this.prodQ.put(new TerminalTaskToken());
                    ++i;
                }
            }
            catch (InterruptedException e) {
                ParallelProcessor.this.log.error("Terminating interrupted", (Throwable)e);
            }
        }
    }

    protected class TaskRunner
    implements Runnable {
        private Task<I> taskToRun;

        public TaskRunner(Task<I> taskToRun) {
            this.taskToRun = taskToRun;
        }

        @Override
        public void run() {
            try {
                boolean terminated = false;
                while (!terminated) {
                    TaskToken inputToken = null;
                    Object outputItem = null;
                    inputToken = (TaskToken)ParallelProcessor.this.prodQ.poll(ParallelProcessor.this.params.getPollProducerQueueTimeoutMs(), TimeUnit.MILLISECONDS);
                    if (inputToken == null) {
                        ParallelProcessor.this.log.debug("[TaskRunner]: Poll to producerQueue timed out");
                        continue;
                    }
                    if (inputToken.isTerminalToken()) {
                        terminated = true;
                        ParallelProcessor.this.consQ.put(inputToken);
                        continue;
                    }
                    if (ParallelProcessor.this.isCanceled()) {
                        terminated = true;
                        ParallelProcessor.this.consQ.put(new TerminalTaskToken());
                        continue;
                    }
                    try {
                        outputItem = this.taskToRun.process(inputToken.getItem());
                        ParallelProcessor.this.consQ.put(new TaskToken<Object>(outputItem));
                    }
                    catch (OutOfMemoryError e) {
                        ParallelProcessor.this.log.error("[TaskRunner]: Out of memory error received, shutting down task runner", (Throwable)e);
                        ParallelProcessor.this.handleFailedInput(inputToken.getItem());
                        break;
                    }
                    catch (ProcessingException e) {
                        ParallelProcessor.this.log.debug("[TaskRunner]: Processing failed on input item", (Throwable)e);
                        ParallelProcessor.this.handleFailedInput(inputToken.getItem());
                    }
                    catch (Throwable t) {
                        ParallelProcessor.this.log.error("[TaskRunner]: Processing failed on input item", t);
                        ParallelProcessor.this.handleFailedInput(inputToken.getItem());
                    }
                }
                if (ParallelProcessor.this.log.isDebugEnabled()) {
                    if (ParallelProcessor.this.isCanceled()) {
                        ParallelProcessor.this.log.debug("[TaskRunner]: Processor has been cancelled, exiting");
                    }
                    if (ParallelProcessor.this.prodQ.isEmpty()) {
                        ParallelProcessor.this.log.debug("[TaskRunner]: Producer queue is empty");
                    }
                    if (ParallelProcessor.this.isProducerFinished()) {
                        ParallelProcessor.this.log.debug("[TaskRunner]: Producer is finished");
                    }
                    ParallelProcessor.this.log.debug("[TaskRunner]: Exiting");
                }
            }
            catch (InterruptedException e) {
                ParallelProcessor.this.log.debug("[TaskRunner]: TaskRunner interrupted, exiting", (Throwable)e);
            }
        }
    }
}

