/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.concurrent;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.Consumer;
import it.jrc.osint.util.concurrent.DaemonThreadFactory;
import it.jrc.osint.util.concurrent.DefaultProcessingContext;
import it.jrc.osint.util.concurrent.PipelineTask;
import it.jrc.osint.util.concurrent.ProcessingContext;
import it.jrc.osint.util.concurrent.ProcessingException;
import it.jrc.osint.util.concurrent.Processor;
import it.jrc.osint.util.concurrent.Producer;
import it.jrc.osint.util.concurrent.Task;
import it.jrc.osint.util.concurrent.TaskToken;
import it.jrc.osint.util.concurrent.TerminalTaskToken;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class PipelineProcessor<I>
implements Processor<I> {
    private static final Logger log = LogManager.getLogger((String)PipelineProcessor.class.getName());
    private ExecutorService consumerExecutor;
    private ExecutorService producerExecutor;
    private ExecutorService[] taskExecutors;
    private IProgressMonitor monitor;
    private ProcessingContext context;
    private volatile boolean done;
    private volatile boolean cancelled;
    private String name = "unnamed";
    private String taskDescriptor = "Processing";
    private String itemsDescriptor = "Documents";
    private List<Task<I>> tasks;
    private Producer<I> producer;
    private Consumer<I> consumer;
    private Queue<TaskToken<I>> systemProdQ = new LinkedList<TaskToken<I>>();
    private BlockingQueue<TaskToken<I>> prodQ = null;
    private int prodQCapacity = Integer.MAX_VALUE;
    private BlockingQueue<TaskToken<I>> consQ = null;
    private List<I> failedInputList = new LinkedList<I>();

    public PipelineProcessor(Producer<I> aProducer, Consumer<I> aConsumer, List<Task<I>> tasks) {
        this.producer = aProducer;
        this.consumer = aConsumer;
        this.tasks = tasks;
    }

    public void setTaskDescriptor(String taskDescriptor) {
        this.taskDescriptor = taskDescriptor;
    }

    public void setItemsDescriptor(String itemsDescriptor) {
        this.itemsDescriptor = itemsDescriptor;
    }

    public void setProducer(Producer<I> aProducer) {
        this.producer = aProducer;
    }

    public void setConsumer(Consumer<I> aConsumer) {
        this.consumer = aConsumer;
    }

    private List<PipelineTaskRunner> initializeTasks() throws ProcessingException {
        LinkedList<PipelineTaskRunner> taskRunners = new LinkedList<PipelineTaskRunner>();
        PipelineTask<I> precedingTask = null;
        int i = 0;
        while (i < this.tasks.size()) {
            PipelineTask<I> t;
            Task<I> task = this.tasks.get(i);
            if (task == null) {
                throw new IllegalStateException("No task instance has been defined");
            }
            try {
                try {
                    this.monitorSubTask("Initialising " + task.getName());
                    task.init(this.context);
                }
                catch (Throwable t2) {
                    log.error("Failed to initialize task " + task.getName(), t2);
                    throw new ProcessingException("Task initialization failed", t2);
                }
            }
            finally {
                this.monitorItemWorked();
            }
            PipelineTaskRunner taskRunner = null;
            if (i == 0 && i == this.tasks.size() - 1) {
                taskRunner = new PipelineTaskRunner(new PipelineTask<I>(task, this.prodQ, this.consQ));
            } else if (i == 0) {
                log.debug("Producer queue size:" + this.prodQ.size());
                t = new PipelineTask<I>(task, this.prodQ, this.prodQCapacity);
                taskRunner = new PipelineTaskRunner(t);
                precedingTask = t;
            } else if (i == this.tasks.size() - 1) {
                taskRunner = new PipelineTaskRunner(new PipelineTask<I>(task, precedingTask.getOutputQueue(), this.consQ));
            } else {
                t = new PipelineTask<I>(task, precedingTask.getOutputQueue(), this.prodQCapacity);
                taskRunner = new PipelineTaskRunner(t);
                precedingTask = t;
            }
            taskRunners.add(taskRunner);
            ++i;
        }
        return taskRunners;
    }

    @Override
    public Future<Consumer<I>> start(IProgressMonitor monitor) throws ProcessingException {
        this.monitor = monitor;
        this.prodQ = new LinkedBlockingQueue<TaskToken<I>>(this.prodQCapacity);
        this.consQ = new LinkedBlockingQueue<TaskToken<I>>();
        this.producerExecutor = this.getProducerExecutor();
        this.consumerExecutor = this.getConsumerExecutor();
        this.taskExecutors = this.createTaskExecutors();
        if (this.context == null) {
            this.context = new DefaultProcessingContext();
        }
        this.context.init();
        this.producer.setContext(this.context);
        this.consumer.setContext(this.context);
        this.producer.reset();
        this.consumer.reset();
        int expectedItemCount = this.producer.expectedItemCount();
        int expectedWorkItemCount = expectedItemCount + this.tasks.size();
        this.monitorStart(expectedWorkItemCount);
        List<PipelineTaskRunner> taskRunners = this.initializeTasks();
        if (monitor != null) {
            monitor.subTask("Processing Documents");
        }
        this.producerExecutor.submit(new ProducerRunner(this.producer));
        int i = 0;
        while (i < taskRunners.size()) {
            this.getTaskExecutor(i).submit(taskRunners.get(i));
            ++i;
        }
        Future<Consumer<I>> consumerFuture = this.consumerExecutor.submit(new ConsumerRunner(this.consumer, expectedItemCount), this.consumer);
        ProcessorFuture processorFuture = new ProcessorFuture(this, consumerFuture, this.consumer);
        return processorFuture;
    }

    private void cancel() {
        log.debug("Cancel request received");
        this.cancelled = true;
        this.systemProdQ.clear();
        this.systemProdQ.add(new TerminalTaskToken());
    }

    private ExecutorService getProducerExecutor() {
        return Executors.newSingleThreadExecutor(DaemonThreadFactory.getThreadFactory(String.valueOf(this.name) + "_producer"));
    }

    private ExecutorService getConsumerExecutor() {
        return Executors.newSingleThreadExecutor(DaemonThreadFactory.getThreadFactory(String.valueOf(this.name) + "_consumer"));
    }

    private ExecutorService[] createTaskExecutors() {
        ExecutorService[] retVal = new ExecutorService[this.tasks.size()];
        int i = 0;
        while (i < this.tasks.size()) {
            retVal[i] = Executors.newSingleThreadExecutor(DaemonThreadFactory.getThreadFactory(String.valueOf(this.tasks.get(i).getName()) + i));
            ++i;
        }
        return retVal;
    }

    private ExecutorService getTaskExecutor(int index) {
        return this.taskExecutors[index];
    }

    private boolean isMonitorCancelled() {
        if (this.monitor != null) {
            return this.monitor.isCanceled();
        }
        return false;
    }

    private I handleFailedInput(I failedInput) {
        this.failedInputList.add(failedInput);
        return failedInput;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isCanceled() {
        return this.cancelled;
    }

    public void setContext(ProcessingContext context) {
        this.context = context;
    }

    private void monitorStart(int expectedItemCount) {
        if (this.monitor != null) {
            this.monitor.beginTask(this.taskDescriptor, expectedItemCount);
        }
    }

    private synchronized void monitorItemWorked() {
        if (this.isCanceled()) {
            return;
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
    }

    private void monitorDone() {
        if (this.monitor != null) {
            this.monitor.done();
        }
    }

    private void monitorSubTask(String message) {
        if (this.monitor != null) {
            if (this.monitor instanceof SubProgressMonitor) {
                this.monitor.subTask(String.valueOf(this.taskDescriptor) + message);
            } else {
                this.monitor.subTask(message);
            }
        }
    }

    @Override
    public List<I> getFailedInput() {
        return this.failedInputList;
    }

    public void setProducerQueueCapacity(int capacity) {
        this.prodQCapacity = capacity;
    }

    protected class ConsumerRunner
    implements Runnable {
        private Consumer<I> consumerToRun;
        private int itemsConsumed;
        private int expectedItemCount;

        public ConsumerRunner(Consumer<I> consumerToRun, int expectedItemCount) {
            this.consumerToRun = consumerToRun;
            this.expectedItemCount = expectedItemCount;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.itemsConsumed = 0;
            try {
                block9: {
                    boolean terminated;
                    block8: {
                        terminated = false;
                        if (!true) break block8;
                        if (terminated) return;
                        if (!this.hasNextOutput()) break block9;
                    }
                    do {
                        TaskToken nextItem;
                        if ((nextItem = this.nextOutput()) != null) {
                            if (nextItem.isTerminalToken()) {
                                terminated = true;
                                log.debug("Terminal Token received, exiting");
                            } else {
                                this.consumerToRun.consume(nextItem.getItem());
                                PipelineProcessor.this.monitorItemWorked();
                                ++this.itemsConsumed;
                                PipelineProcessor.this.monitorSubTask(String.valueOf(PipelineProcessor.this.taskDescriptor) + " - finished " + this.itemsConsumed + " of " + this.expectedItemCount + " " + PipelineProcessor.this.itemsDescriptor);
                            }
                        }
                        if (terminated) return;
                    } while (this.hasNextOutput());
                }
                return;
            }
            finally {
                this.consumerToRun.finish();
                PipelineProcessor.this.monitorDone();
                log.debug("Exiting");
            }
        }

        private boolean hasNextOutput() {
            if (PipelineProcessor.this.isCanceled()) {
                return false;
            }
            return !PipelineProcessor.this.consQ.isEmpty() || !PipelineProcessor.this.isDone();
        }

        private TaskToken<I> nextOutput() {
            if (PipelineProcessor.this.isCanceled()) {
                return null;
            }
            TaskToken nextOutputToken = null;
            try {
                nextOutputToken = (TaskToken)PipelineProcessor.this.consQ.poll(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.debug("Polling of next input item interrupted", (Throwable)e);
            }
            return nextOutputToken;
        }
    }

    protected class InterruptThreadTimerTask
    extends TimerTask {
        private Thread threadToInterrupt;

        public InterruptThreadTimerTask(Thread threadToInterrupt) {
            this.threadToInterrupt = threadToInterrupt;
        }

        @Override
        public void run() {
            log.debug("Interrupting thread " + this.threadToInterrupt.getName());
            this.threadToInterrupt.interrupt();
        }
    }

    protected class PipelineTaskRunner
    implements Runnable {
        private Logger log = LogManager.getLogger((String)PipelineTaskRunner.class.getName());
        private PipelineTask<I> taskToRun;

        public PipelineTaskRunner(PipelineTask<I> taskToRun) {
            this.taskToRun = taskToRun;
        }

        @Override
        public void run() {
            try {
                boolean terminated = false;
                while (!terminated) {
                    Object inputItem = null;
                    Object outputItem = null;
                    TaskToken token = this.taskToRun.getInputQueue().take();
                    if (token.isTerminalToken()) {
                        this.log.debug("Terminal Token received - exiting");
                        terminated = true;
                        this.taskToRun.getOutputQueue().clear();
                        this.taskToRun.getOutputQueue().put(token);
                        continue;
                    }
                    inputItem = token.getItem();
                    try {
                        outputItem = this.taskToRun.process(inputItem);
                        if (outputItem == null) {
                            this.log.debug("[ProcessingTaskRunne]: OutputItem of task was null, ignored");
                            continue;
                        }
                        this.taskToRun.getOutputQueue().put(new TaskToken<Object>(outputItem));
                    }
                    catch (OutOfMemoryError e) {
                        this.log.error("Out of memory error received, shutting down task runner", (Throwable)e);
                        break;
                    }
                    catch (ProcessingException e) {
                        this.log.debug("Processing failed on input item", (Throwable)e);
                        outputItem = PipelineProcessor.this.handleFailedInput(inputItem);
                    }
                    catch (Throwable t) {
                        this.log.error("Processing failed on input item", t);
                        Object object = PipelineProcessor.this.handleFailedInput(inputItem);
                    }
                }
                if (this.log.isDebugEnabled()) {
                    if (PipelineProcessor.this.isCanceled()) {
                        this.log.debug("[ProcessingTaskRunner]: Processor has been cancelled, exiting");
                    }
                    if (this.taskToRun.isInputQueueEmpty()) {
                        this.log.debug("[ProcessingTaskRunner]: Task input queue is empty");
                    }
                    this.log.debug("[ProcessingTaskRunner]: Exiting");
                }
            }
            catch (InterruptedException e) {
                this.log.debug("TaskRunner interrupted, exiting", (Throwable)e);
            }
        }

        public PipelineTask<I> getTask() {
            return this.taskToRun;
        }
    }

    protected class ProcessorFuture
    implements Future<Consumer<I>> {
        private PipelineProcessor<I> processor;
        private Future<Consumer<I>> consumerFuture;
        private Consumer<I> consumer;

        public ProcessorFuture(PipelineProcessor<I> processor, Future<Consumer<I>> consumerFuture, Consumer<I> consumer) {
            this.processor = processor;
            this.consumerFuture = consumerFuture;
            this.consumer = consumer;
        }

        @Override
        public boolean cancel(boolean immediately) {
            log.debug("Cancellation request received");
            this.processor.cancel();
            return true;
        }

        @Override
        public Consumer<I> get() throws InterruptedException, ExecutionException {
            if (PipelineProcessor.this.isCanceled() || this.isDone()) {
                return this.consumer;
            }
            Consumer finishedConsumer = this.consumerFuture.get();
            PipelineProcessor.this.done = true;
            return finishedConsumer;
        }

        @Override
        public Consumer<I> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            if (this.isCancelled() || this.isDone()) {
                return this.consumer;
            }
            try {
                Consumer finishedConsumer = this.consumerFuture.get(timeout, unit);
                PipelineProcessor.this.done = true;
                return finishedConsumer;
            }
            catch (TimeoutException e) {
                log.debug("ProcessorFuture: timeout waiting for consumer to finish: shutting down and returning consumer");
                this.processor.cancel();
                return this.consumer;
            }
        }

        @Override
        public boolean isCancelled() {
            return this.processor.isCanceled();
        }

        @Override
        public boolean isDone() {
            return this.processor.isDone();
        }
    }

    protected class ProducerRunner
    implements Runnable {
        private Producer<I> producerToRun;

        public ProducerRunner(Producer<I> producerToRun) {
            this.producerToRun = producerToRun;
        }

        @Override
        public void run() {
            boolean terminated = false;
            try {
                try {
                    while (this.producerToRun.hasNext() && !terminated) {
                        TaskToken token;
                        if (PipelineProcessor.this.isMonitorCancelled()) {
                            PipelineProcessor.this.cancel();
                            terminated = true;
                        }
                        if ((token = (TaskToken)PipelineProcessor.this.systemProdQ.poll()) == null) {
                            Object anItem = this.producerToRun.next();
                            if (anItem == null) continue;
                            PipelineProcessor.this.prodQ.put(new TaskToken(anItem));
                            continue;
                        }
                        log.debug("Terminal Token received, forwarding to prodQ");
                        PipelineProcessor.this.prodQ.clear();
                        PipelineProcessor.this.prodQ.put(token);
                        terminated = true;
                    }
                    if (!terminated) {
                        PipelineProcessor.this.prodQ.put(new TerminalTaskToken());
                    }
                }
                catch (Throwable t) {
                    log.debug("ProducerRunner catched exception, exiting", t);
                    PipelineProcessor.this.prodQ.add(new TerminalTaskToken());
                    log.debug("Exiting");
                }
            }
            finally {
                log.debug("Exiting");
            }
        }
    }
}

