/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.concurrent;

import it.jrc.osint.util.concurrent.ProcessingContext;
import it.jrc.osint.util.concurrent.ProcessingException;
import it.jrc.osint.util.concurrent.Task;
import it.jrc.osint.util.concurrent.TaskToken;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class PipelineTask<I> {
    protected BlockingQueue<TaskToken<I>> inputQueue = null;
    protected BlockingQueue<TaskToken<I>> outputQueue = null;
    protected Task<I> task = null;

    public PipelineTask(Task<I> task, BlockingQueue<TaskToken<I>> inputQueue, BlockingQueue<TaskToken<I>> outputQueue) {
        this.task = task;
        this.inputQueue = inputQueue;
        this.outputQueue = outputQueue;
    }

    public PipelineTask(Task<I> task, BlockingQueue<TaskToken<I>> inputQueue, int queueCapacity) {
        this.task = task;
        this.inputQueue = inputQueue;
        this.outputQueue = new LinkedBlockingQueue<TaskToken<I>>(queueCapacity);
    }

    public BlockingQueue<TaskToken<I>> getInputQueue() {
        return this.inputQueue;
    }

    public void setInputQueue(BlockingQueue<TaskToken<I>> inputQueue) {
        this.inputQueue = inputQueue;
    }

    public BlockingQueue<TaskToken<I>> getOutputQueue() {
        return this.outputQueue;
    }

    public void setOutputQueue(BlockingQueue<TaskToken<I>> outputQueue) {
        this.outputQueue = outputQueue;
    }

    public boolean isInputQueueEmpty() {
        return this.inputQueue.isEmpty();
    }

    public I process(I target) throws ProcessingException {
        I retVal = null;
        try {
            retVal = this.task.process(target);
            return retVal;
        }
        catch (Throwable t) {
            throw new ProcessingException("Failed to process item", t);
        }
    }

    public void init(ProcessingContext context) throws ProcessingException {
        this.task.init(context);
    }

    public void cancel() {
        this.task.cancel();
    }
}

