/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.config;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.config.PropertyProvider;
import it.jrc.osint.util.config.PropertyStorage;
import it.jrc.osint.util.config.PropertyUtil;
import it.jrc.osint.util.config.SystemPropertyProvider;
import java.util.Properties;

public class FilePropertyStorage
implements PropertyStorage {
    private static final Logger log = LogManager.getLogger((String)FilePropertyStorage.class.getName());
    private String propertyFileName;
    private Properties properties;
    private PropertyProvider parentProvider = new SystemPropertyProvider();

    public FilePropertyStorage(String propertyFileName, PropertyProvider parentProvider) {
        this(propertyFileName);
        this.parentProvider = parentProvider;
    }

    public FilePropertyStorage(String propertyFileName) {
        this.propertyFileName = propertyFileName;
        this.properties = PropertyUtil.loadProperties(propertyFileName);
    }

    @Override
    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
        PropertyUtil.storeProperties(this.propertyFileName, this.properties, "");
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.properties == null) {
            if (this.parentProvider != null) {
                return this.parentProvider.getProperty(key, defaultValue);
            }
            return defaultValue;
        }
        if (this.properties.containsKey(key)) {
            String result = this.properties.getProperty(key, defaultValue);
            log.debug("Obtained property (" + key + "," + result + ")");
            return result;
        }
        log.debug("Property (" + key + ") not found searching parent provider");
        if (this.parentProvider != null) {
            return this.parentProvider.getProperty(key, defaultValue);
        }
        return defaultValue;
    }
}

