/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.config;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;

public class TypeConversionUtil {
    private static Logger log = LogManager.getLogger((String)TypeConversionUtil.class.getName());

    public static boolean getBooleanValue(String value) {
        return TypeConversionUtil.getBooleanValue(value, false);
    }

    public static boolean getBooleanValue(String value, boolean defaultValue) {
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        boolean result = defaultValue;
        try {
            result = Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            log.warn("Failed to parse boolean value: " + value, (Throwable)e);
        }
        return result;
    }

    public static int getIntValue(String value, int defaultValue) {
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        int result = defaultValue;
        try {
            result = Integer.parseInt(value);
        }
        catch (Exception e) {
            log.warn("Failed to parse int value: " + value, (Throwable)e);
        }
        return result;
    }

    public static int[] getIntValuesCSV(String value, int defaultValue) {
        if (value == null || "".equals(value)) {
            return new int[0];
        }
        String[] values = value.split(",");
        if (values == null) {
            return new int[0];
        }
        int[] resultArray = new int[values.length];
        int i = 0;
        while (i < values.length) {
            resultArray[i] = TypeConversionUtil.getIntValue(values[i], defaultValue);
            ++i;
        }
        return resultArray;
    }
}

