/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.event;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.EventHandlerImpl;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class EventBroker {
    private static final Logger log = LogManager.getLogger((String)EventBroker.class.getName());
    private BundleContext context;
    private Map<TopicEventListener, ServiceRegistration<?>> listenerRegistry = new HashMap();

    public EventBroker(BundleContext context) {
        this.context = context;
    }

    public void stop() {
        for (ServiceRegistration<?> sr : this.listenerRegistry.values()) {
            try {
                sr.unregister();
            }
            catch (Throwable t) {
                log.error("Failed to unregister listener", t);
            }
        }
    }

    public void postEvent(SystemEvent event) {
        if (event == null) {
            return;
        }
        try {
            HashMap<String, SystemEvent> osgiEventProperties = new HashMap<String, SystemEvent>();
            osgiEventProperties.put("payload", event);
            Event osgiEvent = new Event(event.getTopic(), osgiEventProperties);
            ServiceReference serviceReference = this.context.getServiceReference(EventAdmin.class.getName());
            if (serviceReference == null) {
                Exception traceException = new Exception("TraceException");
                traceException.fillInStackTrace();
                log.error("Failed to get service reference for EventAdmin.", (Throwable)traceException);
                return;
            }
            EventAdmin eventAdmin = (EventAdmin)this.context.getService(serviceReference);
            if (eventAdmin == null) {
                Exception traceException = new Exception("TraceException");
                traceException.fillInStackTrace();
                log.error("Failed to obtain event admin.", (Throwable)traceException);
                log.error("Failed to deliver event:" + event.getTopic());
                return;
            }
            eventAdmin.postEvent(osgiEvent);
            this.context.ungetService(serviceReference);
        }
        catch (Throwable t) {
            log.error("Failed to post event", t);
        }
    }

    public void sendEvent(SystemEvent event) {
        try {
            HashMap<String, SystemEvent> osgiEventProperties = new HashMap<String, SystemEvent>();
            osgiEventProperties.put("payload", event);
            Event osgiEvent = new Event(event.getTopic(), osgiEventProperties);
            ServiceReference serviceReference = this.context.getServiceReference(EventAdmin.class.getName());
            if (serviceReference == null) {
                log.error("Failed to get service reference for EventAdmin.");
                return;
            }
            EventAdmin eventAdmin = (EventAdmin)this.context.getService(serviceReference);
            if (eventAdmin == null) {
                log.error("Failed to obtain event admin.");
                log.error("Failed to deliver event:" + event.getTopic());
                return;
            }
            eventAdmin.sendEvent(osgiEvent);
            this.context.ungetService(serviceReference);
        }
        catch (Throwable t) {
            log.error("Failed to sendevent", t);
        }
    }

    public void register(String[] topics, TopicEventListener eventListener) {
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        ((Dictionary)ht).put("event.topics", topics);
        ServiceRegistration sr = this.context.registerService(EventHandler.class.getName(), (Object)new EventHandlerImpl(eventListener), ht);
        this.listenerRegistry.put(eventListener, sr);
    }

    public void unregister(TopicEventListener eventListener) {
        try {
            ServiceRegistration<?> sr;
            if (this.listenerRegistry.containsKey(eventListener) && (sr = this.listenerRegistry.remove(eventListener)) != null) {
                sr.unregister();
            }
        }
        catch (Throwable t) {
            log.error("Failed to unregister topic event listener", t);
        }
    }
}

