/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.event;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventHandlerImpl
implements EventHandler {
    private static final Logger log = LogManager.getLogger((String)EventHandlerImpl.class.getName());
    private TopicEventListener listener;

    public EventHandlerImpl(TopicEventListener listener) {
        this.listener = listener;
    }

    public void handleEvent(Event event) {
        try {
            if (event == null) {
                return;
            }
            String topic = event.getTopic();
            Object payload = event.getProperty("payload");
            if (topic.startsWith("osint")) {
                SystemEvent systemEvent = (SystemEvent)payload;
                this.listener.handleEvent(systemEvent);
            } else {
                this.listener.handleEvent(topic, payload);
            }
        }
        catch (Throwable t) {
            log.error("Error occurred in TopicEventListener#handleEvent", t);
        }
    }
}

