/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.io;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class ContentTypeUtil {
    private static final Logger log = LogManager.getLogger((String)ContentTypeUtil.class.getName());

    public static String getContentTypeId(IFile file, boolean useFilenameOnly, String unknownType) {
        IContentType actualContentType = null;
        if (!useFilenameOnly) {
            if (!file.exists()) {
                return null;
            }
            IContentDescription contentDescription = null;
            try {
                contentDescription = file.getContentDescription();
            }
            catch (Throwable t) {
                log.error("Failed to retrieve content description for file " + file.getName(), t);
            }
            if (contentDescription != null) {
                actualContentType = contentDescription.getContentType();
            }
        } else {
            actualContentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
        }
        if (actualContentType != null) {
            return actualContentType.getId();
        }
        return unknownType;
    }
}

