/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.io;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IOUtil {
    static final Logger log = LogManager.getLogger((String)IOUtil.class.getName());

    public static String serialize(Object orig) {
        if (!(orig instanceof Serializable)) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(orig);
            out.flush();
            out.close();
            return bos.toString();
        }
        catch (Throwable t) {
            log.error("Failed to serialize object to string", t);
            return null;
        }
    }

    public static Object copy(Object orig) {
        if (!(orig instanceof Serializable)) {
            return null;
        }
        Object obj = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            obj = in.readObject();
        }
        catch (Throwable t) {
            log.error("Failed to copy object using serialisation/deserialisation", t);
        }
        return obj;
    }
}

