/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.io;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@XStreamAlias(value="persistent-map")
public class PersistentMap
implements Map<String, Object>,
Serializable {
    private static final Logger log = LogManager.getLogger((String)PersistentMap.class.getName());
    private static final long serialVersionUID = 7166901528336545593L;
    private static final String CONTENT_TYPE_ID = "content-type";
    private static final String VERSION = "version";
    @XStreamAlias(value="content-type")
    private String contentTypeId;
    private int version;
    @XStreamAlias(value="meta")
    private Map<String, Object> metaMap = new HashMap<String, Object>();
    @XStreamAlias(value="data")
    private Map<String, Object> dataMap = new HashMap<String, Object>();

    public PersistentMap(String contentTypeId) {
        this.setContentTypeId(contentTypeId);
    }

    public PersistentMap(String contentTypeId, int version) {
        this(contentTypeId);
        this.version = version;
    }

    public void setVersion(int version) {
        this.version = version;
        this.putMeta(VERSION, version);
    }

    public int getVersion() {
        return this.version;
    }

    private void setContentTypeId(String contentTypeId) {
        this.contentTypeId = contentTypeId;
        this.putMeta(CONTENT_TYPE_ID, contentTypeId);
    }

    private void putMeta(String key, Object value) {
        this.metaMap.put(key, value);
    }

    public String getContentTypeId() {
        return this.contentTypeId;
    }

    public boolean load(InputStream in) {
        InputStreamReader inReader = null;
        PersistentMap map = null;
        try {
            inReader = new InputStreamReader(in, "UTF-8");
            map = (PersistentMap)this.getXStream().fromXML((Reader)inReader);
            this.contentTypeId = map.getContentTypeId();
            this.version = map.getVersion();
            this.dataMap = map.dataMap;
            this.metaMap = map.metaMap;
            return true;
        }
        catch (Throwable t) {
            log.error("Failed to load persistent map", t);
            return false;
        }
        finally {
            FileUtil.close(in);
        }
    }

    public InputStream save() {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter outWriter = null;
        try {
            outWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
            this.getXStream().toXML((Object)this, (Writer)outWriter);
            ((Writer)outWriter).flush();
            byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Throwable t) {
            try {
                log.error("Failed to save persistent map", t);
            }
            catch (Throwable throwable) {
                FileUtil.close(outWriter);
                throw throwable;
            }
            FileUtil.close(outWriter);
            return null;
        }
        FileUtil.close(outWriter);
        return byteArrayInputStream;
    }

    public void save(Writer outWriter) {
        try {
            try {
                this.getXStream().toXML((Object)this, outWriter);
                outWriter.flush();
            }
            catch (Throwable t) {
                log.error("Failed to save persistent map", t);
                FileUtil.close(outWriter);
            }
        }
        finally {
            FileUtil.close(outWriter);
        }
    }

    private XStream getXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.processAnnotations(PersistentMap.class);
        return xstream;
    }

    public String toXML() {
        return this.getXStream().toXML((Object)this);
    }

    @Override
    public int size() {
        return this.dataMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.dataMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.dataMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.dataMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.dataMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.dataMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.dataMap.putAll(m);
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.dataMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.dataMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.dataMap.entrySet();
    }
}

