/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.io;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.XMLContentDescriber;

public class PersistentMapContentDescriber
extends XMLContentDescriber
implements IExecutableExtension {
    private static final Logger log = LogManager.getLogger((String)PersistentMapContentDescriber.class.getName());
    private String contentType;
    private Pattern matchContentTypePattern;

    public int describe(InputStream input, IContentDescription description) throws IOException {
        int result = super.describe(input, description);
        if (result != 2) {
            return result;
        }
        input.reset();
        String charSet = null;
        if (description != null) {
            charSet = (String)description.getProperty(IContentDescription.CHARSET);
        }
        if (charSet == null) {
            charSet = "UTF-8";
        }
        InputStreamReader inReader = new InputStreamReader(input, charSet);
        return this.internalDescribe(inReader);
    }

    public int describe(Reader input, IContentDescription description) throws IOException {
        if (super.describe(input, description) == 0) {
            return 0;
        }
        input.reset();
        return this.internalDescribe(input);
    }

    private int internalDescribe(Reader input) throws IOException {
        int ch;
        if (this.contentType == null || "".equals(this.contentType)) {
            log.warn("Invalid extension definition: no content-type parameter set");
            return 0;
        }
        StringWriter outWriter = new StringWriter();
        int charactersRead = 0;
        BufferedReader bufferedReader = new BufferedReader(input);
        while ((ch = bufferedReader.read()) != -1) {
            outWriter.write(ch);
            if (++charactersRead > 200) break;
        }
        outWriter.flush();
        String fileContent = outWriter.toString();
        Matcher m = this.matchContentTypePattern.matcher(fileContent);
        if (m.matches()) {
            return 2;
        }
        return 0;
    }

    public QualifiedName[] getSupportedOptions() {
        return super.getSupportedOptions();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Hashtable) {
            Hashtable parameterMap = (Hashtable)data;
            this.contentType = (String)parameterMap.get("content-type");
            this.matchContentTypePattern = Pattern.compile(".*<content-type>.*" + this.contentType + ".*</content-type>.*");
        } else {
            log.warn("Invalid extension definition: no content-type parameter set");
        }
    }
}

