/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.io;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class TmpDirSupport {
    private static final Logger log = LogManager.getLogger((String)TmpDirSupport.class.getName());
    public static final String TMP_DIR_NAME = "tmp";
    private File tmpDir;

    public void init(File pluginStateLocation) {
        try {
            this.tmpDir = new File(pluginStateLocation, TMP_DIR_NAME);
            FileUtils.forceMkdir((File)this.tmpDir);
            FileUtils.cleanDirectory((File)this.tmpDir);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to create tmp folder for crawler plugin", t);
        }
    }

    public void cleanup() {
        if (this.tmpDir == null) {
            return;
        }
        try {
            FileUtils.cleanDirectory((File)this.tmpDir);
        }
        catch (Throwable t) {
            log.error("Failed to clean temp dir", t);
        }
    }

    public File getTmpDir() {
        if (this.tmpDir == null) {
            throw new IllegalStateException("tmp dir must first be created by call to init");
        }
        return this.tmpDir;
    }

    public File getSubTmpDir(String subFolderName) {
        if (this.tmpDir == null) {
            throw new IllegalStateException("tmp dir must first be created by call to init");
        }
        try {
            File jobTempFolder = new File(this.tmpDir, subFolderName);
            FileUtils.forceMkdir((File)jobTempFolder);
            return jobTempFolder;
        }
        catch (Throwable t) {
            log.error("Failed to create sub tmp folder", t);
            return new File(System.getProperty("java.io.tmpdir"));
        }
    }
}

