/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.net;

import com.btr.proxy.search.ProxySearch;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.List;

public class ProxyAutoDetection {
    private static final Logger log = LogManager.getLogger((String)ProxyAutoDetection.class.getName());

    public static ProxySelector detectAndSetProxySelector() {
        try {
            ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
            ProxySelector detectedSelector = proxySearch.getProxySelector();
            if (detectedSelector != null) {
                ProxySelector.setDefault(detectedSelector);
            }
            return detectedSelector;
        }
        catch (Throwable t) {
            log.error("Failed to detect proxy settings", t);
            return null;
        }
    }

    public static void clearProxySelector() {
        try {
            ProxySelector.setDefault(null);
        }
        catch (Throwable t) {
            log.error("Failed to clear default proxy selector", t);
        }
    }

    public static boolean validateConnection(String testURL, ProxySelector proxySelector) {
        if (proxySelector == null) {
            log.debug("No proxySelector given");
            return false;
        }
        try {
            URI testURI = URI.create(testURL);
            log.debug("Found the following proxy information for URL " + testURL);
            List<Proxy> proxies = proxySelector.select(testURI);
            for (Proxy p : proxies) {
                log.debug(p.toString());
            }
            log.debug("Trying to establish connection to URL " + testURL);
            URL url = new URL(testURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(15000);
            connection.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(String.valueOf(line) + "\n");
            }
            String resultString = stringBuilder.toString();
            log.debug(resultString);
            return resultString.length() > 0;
        }
        catch (Throwable t) {
            log.error("Failed to validate connection", t);
            return false;
        }
    }
}

