/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.net;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.net.ProxyData;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ProxyServiceClient {
    private static final Logger log = LogManager.getLogger((String)ProxyServiceClient.class.getName());
    private ServiceReference<IProxyService> proxyServiceReference;
    private BundleContext bundleContext;

    public ProxyServiceClient(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.proxyServiceReference = bundleContext.getServiceReference(IProxyService.class.getName());
        IProxyService proxyService = this.getProxyService();
        if (proxyService == null) {
            log.warn("Could not acquire IProxyService");
        }
    }

    public void stop() {
        try {
            if (this.proxyServiceReference != null) {
                this.bundleContext.ungetService(this.proxyServiceReference);
            }
        }
        catch (Throwable t) {
            log.error("Failed to stop proxy client", t);
        }
    }

    public boolean isProxyEnabled(String proxyType) {
        IProxyService ps = this.getProxyService();
        if (ps == null) {
            return false;
        }
        boolean proxiesEnabled = ps.isProxiesEnabled();
        if (proxiesEnabled) {
            IProxyData proxyData = ps.getProxyData(proxyType);
            if (proxyData == null) {
                return false;
            }
            return proxyData.getHost() != null;
        }
        return false;
    }

    public ProxyData getProxyData(String proxyType) {
        try {
            IProxyData pd = this.getProxyService().getProxyData(proxyType);
            ProxyData proxyData = new ProxyData(pd);
            proxyData.setNonProxiedHosts(this.getProxyService().getNonProxiedHosts());
            return proxyData;
        }
        catch (Throwable t) {
            log.error("Failed to retriev proxy data from IProxyService", t);
            return null;
        }
    }

    private IProxyService getProxyService() {
        if (this.proxyServiceReference == null) {
            return null;
        }
        IProxyService proxyService = (IProxyService)this.bundleContext.getService(this.proxyServiceReference);
        if (proxyService == null) {
            log.warn("Could not acquire IProxyService");
            return null;
        }
        return proxyService;
    }
}

