/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.net;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.net.ProxyData;
import it.jrc.osint.util.net.ProxyUser;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class _ProxySupport {
    private static final Logger log = LogManager.getLogger((String)_ProxySupport.class.getName());
    private ServiceReference<IProxyService> proxyServiceReference;
    private IProxyChangeListener proxyChangeListener = new ProxyChangeListener();
    private BundleContext bundleContext;
    private ProxyUser proxyUser;

    public _ProxySupport(ProxyUser proxyUser) {
        this.proxyUser = proxyUser;
    }

    public void start(BundleContext context) {
        this.bundleContext = context;
        this.proxyServiceReference = context.getServiceReference(IProxyService.class.getName());
        IProxyService proxyService = this.getProxyService();
        if (proxyService != null) {
            proxyService.addProxyChangeListener(this.proxyChangeListener);
        } else {
            log.warn("Could not acquire IProxyService");
        }
        this.updateProxyUser();
    }

    public void stop(BundleContext context) {
        if (this.proxyServiceReference != null) {
            IProxyService proxyService = (IProxyService)context.getService(this.proxyServiceReference);
            if (proxyService != null) {
                proxyService.removeProxyChangeListener(this.proxyChangeListener);
            }
            context.ungetService(this.proxyServiceReference);
        }
    }

    private void disableProxy() {
        this.proxyUser.setProxyEnablement(false);
    }

    private void setHttpProxyData(IProxyData httpProxyData) {
        if (httpProxyData.getHost() == null) {
            return;
        }
        ProxyData proxyData = new ProxyData(httpProxyData);
        this.proxyUser.setProxyData(proxyData);
    }

    public void updateProxyUser() {
        if (this.getProxyService().isProxiesEnabled()) {
            IProxyData httpProxyData = this.getProxyService().getProxyData("HTTP");
            this.setHttpProxyData(httpProxyData);
        } else {
            this.disableProxy();
        }
    }

    public String[] dump(IProxyData[] data) {
        if (data == null) {
            return null;
        }
        String[] result = new String[data.length];
        int i = 0;
        while (i < data.length) {
            IProxyData entry = data[i];
            result[i] = "Type:" + entry.getType() + " host:" + entry.getHost() + " port:" + entry.getPort();
            ++i;
        }
        return result;
    }

    private IProxyService getProxyService() {
        if (this.proxyServiceReference == null) {
            return null;
        }
        IProxyService proxyService = (IProxyService)this.bundleContext.getService(this.proxyServiceReference);
        if (proxyService == null) {
            log.warn("Could not acquire IProxyService");
            return null;
        }
        return proxyService;
    }

    private class ProxyChangeListener
    implements IProxyChangeListener {
        private ProxyChangeListener() {
        }

        public void proxyInfoChanged(IProxyChangeEvent event) {
            if (event.getChangeType() == 3 && !_ProxySupport.this.getProxyService().isProxiesEnabled()) {
                _ProxySupport.this.disableProxy();
            }
            if (event.getChangeType() == 2) {
                if (_ProxySupport.this.getProxyService().isProxiesEnabled()) {
                    IProxyData[] changedData;
                    IProxyData[] iProxyDataArray = changedData = event.getChangedProxyData();
                    int n = changedData.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProxyData proxyData = iProxyDataArray[n2];
                        if (proxyData.getType().equals("HTTP")) {
                            _ProxySupport.this.setHttpProxyData(proxyData);
                        }
                        ++n2;
                    }
                } else {
                    _ProxySupport.this.disableProxy();
                }
            }
        }
    }
}

