/*
 * Decompiled with CFR 0.152.
 */
package test.util.config;

import it.jrc.osint.util.config.FilePropertyStorage;
import it.jrc.osint.util.test.TestUtil;
import java.io.File;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFilePropertyStorage {
    @Before
    public void setup() {
        TestUtil.setupLogging();
    }

    @Test
    public void getPropertyExistingFile() {
        String testPropertyFile = String.valueOf(TestUtil.getTestBaseDir()) + File.separator + "test.properties";
        FilePropertyStorage propertyStorage = new FilePropertyStorage(testPropertyFile);
        String retrievedValue = propertyStorage.getProperty("key1", "defaultValue");
        Assert.assertEquals((String)"value1", (String)retrievedValue);
    }

    @Test
    public void getPropertyNotExistingFile() {
        String testPropertyFile = String.valueOf(TestUtil.getTestBaseDir()) + File.separator + "note-existing.properties";
        FilePropertyStorage propertyStorage = new FilePropertyStorage(testPropertyFile);
        String retrievedValue = propertyStorage.getProperty("key1", "defaultValue");
        Assert.assertEquals((String)"defaultValue", (String)retrievedValue);
    }

    @Test
    public void setPropertyExistingFile() {
        String testPropertyFile = String.valueOf(TestUtil.getTestBaseDir()) + File.separator + "test.properties";
        FilePropertyStorage propertyStorage = new FilePropertyStorage(testPropertyFile);
        propertyStorage.setProperty("key-new", "value-new");
        FilePropertyStorage propertyStorage1 = new FilePropertyStorage(testPropertyFile);
        String retrievedValue = propertyStorage1.getProperty("key-new", "defaultValue");
        Assert.assertEquals((String)"value-new", (String)retrievedValue);
    }

    @Test
    public void setPropertyNotExistingFile() {
        String millis = "" + System.currentTimeMillis();
        String newTestPropertyFile = String.valueOf(TestUtil.getTestBaseDir()) + File.separator + "test-created" + millis + ".properties";
        FilePropertyStorage propertyStorage = new FilePropertyStorage(newTestPropertyFile);
        propertyStorage.setProperty("key-new", "value-new");
        FilePropertyStorage propertyStorage1 = new FilePropertyStorage(newTestPropertyFile);
        String retrievedValue = propertyStorage1.getProperty("key-new", "defaultValue");
        Assert.assertEquals((String)"value-new", (String)retrievedValue);
    }
}

