/*
 * Decompiled with CFR 0.152.
 */
package test.util.io;

import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.util.test.TestUtil;
import java.io.File;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFileUtil {
    private String baseDir = TestUtil.getTestBaseDir("fileutil");

    @Before
    public void setup() {
    }

    @Test
    public void testCopyFile2File() {
        String sourceFilePath = String.valueOf(this.baseDir) + File.separator + "a.txt";
        String targetFilePath = String.valueOf(this.baseDir) + File.separator + "a-copied.txt";
        boolean result = FileUtil.copy(sourceFilePath, targetFilePath);
        Assert.assertTrue((boolean)result);
        File targetFile = new File(targetFilePath);
        Assert.assertTrue((boolean)targetFile.exists());
    }

    @Test
    public void testCopyFile2Dir() {
        String sourceFilePath = String.valueOf(this.baseDir) + File.separator + "a.txt";
        String targetFilePath = String.valueOf(this.baseDir) + File.separator + "dir2";
        boolean result = FileUtil.copy(sourceFilePath, targetFilePath);
        Assert.assertTrue((boolean)result);
        File targetFile = new File(String.valueOf(targetFilePath) + File.separator + "a.txt");
        Assert.assertTrue((boolean)targetFile.exists());
    }

    @Test
    public void testCopyDirNotRecursive() {
        String sourcePath = String.valueOf(this.baseDir) + File.separator + "dir1";
        String targetPath = String.valueOf(this.baseDir) + File.separator + "dir1-copied";
        boolean result = FileUtil.copy(sourcePath, targetPath, false);
        Assert.assertTrue((boolean)result);
        File copiedDir = new File(targetPath);
        Assert.assertTrue((boolean)copiedDir.exists());
        String[] children = copiedDir.list();
        Assert.assertEquals((int)1, (int)children.length);
    }

    @Test
    public void testCopyDirRecursive() {
        String sourcePath = String.valueOf(this.baseDir) + File.separator + "dir1";
        String targetPath = String.valueOf(this.baseDir) + File.separator + "dir1-copied-recursive";
        boolean result = FileUtil.copy(sourcePath, targetPath, true);
        Assert.assertTrue((boolean)result);
        File sourceDir = new File(sourcePath);
        File[] children = sourceDir.listFiles();
        File copiedDir = new File(targetPath);
        Assert.assertTrue((boolean)copiedDir.exists());
        String[] copiedChildren = copiedDir.list();
        Assert.assertEquals((int)children.length, (int)copiedChildren.length);
    }

    @Test
    public void testErrorCopyDirTargetFile() {
        String sourcePath = String.valueOf(this.baseDir) + File.separator + "dir1";
        String targetPath = String.valueOf(this.baseDir) + File.separator + "a.txt";
        boolean result = FileUtil.copy(sourcePath, targetPath);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testErrorCopyFileNotExisting() {
        String sourcePath = String.valueOf(this.baseDir) + File.separator + "not-existing.txt";
        String targetPath = String.valueOf(this.baseDir) + File.separator + "copied-not-existing.txt";
        boolean result = FileUtil.copy(sourcePath, targetPath);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testMoveFile2Dir() {
        String sourcePath = String.valueOf(this.baseDir) + File.separator + "dir1" + File.separator + "dir1.3" + File.separator + "a1.3.txt";
        String targetPath = String.valueOf(this.baseDir) + File.separator + "dir2";
        boolean result = FileUtil.move(sourcePath, targetPath);
        Assert.assertTrue((boolean)result);
        File sourceFile = new File(sourcePath);
        Assert.assertTrue((!sourceFile.exists() ? 1 : 0) != 0);
        File targetFile = new File(String.valueOf(targetPath) + File.separator + "a1.3.txt");
        Assert.assertTrue((boolean)targetFile.exists());
    }

    @Test
    public void testMoveFile2NotExistingDir() {
        String sourcePath = String.valueOf(this.baseDir) + File.separator + "dir1" + File.separator + "dir1.4" + File.separator + "a.txt";
        String targetPath = String.valueOf(this.baseDir) + File.separator + "dir3";
        boolean result = FileUtil.move(sourcePath, targetPath);
        Assert.assertTrue((boolean)result);
        File sourceFile = new File(sourcePath);
        Assert.assertTrue((!sourceFile.exists() ? 1 : 0) != 0);
        File targetFile = new File(String.valueOf(targetPath) + File.separator + "a.txt");
        Assert.assertTrue((boolean)targetFile.exists());
    }

    @Test
    public void testMoveDir2NewDir() {
        String sourcePath = String.valueOf(this.baseDir) + File.separator + "dir4" + File.separator + "dir4.1";
        String targetPath = String.valueOf(this.baseDir) + File.separator + "dir5";
        boolean result = FileUtil.move(sourcePath, targetPath);
        Assert.assertTrue((boolean)result);
        File sourceFile = new File(sourcePath);
        Assert.assertTrue((!sourceFile.exists() ? 1 : 0) != 0);
        File targetFile = new File(String.valueOf(targetPath) + File.separator + "a.txt");
        Assert.assertTrue((boolean)targetFile.exists());
    }

    @Test
    public void testMoveDir2ExistingDir() {
        String sourcePath = String.valueOf(this.baseDir) + File.separator + "dir6";
        String targetPath = String.valueOf(this.baseDir) + File.separator + "dir2";
        boolean result = FileUtil.move(sourcePath, targetPath);
        Assert.assertTrue((boolean)result);
        File sourceFile = new File(sourcePath);
        Assert.assertFalse((boolean)sourceFile.exists());
        File targetFile = new File(String.valueOf(targetPath) + File.separator + "dir6.1");
        Assert.assertTrue((boolean)targetFile.exists());
    }

    @Test
    public void testMatchFileSuffices() {
        String fileName = "webpage.htm";
        boolean result = FileUtil.hasSuffix(fileName, "htm");
        Assert.assertTrue((boolean)result);
        result = FileUtil.hasSuffix(null, "htm");
        Assert.assertFalse((boolean)result);
        result = FileUtil.hasSuffix(fileName, "html");
        Assert.assertFalse((boolean)result);
        result = FileUtil.hasSuffix(fileName, "html,htm");
        Assert.assertTrue((boolean)result);
    }
}

