/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.controller;

import it.jrc.dispatcher.Dispatcher;
import it.jrc.dispatcher.QAlert;
import it.jrc.extract.controller.GuessingController;
import it.jrc.extract.controller.GuessingThread;
import it.jrc.extract.controller.NestedServletException;
import it.jrc.extract.controller.VariantGuessPool;
import it.jrc.scheduler.CachedJob;
import it.jrc.scheduler.Job;
import it.jrc.scheduler.Scheduler;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GuessingServlet
extends HttpServlet {
    private Scheduler _scheduler;
    private Dispatcher _dispatcher;
    private String _jobqueue = null;
    private GuessingThread[] _threadpool;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(GuessingServlet.class);

    public void init(ServletConfig sercon) throws ServletException {
        super.init(sercon);
        long timestamp = System.currentTimeMillis();
        LOGGER.info("receives init() " + (Object)((Object)this) + " " + ((Object)((Object)this)).getClass() + " at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).format(timestamp));
        try {
            this._jobqueue = GuessingServlet.getServletInitParameterPath(sercon, "jobQ", 'd', "jobs/", false);
            String queuesdefinition = GuessingServlet.getServletInitParameterPath(sercon, "qDef", 'f', "queues.xml", false);
            int threadnum = GuessingServlet.getServletInitParameterInteger(sercon, "threadNum", 0);
            String dispatcherqueues = GuessingServlet.getServletInitParameterPath(sercon, "Qs", 'd', "Qs/", false);
            String errorspath = GuessingServlet.getServletInitParameterPath(sercon, "errorsPath", 'd', null, true);
            String resourcespath = GuessingServlet.getServletInitParameterPath(sercon, "resourcesPath", 'd', null, true);
            this._dispatcher = new Dispatcher();
            this._dispatcher.setQAlert(5000, new QAlert(){

                public void qSize(String qname, int size) {
                    LOGGER.debug("queue [" + qname + "] now contains [" + size + "] items");
                }
            });
            try {
                this._dispatcher.initQs(queuesdefinition, dispatcherqueues);
            }
            catch (Exception ex) {
                throw new ServletException("while Dispatcher does initQs(" + queuesdefinition + "," + dispatcherqueues + ") got [" + ex.getClass() + ": " + ex.getMessage() + "]", (Throwable)ex);
            }
            this._scheduler = new Scheduler(this._jobqueue);
            VariantGuessPool.getInstance();
            VariantGuessPool.getInstance().init(resourcespath);
            this._threadpool = new GuessingThread[threadnum];
            for (int i = 0; i < threadnum; ++i) {
                GuessingThread gt = new GuessingThread("entgue-t" + i, this._scheduler, this._dispatcher, errorspath);
                gt.start();
                this._threadpool[i] = gt;
                LOGGER.info("thread [" + gt.getName() + "] started");
            }
            this._scheduler.start();
            LOGGER.info("init() done");
        }
        catch (ServletException sex) {
            LOGGER.error("cannot init()", (Throwable)sex);
            this.destroy();
            throw sex;
        }
        catch (Throwable th) {
            LOGGER.error("cannot init()", th);
            this.destroy();
            throw new ServletException("cannot init()", th);
        }
    }

    public void destroy() {
        LOGGER.info("receives destroy()");
        LOGGER.info("proper shutdown is completed when 'shutdown completed' is logged");
        Thread.currentThread().setPriority(10);
        if (this._scheduler != null) {
            this._scheduler.destroy();
            this._scheduler = null;
        }
        if (this._dispatcher != null) {
            this._dispatcher.destroy();
            this._dispatcher = null;
        }
        for (GuessingThread t : this._threadpool) {
            t.end();
            try {
                t.join();
            }
            catch (InterruptedException iex) {
                LOGGER.warn("while destroy() joins thread [" + t.getName() + "] got [" + iex.getMessage() + "]", (Throwable)iex);
            }
            LOGGER.info("thread [" + t.getName() + "] end");
        }
        this._threadpool = null;
        try {
            VariantGuessPool.getInstance().term();
        }
        catch (Exception ex) {
            LOGGER.warn("cannot term() [VariantPool]", (Throwable)ex);
        }
        LOGGER.info("shutdown completed");
        LOGGER.info("destroy() done");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doProcess(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String sid = req.getParameter("id");
        if (sid != null && !sid.equals("")) {
            LOGGER.debug("receives job with sid [" + sid + "]");
            String sxml = req.getParameter("xml");
            CachedJob job = CachedJob.makeJob((String)this._jobqueue, (String)sid, (String)sxml);
            this._scheduler.schedule((Job)job);
            res.setStatus(200);
        } else {
            this.doProcess(req, res);
        }
    }

    private void doProcess(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block4: {
            try {
                GuessingController.handleRequest(req, res);
            }
            catch (NestedServletException nsex) {
                LOGGER.error("cannot handleRequest", (Throwable)nsex);
                res.sendError(nsex.getStatusCode(), nsex.getMessage());
            }
            catch (Throwable th) {
                LOGGER.error("cannot handleRequest", th);
                if (th instanceof ServletException) {
                    throw (ServletException)th;
                }
                if (!(th instanceof IOException)) break block4;
                throw (IOException)th;
            }
        }
    }

    private static void assurePath(File dir) throws IOException {
        if (!dir.exists()) {
            if (!dir.mkdirs() && !dir.isDirectory()) {
                throw new IOException("file mkdirs of [" + dir.getAbsolutePath() + "] failed");
            }
            LOGGER.debug("created path [" + dir.getAbsolutePath() + "]");
        }
    }

    private static String getServletInitParameterString(ServletConfig sercon, String parametername, String defaultvalue) throws ServletException {
        String result = sercon.getInitParameter(parametername);
        if (result == null || result.equals("")) {
            if (defaultvalue == null) {
                throw new ServletException("servlet init parameter [" + parametername + "] is mandatory");
            }
            result = defaultvalue;
        }
        LOGGER.info("servlet init parameter [" + parametername + "] is [" + result + "]");
        return result;
    }

    private static String getServletInitParameterPath(ServletConfig sercon, String parametername, char parametertype, String defaultvalue, boolean create) throws ServletException {
        String result = sercon.getInitParameter(parametername);
        if (result == null || result.equals("")) {
            if (defaultvalue == null) {
                throw new ServletException("servlet init parameter [" + parametername + "] is mandatory");
            }
            result = defaultvalue;
        }
        if (System.getProperty("os.name").startsWith("Win")) {
            if (!result.matches("((\\\\\\\\|//)|[a-zA-Z]:(\\\\|/)).*")) {
                result = sercon.getServletContext().getRealPath(result);
            }
        } else if (!result.startsWith("/")) {
            result = sercon.getServletContext().getRealPath(result);
        }
        result = result.replace('\\', '/');
        if (parametertype == 'd' && !result.endsWith("/")) {
            result = result.concat("/");
        }
        LOGGER.info("servlet init parameter [" + parametername + "] is [" + result + "]");
        if (create) {
            File f = new File(result);
            try {
                GuessingServlet.assurePath(f);
            }
            catch (IOException ioex) {
                throw new ServletException(ioex.getMessage(), (Throwable)ioex);
            }
        }
        return result;
    }

    private static int getServletInitParameterInteger(ServletConfig sercon, String parametername, int defaultvalue) throws ServletException {
        String sresult = sercon.getInitParameter(parametername);
        int result = 0;
        if (sresult == null || sresult.equals("")) {
            if (defaultvalue == -1) {
                throw new ServletException("servlet init parameter [" + parametername + "] is mandatory");
            }
            result = defaultvalue;
        } else {
            result = new Integer(sresult);
        }
        LOGGER.info("servlet init parameter [" + parametername + "] is [" + result + "]");
        return result;
    }
}

