/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.controller;

import it.jrc.dispatcher.Dispatcher;
import it.jrc.extract.controller.VariantGuessPool;
import it.jrc.extract.service.VariantException;
import it.jrc.extract.service.VariantGuess;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import it.jrc.scheduler.CachedJob;
import it.jrc.scheduler.Scheduler;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GuessingThread
extends Thread {
    private volatile boolean _running = true;
    private Scheduler _scheduler;
    private Dispatcher _dispatcher;
    private RSSParser _rssparser;
    private String _errorspath;
    private static final Logger LOGGER = LogManager.getLogger(GuessingThread.class);

    public GuessingThread(String name, Scheduler scheduler, Dispatcher dispatcher, String errorspath) {
        super(name);
        this._scheduler = scheduler;
        this._dispatcher = dispatcher;
        this._rssparser = new RSSParser();
        this._errorspath = errorspath;
    }

    public void end() {
        LOGGER.info("receives end()");
        this._running = false;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.debug("receives run()");
        while (this._running) {
            CachedJob job = (CachedJob)this._scheduler.next();
            if (!this._running || job == null) continue;
            LOGGER.debug("run gets job [" + job.getId() + "]");
            try {
                RSS rss = null;
                try {
                    try (Reader r = null;){
                        r = job.getReader();
                        rss = this._rssparser.parse(r);
                    }
                    LOGGER.debug("the job is an rss of #[" + rss.getItems().size() + "] items");
                }
                catch (Exception ex) {
                    throw new Exception("the job is not a valid rss", ex);
                }
                try {
                    this.guessing(rss, false);
                }
                catch (Throwable th) {
                    LOGGER.warn("cannot feed job [" + job.getId() + "] to guessing", th);
                    this.dump(job.getId(), rss, th);
                }
                if (this._running) {
                    try {
                        this._dispatcher.send(rss.getGuid(), rss.toString());
                        job.delete();
                        LOGGER.debug("job [" + job.getId() + "] done");
                        continue;
                    }
                    catch (Exception ex) {
                        throw new Exception("cannot send the rss to the next dispatcher", ex);
                    }
                }
                break;
            }
            catch (Throwable th) {
                LOGGER.error("while processing job [" + job.getId() + "] got [" + th.getMessage() + "]", th);
                job.fail();
            }
        }
        LOGGER.debug("run() done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void guessing(RSS rss, boolean evidence) throws VariantException {
        block6: {
            LOGGER.debug("receives guessing on feed [{}] in language[{}]", new Object[]{rss.getGuid(), rss.getLanguage()});
            boolean ap = false;
            try {
                ap = VariantGuessPool.getInstance().acquire();
                if (!ap) break block6;
                VariantGuess vg = VariantGuessPool.getInstance().getVariantGuessFor(rss.getLanguage());
                for (RSSItem rssi : rss.getItems()) {
                    if (!this._running) {
                        break;
                    }
                    LOGGER.debug("receives guessing on item [{}]", new Object[]{rssi.getGuid()});
                    vg.process(rssi, evidence);
                }
            }
            finally {
                if (ap) {
                    VariantGuessPool.getInstance().release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(String id, RSS rss, Throwable ex) {
        int i;
        String filename = id.substring(Math.max(id.lastIndexOf(47), id.lastIndexOf(92)) + 1);
        StringBuilder sb = new StringBuilder();
        sb.append(ex.getMessage());
        sb.append("; ");
        StackTraceElement[] aste = ex.getStackTrace();
        for (i = 0; i < Math.min(3, aste.length); ++i) {
            sb.append(aste[i].toString());
            sb.append("; ");
        }
        if (ex.getCause() != null) {
            sb.append("caused by ");
            aste = ex.getCause().getStackTrace();
            for (i = 0; i < Math.min(3, aste.length); ++i) {
                sb.append(aste[i].toString());
                sb.append("; ");
            }
        }
        SimpleElement se = new SimpleElement("throwable", sb.toString());
        rss.addElement(se);
        try (BufferedWriter bw = null;){
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(this._errorspath, filename)), 24576), "UTF-8"));
            rss.toXML((Writer)bw);
        }
        catch (Throwable th) {
            LOGGER.warn("while dump [" + new File(this._errorspath, filename).getAbsolutePath() + "] got [" + th.getMessage() + "]", th);
        }
        rss.removeElement(se);
    }
}

