/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.data;

import it.jrc.extract.data.DatabaseException;
import it.jrc.extract.data.MatchStore;
import it.jrc.extract.data.NormalizeStore;
import it.jrc.extract.model.Profile;
import it.jrc.extract.model.Type;
import it.jrc.extract.model.Variant;
import it.jrc.extract.tools.SignatureHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.Driver;

public final class VariantDatabase
implements MatchStore,
NormalizeStore {
    private ConnectionPool _connectionpool;
    private SignatureHelper _sighel;
    private static final Logger LOGGER = LogManager.getLogger(VariantDatabase.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String databasefile, String ponderationpath) throws DatabaseException {
        try {
            Driver.load();
            LOGGER.info("init(" + databasefile + ") database");
            this._connectionpool = new ConnectionPool(databasefile);
            try (Connection connection = null;){
                connection = this._connectionpool.createConnection();
                try {
                    ArrayList<String> ls = new ArrayList<String>();
                    ResultSet rs = connection.getMetaData().getTables(null, null, null, null);
                    while (rs.next()) {
                        ls.add(rs.getString("TABLE_NAME").toLowerCase());
                    }
                    rs.close();
                    if (ls.contains("variant")) {
                        rs = connection.createStatement().executeQuery("SELECT count(*) FROM variant");
                        rs.next();
                        LOGGER.info("variant table has #" + rs.getInt(1) + " records");
                        rs.close();
                    } else {
                        LOGGER.warn("database seems to be empty");
                    }
                }
                catch (SQLException sqlex) {
                    throw new DatabaseException(sqlex);
                }
            }
        }
        catch (SQLException sqlex) {
            LOGGER.warn("cannot init()");
            throw new DatabaseException(sqlex);
        }
        if (ponderationpath != null) {
            try {
                this._sighel = new SignatureHelper(ponderationpath);
            }
            catch (IOException ioex) {
                throw new DatabaseException("cannot init signature helper at [" + ponderationpath + "]", ioex);
            }
        }
    }

    public void term() throws DatabaseException {
        this._sighel = null;
        try {
            this._connectionpool.term();
            this._connectionpool = null;
        }
        catch (SQLException sqlex) {
            LOGGER.warn("cannot term()");
            throw new DatabaseException(sqlex);
        }
        Driver.unload();
    }

    public int numVariants() throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            ResultSet rs = pc.getConnection().createStatement().executeQuery("SELECT count(*) FROM variant");
            rs.next();
            int result = rs.getInt(1);
            rs.close();
            int n = result;
            return n;
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    @Override
    public String getWildcardSingleOperator() {
        return "_";
    }

    @Override
    public String getWildcardMultipleOperator() {
        return "%";
    }

    @Override
    public String getFuzzyOperator() {
        return null;
    }

    @Override
    public List<String> getSignatures(String variant) {
        List<String> result = this._sighel.getSignatures(variant);
        return result;
    }

    @Override
    public List<Variant> getVariantsByVariantSignature(String signature) throws DatabaseException {
        ArrayList<Variant> result = new ArrayList<Variant>();
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            PreparedStatement ps = null;
            ps = signature.contains("_") || signature.contains("%") ? pc.prepareStatement("SELECT key, id, type, source, variant, languages FROM variant WHERE signature LIKE ?") : pc.prepareStatement("SELECT key, id, type, source, variant, languages FROM variant WHERE signature = ?");
            ps.setString(1, signature);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new Variant(rs.getLong(1), rs.getLong(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6)));
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        return result;
    }

    @Override
    public Variant hasVariant(String variant, String type) throws DatabaseException {
        Variant result = null;
        PooledConnection pc = null;
        try {
            ResultSet rs;
            pc = this._connectionpool.acquireConnection();
            PreparedStatement ps = pc.prepareStatement("SELECT key, id, type, source, variant, languages FROM variant WHERE variant = ?" + (type != null ? " AND type = ?" : ""));
            ps.setString(1, variant);
            if (type != null) {
                ps.setString(2, type);
            }
            if ((rs = ps.executeQuery()).next()) {
                result = new Variant(rs.getLong(1), rs.getLong(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6));
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        return result;
    }

    @Override
    public long[] store(long id, String type, String source, String variant) throws DatabaseException {
        long[] result = null;
        if (id == -1L) {
            result = this.addProfile(type, source, variant, null);
        } else {
            result = new long[]{-1L, id};
            if (this.hasVariant(variant, type) == null) {
                long r;
                result[0] = r = this.addVariant(result[1], source, variant, null);
            }
        }
        return result;
    }

    public Variant getVariantByKey(long key) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            Variant variant = this.getVariantByKey(pc, key);
            return variant;
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    private Variant getVariantByKey(PooledConnection c, long key) throws SQLException {
        Variant result = null;
        PreparedStatement ps = c.prepareStatement("SELECT key, id, type, source, variant, languages FROM variant WHERE key = ?");
        ps.setLong(1, key);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = new Variant(rs.getLong(1), rs.getLong(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6));
        }
        rs.close();
        return result;
    }

    @Override
    public Variant getCanonicalVariantByKey(long key) throws DatabaseException {
        Variant result = null;
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            PreparedStatement ps = pc.prepareStatement("SELECT key, id, type, source, variant, languages FROM variant WHERE id = (SELECT id FROM variant WHERE key = ?) AND canonical = true");
            ps.setLong(1, key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new Variant(rs.getLong(1), rs.getLong(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6));
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        return result;
    }

    public List<Variant> getVariantsDeleted() throws DatabaseException {
        ArrayList<Variant> result = new ArrayList<Variant>();
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            PreparedStatement ps = pc.prepareStatement("SELECT key, id, type, source, variant, languages FROM variant WHERE languages = '-u'");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new Variant(rs.getLong(1), rs.getLong(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6)));
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        return result;
    }

    public List<Variant> getVariantsById(long id) throws DatabaseException {
        ArrayList<Variant> result = new ArrayList<Variant>();
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            PreparedStatement ps = pc.prepareStatement("SELECT key, type, source, variant, languages FROM variant WHERE id = ? ORDER BY canonical DESC");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new Variant(rs.getLong(1), id, rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5)));
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        return result;
    }

    public List<Variant> getVariantsByType(String type) throws DatabaseException {
        ArrayList<Variant> result = new ArrayList<Variant>();
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            PreparedStatement ps = pc.prepareStatement("SELECT key, id, source, variant, languages FROM variant WHERE type = ?");
            ps.setString(1, type);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new Variant(rs.getLong(1), rs.getLong(2), type, rs.getString(3), rs.getString(4), rs.getString(5)));
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        return result;
    }

    public List<Profile> queryProfilesBy(String variant) throws DatabaseException {
        ArrayList<Variant> lvariants = new ArrayList<Variant>();
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            PreparedStatement ps = pc.prepareStatement("SELECT key, id, type, source, variant, languages FROM variant WHERE id IN (SELECT id FROM variant WHERE LOWER(variant) LIKE LOWER(?)) ORDER BY id, canonical DESC");
            ps.setString(1, variant);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                lvariants.add(new Variant(rs.getLong(1), rs.getLong(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6)));
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        ArrayList<Profile> result = new ArrayList<Profile>();
        for (int i = 0; i < lvariants.size(); ++i) {
            Variant v = (Variant)lvariants.get(i);
            ArrayList<Variant> lv = new ArrayList<Variant>();
            lv.add(v);
            while (i + 1 < lvariants.size()) {
                Variant vb;
                if ((vb = (Variant)lvariants.get(++i)).getId() != v.getId()) {
                    --i;
                    break;
                }
                lv.add(vb);
            }
            result.add(new Profile(lv));
        }
        return result;
    }

    public List<Variant> queryVariantsBy(String variant) throws DatabaseException {
        ArrayList<Variant> result = new ArrayList<Variant>();
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            PreparedStatement ps = pc.prepareStatement("SELECT key, id, type, source, variant, languages FROM variant WHERE LOWER(variant) LIKE LOWER(?)");
            ps.setString(1, variant);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new Variant(rs.getLong(1), rs.getLong(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6)));
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        return result;
    }

    public List<Variant> queryCanonicalVariantsBy(String type, String variant) throws DatabaseException {
        ArrayList<Variant> result = new ArrayList<Variant>();
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            PreparedStatement ps = pc.prepareStatement("SELECT key, id, type, source, variant, languages FROM variant WHERE id IN (SELECT id FROM variant WHERE (? IS NULL OR type = ?) AND (? IS NULL OR variant LIKE ?)) AND canonical = true");
            if (type == null) {
                ps.setNull(1, 12);
                ps.setNull(2, 12);
            } else {
                ps.setString(1, type);
                ps.setString(2, type);
            }
            if (variant == null) {
                ps.setNull(3, 12);
                ps.setNull(4, 12);
            } else {
                ps.setString(3, variant);
                ps.setString(4, variant);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new Variant(rs.getLong(1), rs.getLong(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6)));
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        return result;
    }

    public Variant addProfile(Variant v) throws DatabaseException {
        long[] r = this.addProfile(v.getType(), v.getSource(), v.getVariant(), v.getLanguages());
        return new Variant(r[0], r[1], v.getType(), v.getSource(), v.getVariant(), v.getLanguages());
    }

    public long[] addProfile(String type, String source, String variant, String languages) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            long key = this.sequenceVariantKeyNextval(pc);
            long id = this.sequenceVariantIdNextval(pc);
            PreparedStatement ps = pc.prepareStatement("INSERT INTO variant VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, key);
            ps.setLong(2, id);
            ps.setString(3, type);
            ps.setString(4, source);
            ps.setString(5, variant);
            if (languages != null) {
                ps.setString(6, languages);
            } else {
                ps.setNull(6, 12);
            }
            ps.setBoolean(7, true);
            ps.setString(8, this._sighel.getSignature(variant));
            ps.execute();
            pc.commit();
            long[] lArray = new long[]{key, id};
            return lArray;
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    public Variant addVariant(Variant v) throws DatabaseException {
        long r = this.addVariant(v.getId(), v.getSource(), v.getVariant(), v.getLanguages());
        return new Variant(r, v.getId(), v.getType(), v.getSource(), v.getVariant(), v.getLanguages());
    }

    public long addVariant(long id, String source, String variant, String languages) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            String type = null;
            PreparedStatement ps = pc.prepareStatement("SELECT type FROM variant WHERE id = ? ORDER BY canonical DESC");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                type = rs.getString(1);
            }
            rs.close();
            if (type == null) {
                throw new DatabaseException("cannot addVariant(" + variant + ") to profile id [" + id + "] because profile doesn't exist");
            }
            long key = this.sequenceVariantKeyNextval(pc);
            ps = pc.prepareStatement("INSERT INTO variant VALUES(?, ?, ?, ?, ?, ?, false, ?)");
            ps.setLong(1, key);
            ps.setLong(2, id);
            ps.setString(3, type);
            ps.setString(4, source);
            ps.setString(5, variant);
            if (languages != null) {
                ps.setString(6, languages);
            } else {
                ps.setNull(6, 12);
            }
            ps.setString(7, this._sighel.getSignature(variant));
            ps.execute();
            pc.commit();
            long l = key;
            return l;
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    public void updateProfileId(long id, long tid) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            boolean b = false;
            PreparedStatement ps = pc.prepareStatement("SELECT * FROM DUAL WHERE EXISTS (SELECT * FROM variant WHERE id = ?)");
            ps.setLong(1, tid);
            ResultSet rs = ps.executeQuery();
            b = rs.next();
            rs.close();
            if (!b) {
                ps = pc.prepareStatement("UPDATE variant SET id = ? WHERE id = ?");
                ps.setLong(1, tid);
                ps.setLong(2, id);
                ps.execute();
            } else {
                this.updateVariantsProfile(pc, id, tid);
            }
            pc.commit();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    public void updateProfileType(long id, String type) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            this.updateProfileType(pc, id, type);
            pc.commit();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    private void updateProfileType(PooledConnection pc, long id, String type) throws SQLException {
        PreparedStatement ps = pc.prepareStatement("UPDATE variant SET type = ? WHERE id = ?");
        ps.setString(1, type);
        ps.setLong(2, id);
        ps.execute();
    }

    public void updateVariantSource(long key, String source) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            this.updateVariantSource(pc, key, source);
            pc.commit();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    private void updateVariantSource(PooledConnection pc, long key, String source) throws SQLException {
        PreparedStatement ps = pc.prepareStatement("UPDATE variant SET source = ? WHERE key = ?");
        ps.setString(1, source);
        ps.setLong(2, key);
        ps.execute();
    }

    public void updateVariant(Variant v) throws DatabaseException {
        if (v.getKey() == -1L) {
            throw new AssertionError((Object)"updateVariant can be called on a variant instantiated from the database (where _key != -1)");
        }
        if (v.getId() == -1L) {
            throw new AssertionError((Object)"updateVariant can be called on a variant instantiated from the database (where _id != -1)");
        }
        if (v.getType() == null) {
            throw new AssertionError((Object)"updateVariant can be called on a variant instantiated from the database (where _type != null)");
        }
        boolean b = false;
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            if (v.wasIdChanged()) {
                this.updateVariantProfile(pc, v.getKey(), v.getId());
                b = true;
            }
            if (v.wasTypeChanged()) {
                this.updateProfileType(pc, v.getId(), v.getType());
                b = true;
            }
            if (v.wasSourceChanged()) {
                this.updateVariantSource(pc, v.getKey(), v.getSource());
                b = true;
            }
            if (v.wasVariantChanged()) {
                this.updateVariantVariant(pc, v.getKey(), v.getVariant());
                b = true;
            }
            if (v.wasLanguageChanged()) {
                this.updateVariantLanguages(pc, v.getKey(), v.getLanguages());
                b = true;
            }
            if (b) {
                pc.commit();
            }
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    public void updateVariantsProfile(long id, long tid) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            this.updateVariantsProfile(pc, id, tid);
            pc.commit();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    private void updateVariantsProfile(PooledConnection pc, long id, long tid) throws SQLException {
        PreparedStatement ps = pc.prepareStatement("UPDATE variant SET id = ?, type = (SELECT type FROM VARIANT where id = ? AND canonical = true), canonical = false WHERE id = ?");
        ps.setLong(1, tid);
        ps.setLong(2, tid);
        ps.setLong(3, id);
        ps.execute();
    }

    public void updateVariantProfile(long key, long tid) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            this.updateVariantProfile(pc, key, tid);
            pc.commit();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    private void updateVariantProfile(PooledConnection pc, long key, long tid) throws SQLException {
        this.updateProfileCanonicalVariantForVariant(pc, key);
        PreparedStatement ps = pc.prepareStatement("UPDATE variant SET id = ?, type = (SELECT type FROM VARIANT where id = ? AND canonical = true), canonical = false WHERE key = ?");
        ps.setLong(1, tid);
        ps.setLong(2, tid);
        ps.setLong(3, key);
        ps.execute();
    }

    public void updateVariantLanguages(long key, String languages) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            this.updateVariantLanguages(pc, key, languages);
            pc.commit();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    private void updateVariantVariant(PooledConnection pc, long key, String variant) throws SQLException {
        PreparedStatement ps = pc.prepareStatement("UPDATE variant SET variant = ?, signature = ? WHERE key = ?");
        ps.setString(1, variant);
        ps.setString(2, this._sighel.getSignature(variant));
        ps.setLong(3, key);
        ps.execute();
    }

    private void updateVariantLanguages(PooledConnection pc, long key, String languages) throws SQLException {
        PreparedStatement ps = pc.prepareStatement("UPDATE variant SET languages = ? WHERE key = ?");
        if (languages != null) {
            ps.setString(1, languages);
        } else {
            ps.setNull(1, 12);
        }
        ps.setLong(2, key);
        ps.execute();
    }

    public void updateVariantCanonical(long key) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            PreparedStatement ps = pc.prepareStatement("UPDATE variant SET canonical = (key = ?) WHERE id = (SELECT id FROM variant WHERE key = ?)");
            ps.setLong(1, key);
            ps.setLong(2, key);
            ps.execute();
            pc.commit();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    public void deleteProfile(Profile p) throws DatabaseException {
        this.deleteProfile(p.getId());
    }

    public void deleteProfile(long id) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            pc.getConnection().createStatement().execute("UPDATE variant SET languages = '-u' WHERE id = " + id);
            pc.commit();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    public void deleteVariant(Variant v) throws DatabaseException {
        this.deleteVariant(v.getKey());
    }

    public void deleteVariant(long key) throws DatabaseException {
        this.updateVariantLanguages(key, "-u");
    }

    public void removeProfile(Profile p) throws DatabaseException {
        this.removeProfile(p.getId());
    }

    public void removeProfile(long id) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            pc.getConnection().createStatement().execute("DELETE FROM variant WHERE id = " + id);
            pc.commit();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    public void removeVariant(Variant v) throws DatabaseException {
        this.removeVariant(v.getKey());
    }

    public void removeVariant(long key) throws DatabaseException {
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            this.updateProfileCanonicalVariantForVariant(pc, key);
            pc.getConnection().createStatement().execute("DELETE FROM variant WHERE key = " + key);
            pc.commit();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
    }

    @Override
    public List<Type> getTypes() throws DatabaseException {
        ArrayList<Type> result = new ArrayList<Type>();
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            ResultSet rs = pc.getConnection().createStatement().executeQuery("SELECT id, description, normalizing FROM types");
            while (rs.next()) {
                result.add(new Type(rs.getString(1), rs.getString(2), rs.getString(3).charAt(0)));
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            throw new DatabaseException(sqlex);
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> execute(String sql) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        PooledConnection pc = null;
        try {
            pc = this._connectionpool.acquireConnection();
            String ssql = sql.toLowerCase().trim();
            if ("commit".equals(ssql)) {
                pc.commit();
                result.add(new String[]{"commit done"});
            } else if ("rollback".equals(ssql)) {
                pc.getConnection().rollback();
                result.add(new String[]{"rollback done"});
            } else if (ssql.startsWith("select")) {
                int i;
                ResultSet rs = pc.getConnection().createStatement().executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                String[] as = new String[rsmd.getColumnCount()];
                for (i = 0; i < rsmd.getColumnCount(); ++i) {
                    as[i] = rsmd.getColumnLabel(i + 1);
                }
                result.add(as);
                while (rs.next()) {
                    as = new String[rsmd.getColumnCount()];
                    for (i = 0; i < rsmd.getColumnCount(); ++i) {
                        as[i] = rs.getString(i + 1);
                    }
                    result.add(as);
                }
                rs.close();
            } else {
                Statement sta = pc.getConnection().createStatement();
                sta.execute(ssql);
                result.add(new String[]{"done, #" + sta.getUpdateCount() + " update count"});
            }
        }
        catch (SQLException sqlex) {
            for (String s : sqlex.getMessage().split("\n")) {
                result.add(new String[]{s});
            }
        }
        finally {
            this._connectionpool.releaseConnection(pc);
        }
        return result;
    }

    private void updateProfileCanonicalVariantForVariant(PooledConnection pc, long key) throws SQLException {
        PreparedStatement ps = pc.prepareStatement("UPDATE variant SET canonical = true WHERE key = (SELECT key FROM variant WHERE id = (SELECT id FROM variant WHERE key = ? AND canonical = true) AND canonical = false ORDER BY languages ASC LIMIT 1)");
        ps.setLong(1, key);
        ps.execute();
    }

    private long sequenceVariantKeyNextval(PooledConnection pc) throws SQLException {
        PreparedStatement ps = pc.prepareStatement("SELECT seqvariantkey.nextval FROM DUAL");
        ResultSet rs = ps.executeQuery();
        rs.next();
        long result = rs.getLong(1);
        rs.close();
        return result;
    }

    private long sequenceVariantIdNextval(PooledConnection pc) throws SQLException {
        PreparedStatement ps = pc.prepareStatement("SELECT seqvariantid.nextval FROM DUAL");
        ResultSet rs = ps.executeQuery();
        rs.next();
        long result = rs.getLong(1);
        rs.close();
        return result;
    }

    public void create() throws DatabaseException {
        try {
            Connection connection = this._connectionpool.createConnection();
            connection.createStatement().execute("DROP SEQUENCE IF EXISTS seqvariantkey");
            connection.createStatement().execute("DROP SEQUENCE IF EXISTS seqvariantid");
            connection.createStatement().execute("CREATE SEQUENCE seqvariantkey START WITH 1");
            connection.createStatement().execute("CREATE SEQUENCE seqvariantid START WITH 1");
            connection.createStatement().execute("DROP TABLE IF EXISTS variant");
            connection.createStatement().execute("CREATE TABLE variant(key LONG NOT NULL, id LONG NOT NULL, type CHAR(16) NOT NULL, source CHAR(1) NOT NULL, variant VARCHAR(255) NOT NULL, languages VARCHAR(255), canonical BOOLEAN NOT NULL, signature VARCHAR(255))");
            connection.createStatement().execute("CREATE PRIMARY KEY ON variant(key)");
            connection.createStatement().execute("CREATE INDEX ixvariantid ON variant(id)");
            connection.createStatement().execute("CREATE INDEX ixvariantvariant ON variant(variant)");
            connection.createStatement().execute("CREATE INDEX ixvariantsignature ON variant(signature)");
            try {
                connection.createStatement().executeQuery("SELECT id FROM types");
            }
            catch (SQLException sqlex) {
                connection.createStatement().execute("CREATE TABLE types(id CHAR(16) NOT NULL, description VARCHAR(255) NOT NULL, normalizing CHAR(1) NOT NULL)");
                connection.createStatement().execute("CREATE PRIMARY KEY ON types(id)");
                connection.createStatement().execute("INSERT INTO types VALUES('p','person','d')");
                connection.createStatement().execute("INSERT INTO types VALUES('o','organization','d')");
                connection.createStatement().execute("INSERT INTO types VALUES('t','toponym','m')");
                connection.createStatement().execute("INSERT INTO types VALUES('u','unknown-unused','d')");
            }
            connection.commit();
            connection.close();
        }
        catch (SQLException sqlex) {
            LOGGER.warn("cannot init()");
            throw new DatabaseException(sqlex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imp(File file, int flag, ProcedureNotify notify) throws DatabaseException {
        try {
            notify.notify("import file [" + file.getAbsolutePath() + "] according to plan [" + flag + "]", null);
            notify.notify("inspect target database...", null);
            Connection connection = null;
            try {
                connection = this._connectionpool.createConnection();
                ArrayList<String> ltype = new ArrayList<String>();
                ResultSet rs = connection.createStatement().executeQuery("SELECT id FROM types");
                while (rs.next()) {
                    ltype.add(rs.getString(1));
                }
                rs.close();
                Object[] atype = ltype.toArray(new String[0]);
                Arrays.sort(atype);
                notify.notify("types table has " + ltype + " types", 0.05);
                connection.createStatement().execute("SET LOG 0");
                connection.createStatement().execute("SET UNDO_LOG 0");
                connection.createStatement().execute("SET LOCK_MODE 0");
                switch (flag) {
                    case 1: 
                    case 2: {
                        notify.notify("re-create target database...", null);
                        this.create();
                        notify.notify(null, 0.1);
                        boolean preserveids = flag == 2;
                        this.imp12(file, connection, (String[])atype, preserveids, notify);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("imp() for flag [" + flag + "] is not supported"));
                    }
                }
                rs = connection.createStatement().executeQuery("SELECT count(*) FROM variant");
                rs.next();
                notify.notify("now variant table has #[" + rs.getInt(1) + "] variants", null);
                rs.close();
                rs = connection.createStatement().executeQuery("SELECT seqvariantkey.currval FROM DUAL");
                rs.next();
                notify.notify("now sequence key current value is #[" + rs.getInt(1) + "]", null);
                rs.close();
                rs = connection.createStatement().executeQuery("SELECT seqvariantid.currval FROM DUAL");
                rs.next();
                notify.notify("now sequence id current value is #[" + rs.getInt(1) + "]", 1.0);
                rs.close();
            }
            finally {
                if (connection != null) {
                    connection.createStatement().execute("SET LOG 2");
                    connection.createStatement().execute("SET UNDO_LOG 1");
                    connection.createStatement().execute("SET LOCK_MODE 3");
                    connection.close();
                }
            }
        }
        catch (IOException ioex) {
            throw new DatabaseException("cannot imp() from [" + file + "]", ioex);
        }
        catch (SQLException sqlex) {
            throw new DatabaseException("cannot imp() from [" + file + "]", sqlex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imp12(File file, Connection connection, String[] atype, boolean preserveids, ProcedureNotify notify) throws IOException, SQLException {
        PreparedStatement pskn = connection.prepareStatement("SELECT seqvariantkey.nextval FROM DUAL");
        PreparedStatement psin = connection.prepareStatement("SELECT seqvariantid.nextval FROM DUAL");
        PreparedStatement psiv = connection.prepareStatement("INSERT INTO variant VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
        long fsize = file.length();
        long live = 0L;
        int cinsert = 0;
        long vid = -1L;
        long lid = -1L;
        HashSet<Long> scanonical = new HashSet<Long>();
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String stream = null;
            while ((stream = br.readLine()) != null) {
                String[] astream = stream.split("\t", -1);
                if (astream.length < 4 || astream.length > 5) {
                    notify.notify("file line #[" + (live + 1L) + "] ignored, wrong number of columns ([" + astream.length + "])", null);
                    continue;
                }
                String sid = astream[1];
                String stype = astream[2].toLowerCase();
                String svariant = astream[3];
                String slanguages = null;
                if (astream.length > 4 && "".equals(slanguages = astream[4].toLowerCase())) {
                    slanguages = null;
                }
                long pid = -1L;
                try {
                    pid = Long.valueOf(sid);
                }
                catch (NumberFormatException nfex) {
                    notify.notify("file line #[" + (live + 1L) + "] ignored, cannot parse id [" + sid + "]", null);
                    continue;
                }
                ResultSet rs = pskn.executeQuery();
                rs.next();
                long ke = rs.getLong(1);
                rs.close();
                if (preserveids) {
                    vid = pid;
                } else if (pid != lid) {
                    lid = pid;
                    rs = psin.executeQuery();
                    rs.next();
                    vid = rs.getLong(1);
                    rs.close();
                }
                boolean canonical = !scanonical.contains(vid);
                psiv.setLong(1, ke);
                psiv.setLong(2, vid);
                psiv.setString(3, stype);
                psiv.setString(4, "g");
                psiv.setString(5, svariant);
                if (slanguages == null) {
                    psiv.setNull(6, 12);
                } else {
                    psiv.setString(6, slanguages);
                }
                psiv.setBoolean(7, canonical);
                psiv.setString(8, this._sighel.getSignature(svariant));
                psiv.execute();
                scanonical.add(vid);
                notify.notify(null, 0.1 + (double)(live += (long)(stream.length() + 2)) / (double)fsize * 0.8);
                ++cinsert;
            }
        }
        notify.notify("import done for #[" + cinsert + "] new variants", 0.93);
        if (preserveids) {
            connection.createStatement().execute("ALTER SEQUENCE seqvariantid RESTART WITH " + (vid + 1L));
        }
        pskn.close();
        psin.close();
        psiv.close();
        connection.commit();
        notify.notify("database commit done", 0.96);
    }

    public void exp(File file, int flag) throws DatabaseException {
        try {
            String FSEPARATOR = "\t";
            String FNULL = "";
            ExportPlan expplan = null;
            switch (flag) {
                case 1: {
                    expplan = new ExportPlan(){

                        @Override
                        public String getSql() {
                            return "SELECT key, id, type, variant, languages FROM variant ORDER BY id ASC, canonical DESC";
                        }

                        @Override
                        public String asString(ResultSet rs) throws SQLException {
                            return rs.getLong(1) + "\t" + rs.getLong(2) + "\t" + rs.getString(3) + "\t" + rs.getString(4) + "\t" + (rs.getString(5) == null ? "" : rs.getString(5));
                        }
                    };
                    break;
                }
                case 2: {
                    expplan = new ExportPlan(){

                        @Override
                        public String getSql() {
                            return "SELECT key, id, type, variant, languages, canonical, signature FROM variant";
                        }

                        @Override
                        public String asString(ResultSet rs) throws SQLException {
                            return rs.getLong(1) + "\t" + rs.getLong(2) + "\t" + rs.getString(3) + "\t" + rs.getString(4) + "\t" + (rs.getString(5) == null ? "" : rs.getString(5)) + "\t" + rs.getBoolean(6) + "\t" + rs.getString(7);
                        }
                    };
                    break;
                }
                case 3: {
                    expplan = new ExportPlan(){

                        @Override
                        public String getSql() {
                            return "SELECT key, id, type, variant, languages, canonical, signature FROM variant";
                        }

                        @Override
                        public String asString(ResultSet rs) throws SQLException {
                            return "INSERT INTO variant VALUES (" + rs.getLong(1) + "," + rs.getLong(2) + ",'" + rs.getString(3) + "','" + rs.getString(4) + "','" + rs.getString(5).replaceAll("'", "''") + "'," + rs.getBoolean(6) + ",'" + rs.getString(7) + "');";
                        }
                    };
                    break;
                }
                default: {
                    throw new AssertionError((Object)("exp() for flag [" + flag + "] is not supported"));
                }
            }
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            Connection connection = this._connectionpool.createConnection();
            ResultSet rs = connection.createStatement().executeQuery(expplan.getSql());
            System.out.println("Exporting");
            while (rs.next()) {
                String expStr = expplan.asString(rs);
                bw.write(expStr);
                bw.newLine();
            }
            rs.close();
            connection.close();
            bw.close();
        }
        catch (IOException ioex) {
            throw new DatabaseException("cannot exp() to [" + file + "]", ioex);
        }
        catch (SQLException sqlex) {
            throw new DatabaseException("cannot exp() to [" + file + "]", sqlex);
        }
    }

    private static final class PooledConnection {
        private Connection _connection;
        private Map<Integer, PreparedStatement> _preparedstatements;

        private PooledConnection(Connection connection) throws SQLException {
            this._connection = connection;
            this._preparedstatements = new HashMap<Integer, PreparedStatement>();
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            PreparedStatement result = null;
            result = this._preparedstatements.get(sql.hashCode());
            if (result == null) {
                result = this._connection.prepareStatement(sql);
                this._preparedstatements.put(sql.hashCode(), result);
            }
            return result;
        }

        private void term() throws SQLException {
            for (PreparedStatement ps : this._preparedstatements.values()) {
                ps.close();
            }
            this._connection.close();
            this._connection = null;
        }

        private Connection getConnection() {
            return this._connection;
        }

        private void commit() throws SQLException {
            this._connection.commit();
        }
    }

    private static final class ConnectionPool {
        private String _databasefile;
        private List<PooledConnection> _lconnections;

        private ConnectionPool(String databasefile) {
            this._databasefile = databasefile;
            this._lconnections = new ArrayList<PooledConnection>();
        }

        private void term() throws SQLException {
            for (PooledConnection pc : this._lconnections) {
                pc.term();
            }
            this._lconnections = null;
            this._databasefile = null;
        }

        private Connection createConnection() throws SQLException {
            return DriverManager.getConnection("jdbc:h2:file:" + this._databasefile + ";AUTOCOMMIT=OFF;LOCK_TIMEOUT=30000;CACHE_SIZE=131072;LOG=1;WRITE_DELAY=90000;", "sa", "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PooledConnection acquireConnection() throws SQLException {
            PooledConnection result = null;
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                if (!this._lconnections.isEmpty()) {
                    result = this._lconnections.remove(this._lconnections.size() - 1);
                }
            }
            if (result == null) {
                Connection c = this.createConnection();
                result = new PooledConnection(c);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseConnection(PooledConnection pc) {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                this._lconnections.add(pc);
            }
        }
    }

    private static interface ExportPlan {
        public String getSql();

        public String asString(ResultSet var1) throws SQLException;
    }

    public static interface ProcedureNotify {
        public void notify(String var1, Double var2);
    }
}

