/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.model;

import it.jrc.extract.model.Evidence;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class Article {
    private RSSItem _rssi;
    private List<Evidence> _evidences;

    public Article(RSSItem rssitem) {
        String[] as;
        this._rssi = rssitem;
        this._evidences = new ArrayList<Evidence>();
        for (String s : as = new String[]{"emm:entity", "emm:georss", "emm:guess", "emm:extractg"}) {
            for (SimpleElement se : this.getElements(s)) {
                Evidence e = new Evidence(se);
                int i = this._evidences.indexOf(e);
                if (i == -1) {
                    this._evidences.add(e);
                    continue;
                }
                this._evidences.get(i).merge(se);
            }
        }
    }

    public String getGuid() {
        return this._rssi.getGuid();
    }

    public String getPubDate() {
        return this._rssi.getPubDate().substring(0, 4) + this._rssi.getPubDate().substring(5, 7) + this._rssi.getPubDate().substring(8, 10) + this._rssi.getPubDate().substring(11, 13) + this._rssi.getPubDate().substring(14, 16);
    }

    public String getLanguage() {
        return this._rssi.getLanguage();
    }

    private Collection<SimpleElement> getElements(String name) {
        ArrayList<SimpleElement> result = new ArrayList<SimpleElement>();
        ArrayList alse = this._rssi.getElements(name);
        if (alse != null) {
            for (SimpleElement se : alse) {
                result.add(se);
            }
        }
        return result;
    }

    public Collection<Evidence> getEvidences() {
        return this._evidences;
    }

    public Collection<Evidence> getEvidences(String flavor) {
        ArrayList<Evidence> result = new ArrayList<Evidence>();
        for (Evidence e : this._evidences) {
            if (!e.getUid().startsWith(flavor)) continue;
            result.add(e);
        }
        return result;
    }

    private List<Marker> getMarkers() {
        final class ShadowMeta {
            private String _key;
            private int _start;
            private int _stop;

            ShadowMeta(String key, String pos, String originaltext) {
                this._key = key.concat(",");
                this._start = Integer.parseInt(pos);
                this._stop = this._start + originaltext.length();
            }
        }
        ArrayList<ShadowMeta> alsm = new ArrayList<ShadowMeta>();
        for (Evidence ev : this.getEvidences()) {
            for (Map.Entry<String, List<String>> e : ev.getPositions().entrySet()) {
                for (String p : e.getValue()) {
                    alsm.add(new ShadowMeta(ev.getUid(), p, e.getKey()));
                }
            }
        }
        ArrayList<Marker> result = new ArrayList<Marker>();
        result.add(new Marker(0, "<span id=\"articletitle\" class=\"articletitle\">"));
        result.add(new Marker(this._rssi.getTitle().length() + 3, "</span><br>"));
        TreeSet<Integer> tsi = new TreeSet<Integer>();
        for (ShadowMeta sm : alsm) {
            tsi.add(sm._start);
            tsi.add(sm._stop);
        }
        for (Integer i : tsi) {
            ArrayList<String> lkeysstart = new ArrayList<String>();
            boolean bover = false;
            boolean bstop = false;
            for (ShadowMeta sm : alsm) {
                if (i == sm._start) {
                    lkeysstart.add(sm._key);
                }
                if (i > sm._start && i < sm._stop) {
                    lkeysstart.add(sm._key);
                    bover = true;
                }
                if (i != sm._stop) continue;
                bstop = true;
            }
            if (bstop || bover) {
                result.add(new Marker(i + 1, "</span>"));
            }
            if (lkeysstart.isEmpty()) continue;
            Collections.sort(lkeysstart);
            StringBuilder sbkeys = new StringBuilder(256);
            for (String k : lkeysstart) {
                sbkeys.append(k);
            }
            result.add(new Marker(i + 1, "<span id=\"articleshadow\" keys=\"" + sbkeys.toString() + "\">"));
        }
        Collections.sort(result, new Comparator<Marker>(){

            @Override
            public int compare(Marker obj1, Marker obj2) {
                int result = obj1._pos - obj2._pos;
                if (result == 0) {
                    result = obj1._att.compareTo(obj2._att);
                }
                return result;
            }
        });
        Collections.reverse(result);
        return result;
    }

    public String getText() {
        String result = " " + this._rssi.getTitle() + ". " + this._rssi.getText() + " ";
        for (Marker ma : this.getMarkers()) {
            result = result.substring(0, ma.getPos()) + ma.getAtt() + result.substring(ma.getPos());
        }
        result = result.replaceAll("'", "&#39").replaceAll("\n", " ");
        return result;
    }

    public final class Marker {
        private int _pos;
        private String _att;

        private Marker(int pos, String att) {
            this._pos = pos;
            this._att = att;
        }

        public int getPos() {
            return this._pos;
        }

        public String getAtt() {
            return this._att;
        }
    }
}

