/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.model;

import it.jrc.rss.SimpleAttribute;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Evidence {
    private static int _sequence = 2;
    private String _uid = null;
    private String _id = null;
    private String _type = null;
    private String _description = null;
    private String _fullname = null;
    private Map<String, List<String>> _positions = new HashMap<String, List<String>>();
    private List<String> _attributes = new ArrayList<String>();

    private Evidence() {
    }

    public Evidence(SimpleElement se) {
        this();
        if ("emm:entity".equals(se.getName())) {
            this._id = se.getAttributeValue("id");
            this._type = se.getAttributeValue("type");
            this._uid = "e" + this._type + this._id;
            this._description = "entity [" + this._id + "] type " + this._type;
            this._fullname = se.getAttributeValue("name");
        } else if ("emm:georss".equals(se.getName())) {
            this._id = se.getAttributeValue("id");
            this._type = "l";
            this._uid = "l" + this._type + this._id;
            this._description = "georss [" + this._id + "]";
            this._fullname = se.getAttributeValue("name");
        } else if ("emm:guess".equals(se.getName())) {
            this._id = "c" + String.valueOf(_sequence++);
            this._type = se.getAttributeValue("type");
            this._uid = this._id.substring(0, 1) + this._type + this._id;
            this._description = "candidate [" + this._id + "] type " + this._type;
            this._fullname = se.getAttributeValue("name");
        } else if ("emm:extractg".equals(se.getName())) {
            this._id = String.valueOf(_sequence++);
            this._type = se.getAttributeValue("typex");
            this._uid = "g" + this._type + this._id;
            this._description = "ifs type " + this._type;
        } else {
            throw new AssertionError((Object)("this SimpleElement [" + se.getName() + "] is not supported"));
        }
        this.merge(se);
    }

    public String getUid() {
        return this._uid;
    }

    public String getId() {
        return this._id;
    }

    public String getType() {
        return this._type;
    }

    public String getDescription() {
        return this._description;
    }

    public String getFullname() {
        return this._fullname;
    }

    public Map<String, List<String>> getPositions() {
        return this._positions;
    }

    public List<String> getAttributes() {
        return this._attributes;
    }

    public void merge(SimpleElement se) {
        this.addPosition(se);
        this.addAttributes(se);
    }

    private void addPosition(SimpleElement se) {
        String val = se.getValue();
        String pos = se.getAttributeValue("pos");
        List<String> lpos = this._positions.get(val);
        if (lpos == null) {
            lpos = new ArrayList<String>();
            this._positions.put(val, lpos);
        }
        for (String s : pos.split(",", -1)) {
            if ("".equals(s) || lpos.contains(s)) continue;
            lpos.add(s);
        }
    }

    private void addAttributes(SimpleElement se) {
        ArrayList<String> ls = new ArrayList<String>();
        if ("emm:georss".equals(se.getName())) {
            ls.add("class = " + se.getAttributeValue("class"));
            ls.add("lat = " + se.getAttributeValue("lat"));
            ls.add("lon = " + se.getAttributeValue("lon"));
        } else if ("emm:entity".equals(se.getName())) {
            if (se.getAttributeValue("functions") != null) {
                ls.add("functions = " + se.getAttributeValue("functions"));
            }
        } else if ("emm:guess".equals(se.getName())) {
            if (se.getAttributeValue("functions") != null) {
                ls.add("functions = " + se.getAttributeValue("functions"));
            }
        } else if ("emm:extractg".equals(se.getName())) {
            for (SimpleAttribute sa : se.getAttributes()) {
                if ("pos".equals(sa.name)) continue;
                ls.add(sa.name + " = " + sa.value);
            }
        }
        for (String s : ls) {
            if (this._attributes.contains(s)) continue;
            this._attributes.add(s);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Evidence)) {
            return false;
        }
        Evidence lobj = (Evidence)obj;
        return lobj._uid.equals(this._uid);
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this._uid.hashCode();
        return result;
    }
}

