/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.service;

import it.jrc.extract.service.VariantException;
import it.jrc.lt.regexpfs.GrammarInterpreter;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFSDArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.module.CorleoneExternal;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VariantGuess {
    private GrammarInterpreter _gi;
    private boolean _verbose;
    public boolean _dolocations;
    private static final Logger LOGGER = LogManager.getLogger(VariantGuess.class);
    private static final Logger GUESS = LogManager.getLogger((String)"it.jrc.extract.guessing");

    public VariantGuess(String grammarpath, boolean verbose) throws VariantException {
        LOGGER.info("VariantGuess({})", new Object[]{grammarpath});
        boolean bverbose = verbose;
        Properties confProperties = new Properties();
        File[] af = new File(grammarpath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File fil) {
                return fil.getName().endsWith(".grm");
            }
        });
        if (af == null || af.length != 1) {
            throw new VariantException("cannot launch the GrammarInterpreter in [" + grammarpath + "] because #[" + (af == null ? 0 : af.length) + "] grammar file(s) where found instead of [1]");
        }
        LOGGER.info("VariantGuess({}) using grammar file [{}]", new Object[]{grammarpath, af[0].getName()});
        confProperties.put("CascadedGrammarFile", af[0].getAbsolutePath());
        confProperties.put("ModuleConfigDirectory", grammarpath);
        confProperties.put("CharacterSet", "UTF-8");
        confProperties.put("DebugModusOn", String.valueOf(bverbose));
        confProperties.put("DebugAllGrammarsOn", String.valueOf(bverbose));
        confProperties.put("SplitingFilesIntoLine", "false");
        this._gi = new GrammarInterpreter();
        if (!this._gi.launch(confProperties)) {
            throw new VariantException("cannot launch the GrammarInterpreter in [" + grammarpath + "] because _gi.launch() got [false]");
        }
        this._verbose = bverbose;
    }

    public void doLocations() {
        this._dolocations = true;
    }

    public void process(RSSItem rssi, boolean evidence) throws VariantException {
        LOGGER.debug("receives process on item [{}]", new Object[]{rssi.getGuid()});
        CorleoneExternal.setData((ArrayList)rssi.getElements());
        String stream = null;
        int ltitle = 0;
        if (rssi.getTitle() != null && !"".equals(rssi.getTitle())) {
            stream = rssi.getTitle() + ". " + rssi.getText();
            ltitle = rssi.getTitle().length() + 2;
        } else {
            stream = rssi.getText();
        }
        InputFSDArrayList ifsdal = null;
        ifsdal = this._verbose ? this._gi.applyToTextDebug(stream.toCharArray()) : this._gi.applyOnText(stream.toCharArray());
        InputFSArrayList ifsal = ifsdal.convertToFlatList();
        ArrayList<SimpleElement> known = rssi.getElements("emm:entity");
        if (known == null) {
            known = new ArrayList<SimpleElement>();
        }
        GuessHelper gh = new GuessHelper(evidence, stream, ltitle, known, this._dolocations);
        for (int i = 0; i < ifsal.size(); ++i) {
            InputFeatureStructure ifs = ifsal.get(i);
            gh.add(ifs);
        }
        if (!evidence) {
            LOGGER.info("process item [{}] text (length [{}]) with #[{}] entity got #[{}] ifs -> got #[{}] guess variants", new Object[]{rssi.getGuid(), stream.length(), known.size(), ifsal.size(), gh._lgv.size()});
            String language = rssi.getLanguage();
            for (SimpleElement simpleElement : gh._known) {
                boolean bknown = gh._knowng.contains(simpleElement.getValue());
                GUESS.info("{}\t{}\t{}\t{}", new Object[]{language, (bknown ? "+" : "") + simpleElement.getAttributeValue("id"), simpleElement.getAttributeValue("type"), simpleElement.getValue()});
            }
            for (GuessVariant guessVariant : gh._lgv) {
                GUESS.info("{}\t-1\t{}\t{}", new Object[]{language, guessVariant._type, guessVariant._surface});
            }
        }
        if (evidence) {
            for (SimpleElement se : gh._levidence) {
                rssi.addElement(se);
            }
        }
        String context = null;
        if (LOGGER.isDebugEnabled()) {
            context = "                    ".concat(stream).concat("                    ");
        }
        for (GuessVariant guessVariant : gh._lgv) {
            SimpleElement se = new SimpleElement("emm:guess", guessVariant._surface);
            String type = guessVariant._type;
            se.addAttribute("type", type);
            se.addAttribute("name", guessVariant._name);
            if (guessVariant._sbname != null) {
                se.addAttribute("bnames", guessVariant.getBNames());
            }
            if (guessVariant._siname != null) {
                se.addAttribute("inames", guessVariant.getINames());
            }
            if (guessVariant._ltitle != null) {
                se.addAttribute("titles", guessVariant.getTitles());
            }
            if (guessVariant._lfunction != null) {
                se.addAttribute("functions", guessVariant.getFunctions());
            }
            if (guessVariant._lnationality != null) {
                se.addAttribute("nationalities", guessVariant.getNationalities());
            }
            se.addAttribute("pos", guessVariant.getPositions());
            se.addAttribute("rules", guessVariant.getRules());
            rssi.addElement(se);
            if (!LOGGER.isDebugEnabled()) continue;
            StringBuilder contextlist = new StringBuilder(256);
            Iterator iterator = guessVariant._sposition.iterator();
            while (iterator.hasNext()) {
                int p = (Integer)iterator.next();
                contextlist.append(" |").append(context.substring(Math.max(p - 20, 0), Math.min(p + guessVariant._surface.length() + 40, context.length())));
            }
            LOGGER.debug("guess [{}] {}{}", new Object[]{guessVariant._name, known.size(), contextlist});
        }
        if (LOGGER.isDebugEnabled()) {
            for (Map.Entry entry : gh._mrulehits.entrySet()) {
                LOGGER.debug("guess rules hits: {}", new Object[]{entry.toString()});
            }
        }
    }

    private static final class Function {
        private int _pos;
        private String _function;

        private Function(int pos, String function) {
            this._pos = pos;
            this._function = function;
        }
    }

    private static final class GuessVariant {
        private String _surface;
        private String _type;
        private String _name;
        private Set<String> _sbname;
        private Set<String> _siname;
        private Set<Integer> _sposition;
        private List<Function> _ltitle;
        private List<Function> _lfunction;
        private List<Function> _lnationality;
        private Set<String> _srule;

        private GuessVariant(String surface, String type) {
            this._surface = surface;
            this._type = type;
            this._sposition = new HashSet<Integer>();
            this._srule = new HashSet<String>();
        }

        public String getPositions() {
            StringBuilder result = new StringBuilder(32);
            for (Integer p : this._sposition) {
                result.append(",").append(p);
            }
            return result.substring(1);
        }

        public void addPosition(int position) {
            this._sposition.add(position);
        }

        private String getBNames() {
            StringBuilder result = new StringBuilder(32);
            for (String s : this._sbname) {
                result.append(",").append(s);
            }
            return result.substring(1);
        }

        private String getINames() {
            StringBuilder result = new StringBuilder(32);
            for (String s : this._siname) {
                result.append(",").append(s);
            }
            return result.substring(1);
        }

        private void addNames(String name, String bname, String iname) {
            if (this._name == null) {
                this._name = name;
            }
            if (!this._name.equals(name)) {
                throw new AssertionError();
            }
            if (bname != null && !this._name.equals(bname)) {
                if (this._sbname == null) {
                    this._sbname = new HashSet<String>();
                }
                this._sbname.add(bname);
            }
            if (iname != null) {
                if (this._siname == null) {
                    this._siname = new HashSet<String>();
                }
                this._siname.add(iname);
            }
        }

        private String getTitles() {
            StringBuilder result = new StringBuilder(32);
            for (Function f : this._ltitle) {
                result.append(",").append(f._function);
            }
            return result.substring(1);
        }

        private String getFunctions() {
            StringBuilder result = new StringBuilder(32);
            for (Function f : this._lfunction) {
                result.append(",").append(f._function);
            }
            return result.substring(1);
        }

        private String getNationalities() {
            StringBuilder result = new StringBuilder(32);
            for (Function f : this._lnationality) {
                result.append(",").append(f._function);
            }
            return result.substring(1);
        }

        public void addFunctions(int pos, String title, String function, String nationality) {
            boolean b;
            if (title != null && !"".equals(title)) {
                if (this._ltitle == null) {
                    this._ltitle = new ArrayList<Function>();
                }
                b = true;
                for (Function f : this._ltitle) {
                    if (pos != f._pos || !title.equals(f._function)) continue;
                    b = false;
                    break;
                }
                if (b) {
                    this._ltitle.add(new Function(pos, title));
                }
            }
            if (function != null && !"".equals(function)) {
                if (this._lfunction == null) {
                    this._lfunction = new ArrayList<Function>();
                }
                b = true;
                for (Function f : this._lfunction) {
                    if (pos != f._pos || !function.equals(f._function)) continue;
                    b = false;
                    break;
                }
                if (b) {
                    this._lfunction.add(new Function(pos, function));
                }
            }
            if (nationality != null && !"".equals(nationality)) {
                if (this._lnationality == null) {
                    this._lnationality = new ArrayList<Function>();
                }
                b = true;
                for (Function f : this._lnationality) {
                    if (pos != f._pos || !nationality.equals(f._function)) continue;
                    b = false;
                    break;
                }
                if (b) {
                    this._lnationality.add(new Function(pos, nationality));
                }
            }
        }

        public String getRules() {
            StringBuilder result = new StringBuilder(32);
            for (String r : this._srule) {
                result.append(",").append(r);
            }
            return result.substring(1);
        }

        public void addRule(String rule, String confidence) {
            this._srule.add(confidence.concat("_").concat(rule));
        }
    }

    protected static final class GuessHelper {
        private String _stream;
        private int _ltitle;
        private List<SimpleElement> _known;
        private List<GuessVariant> _lgv;
        private List<String> _knowng;
        private Map<String, Integer> _mrulehits;
        private List<SimpleElement> _levidence;
        private boolean _dolocations;

        protected GuessHelper(boolean evidence, String stream, int ltitle, List<SimpleElement> known, boolean dolocations) {
            this._stream = stream;
            this._ltitle = ltitle;
            this._known = known;
            this._lgv = new ArrayList<GuessVariant>();
            this._knowng = new ArrayList<String>();
            if (LOGGER.isDebugEnabled()) {
                this._mrulehits = new HashMap<String, Integer>();
            }
            if (evidence) {
                this._levidence = new ArrayList<SimpleElement>();
            }
            this._dolocations = dolocations;
        }

        protected GuessVariant getGuessVariant(String surface, String type) {
            for (GuessVariant gv : this._lgv) {
                if (!surface.equals(gv._surface) || !type.equals(gv._type)) continue;
                return gv;
            }
            GuessVariant result = new GuessVariant(surface, type);
            this._lgv.add(result);
            return result;
        }

        private SimpleElement isKnown(String ifssurface, String ifsname, String ifsbname, String ifsiname) {
            SimpleElement result = null;
            for (SimpleElement se : this._known) {
                String name = se.getAttributeValue("name");
                String value = se.getValue();
                if (name.equals(ifsname) || value.equals(ifsname)) {
                    result = se;
                    break;
                }
                if (name.equals(ifssurface) || value.equals(ifssurface)) {
                    result = se;
                    break;
                }
                if (ifsbname != null && (name.equals(ifsbname) || value.equals(ifsbname))) {
                    result = se;
                    break;
                }
                if (ifsiname == null || !name.equals(ifsiname) && !value.equals(ifsiname)) continue;
                result = se;
                break;
            }
            return result;
        }

        protected void add(InputFeatureStructure ifs) {
            String ifsrule = ifs.getValue(0);
            if (LOGGER.isDebugEnabled()) {
                if (!this._mrulehits.containsKey(ifsrule)) {
                    this._mrulehits.put(ifsrule, 1);
                } else {
                    this._mrulehits.put(ifsrule, this._mrulehits.get(ifsrule) + 1);
                }
            }
            if (ifsrule.startsWith("person")) {
                this.addAsPerson(ifs, ifsrule);
            } else if (ifsrule.startsWith("org")) {
                this.addAsOrganization(ifs, ifsrule);
            } else if (ifsrule.startsWith("location") && this._dolocations) {
                this.addAsLocation(ifs, ifsrule);
            }
        }

        private void addAsPerson(InputFeatureStructure ifs, String ifsrule) {
            String ifsconfidence = ifs.getValue(1);
            String ifstype = ifs.getValue(2);
            String ifsname = ifs.getValue(3);
            String ifsrfname = ifs.getValue(6);
            String ifsrlname = ifs.getValue(7);
            String ifsgfname = ifs.getValue(8);
            String ifsglname = ifs.getValue(9);
            String ifsbname = ifs.getValue(4);
            String ifsbfname = ifs.getValue(10);
            String ifsblname = ifs.getValue(11);
            String ifsiname = ifs.getValue(5);
            String ifstit = ifs.getValue(12);
            String ifsfun = ifs.getValue(13);
            String ifssubtype = ifs.getValue(14);
            String ifsnat = ifs.getValue(15);
            String ifssurface = this._stream.substring(ifs.getStart(), ifs.getEnd() + 1);
            boolean intitle = ifs.getStart() < this._ltitle;
            String gtype = null;
            if ("Person".equals(ifstype)) {
                gtype = "p";
            }
            SimpleElement gknown = this.isKnown(ifssurface, ifsname, ifsbname, ifsiname);
            boolean ghasfun = ifsfun != null;
            String gfun = ifsfun != null ? ifsfun.replaceAll(",", "") : ifsfun;
            boolean newline = ifssurface.matches(".*[\t\n\r\f]{2,}.*");
            if (this._levidence != null) {
                SimpleElement se = new SimpleElement("emm:extractg", ifssurface);
                se.addAttribute("rule", ifsrule);
                se.addAttribute("confidence", ifsconfidence);
                se.addAttribute("pos", String.valueOf(ifs.getStart()));
                se.addAttribute("type", ifstype);
                se.addAttribute("typex", gtype);
                se.addAttribute("name", ifsname);
                se.addAttribute("knownx", String.valueOf(gknown != null));
                if (ifsbname != null) {
                    se.addAttribute("bname", ifsbname);
                }
                if (ifsiname != null) {
                    se.addAttribute("iname", ifsiname);
                }
                if (ifsrfname != null) {
                    se.addAttribute("rfname", ifsrfname);
                }
                if (ifsrlname != null) {
                    se.addAttribute("rlname", ifsrlname);
                }
                if (ifsgfname != null) {
                    se.addAttribute("gfname", ifsgfname);
                }
                if (ifsglname != null) {
                    se.addAttribute("glname", ifsglname);
                }
                if (ifsbfname != null) {
                    se.addAttribute("bfname", ifsbfname);
                }
                if (ifsblname != null) {
                    se.addAttribute("blname", ifsblname);
                }
                if (ifstit != null) {
                    se.addAttribute("title", ifstit);
                }
                if (ifsfun != null) {
                    se.addAttribute("func", ifsfun);
                }
                if (gfun != null) {
                    se.addAttribute("funcx", gfun);
                }
                if (ifsnat != null) {
                    se.addAttribute("nat", ifsnat);
                }
                se.addAttribute("intitlex", String.valueOf(intitle));
                se.addAttribute("newlinex", String.valueOf(newline));
                this._levidence.add(se);
            }
            if (intitle) {
                return;
            }
            if (newline) {
                return;
            }
            if (gknown != null) {
                this._knowng.add(gknown.getValue());
                if (!ghasfun) {
                    return;
                }
                String f = gknown.getAttributeValue("functions");
                if (f == null) {
                    gknown.addAttribute("functions", gfun);
                } else {
                    gknown.removeAttribute("functions");
                    gknown.addAttribute("functions", f.concat(",").concat(gfun));
                }
                return;
            }
            if (ifssurface.indexOf(ifsname) == -1) {
                LOGGER.warn("gname [{}] not found in ifssurface [{}]", new Object[]{ifsname, ifssurface});
            }
            GuessVariant gv = this.getGuessVariant(ifssurface, gtype);
            gv.addNames(ifsname, ifsbname, ifsiname);
            gv.addPosition(ifs.getStart());
            gv.addRule(ifsrule, ifsconfidence);
            gv.addFunctions(ifs.getStart(), ifstit, gfun, ifsnat);
        }

        private void addAsOrganization(InputFeatureStructure ifs, String ifsrule) {
            String ifsconfidence = ifs.getValue(1);
            String ifstype = ifs.getValue(2);
            String ifsname = ifs.getValue(3);
            String ifssubtype = ifs.getValue(4);
            String ifscountry = ifs.getValue(5);
            String ifssurface = this._stream.substring(ifs.getStart(), ifs.getEnd() + 1);
            boolean intitle = ifs.getStart() < this._ltitle;
            String gtype = null;
            if ("Org".equals(ifstype)) {
                gtype = "o";
            }
            SimpleElement gknown = this.isKnown(ifssurface, ifsname, null, null);
            boolean newline = ifssurface.matches(".*[\t\n\r\f]{2,}.*");
            if (this._levidence != null) {
                SimpleElement se = new SimpleElement("emm:extractg", ifssurface);
                se.addAttribute("rule", ifsrule);
                se.addAttribute("confidence", ifsconfidence);
                se.addAttribute("pos", String.valueOf(ifs.getStart()));
                se.addAttribute("type", ifstype);
                se.addAttribute("typex", gtype);
                se.addAttribute("name", ifsname);
                se.addAttribute("knownx", String.valueOf(gknown != null));
                se.addAttribute("country", ifscountry);
                se.addAttribute("intitlex", String.valueOf(intitle));
                se.addAttribute("newlinex", String.valueOf(newline));
                this._levidence.add(se);
            }
            if (intitle) {
                return;
            }
            if (newline) {
                return;
            }
            if (gknown != null) {
                this._knowng.add(gknown.getValue());
                return;
            }
            if (ifssurface.indexOf(ifsname) == -1) {
                LOGGER.warn("gname [{}] not found in ifssurface [{}]", new Object[]{ifsname, ifssurface});
            }
            GuessVariant gv = this.getGuessVariant(ifssurface, gtype);
            gv.addNames(ifsname, null, null);
            gv.addPosition(ifs.getStart());
            gv.addRule(ifsrule, ifsconfidence);
        }

        private void addAsLocation(InputFeatureStructure ifs, String ifsrule) {
            String ifsconfidence = ifs.getValue(1);
            String ifstype = ifs.getValue(2);
            String ifsname = ifs.getValue(3);
            String ifssurface = this._stream.substring(ifs.getStart(), ifs.getEnd() + 1);
            boolean intitle = ifs.getStart() < this._ltitle;
            String gtype = null;
            if ("Location".equals(ifstype)) {
                gtype = "l";
            }
            if (this._levidence != null) {
                SimpleElement se = new SimpleElement("emm:extractg", ifssurface);
                se.addAttribute("rule", ifsrule);
                se.addAttribute("confidence", ifsconfidence);
                se.addAttribute("pos", String.valueOf(ifs.getStart()));
                se.addAttribute("type", ifstype);
                se.addAttribute("typex", gtype);
                se.addAttribute("name", ifsname);
                se.addAttribute("intitlex", String.valueOf(intitle));
                this._levidence.add(se);
            }
            if (intitle) {
                return;
            }
            GuessVariant gv = this.getGuessVariant(ifssurface, gtype);
            gv.addNames(ifsname, null, null);
            gv.addPosition(ifs.getStart());
            gv.addRule(ifsrule, ifsconfidence);
        }
    }
}

