/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wipo.stringSim.Transliteration;

public final class SignatureHelper {
    private Transliteration _trans;
    private static final Logger LOGGER = LogManager.getLogger(SignatureHelper.class);

    public SignatureHelper(String ponderationpath) throws IOException {
        this._trans = new Transliteration(new File(ponderationpath).getAbsolutePath());
        this._trans.init("All", "Latn");
        this._trans.init("Latn", "Latn_lower");
        this._trans.init("Latn", "norm");
    }

    public String getSignature(String variant) {
        List<String> result = this.getSignatures(variant);
        return SignatureHelper.toPlain(result);
    }

    public List<String> getSignatures(String variant) {
        ArrayList<String> result = new ArrayList<String>();
        for (String chunk : variant.split("[\\s\u00b7\u30fb\\-\u2010\u2011\u2012\u2013\u2212]", -1)) {
            String s = this._trans.translit("All", chunk, "Latn");
            s = this._trans.translit("Latn", s, "Latn_lower");
            s = this._trans.translit("Latn", s, "norm");
            s = s.replaceAll("[aeiou\"]", "");
            if ("".equals(s = s.trim())) {
                LOGGER.debug("while getSignatures(" + variant + ") chunk [" + chunk + "] got an empty signature");
                continue;
            }
            result.add(s);
        }
        return result;
    }

    public static String toPlain(List<String> signatures) {
        if (signatures.size() == 0) {
            return "";
        }
        String result = signatures.get(0);
        for (int i = 1; i < signatures.size(); ++i) {
            result = result.concat(" ").concat(signatures.get(i));
        }
        return result;
    }
}

