/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.stringSim;

import java.util.HashMap;
import org.wipo.stringSim.Ponderation;

public class Align {
    private HashMap<String, Integer> align = new HashMap();
    private Ponderation d;
    private int count = 0;

    public Align() {
        this.d = new Ponderation("dists.dat");
    }

    public Align(Ponderation userPonderation) {
        this.d = userPonderation;
    }

    private float Minimum(float a, float b, float c) {
        float mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    private void add(char s, char t) {
        String key = "" + s + "|" + t;
        if (this.align.containsKey(key)) {
            this.align.put(key, this.align.get(key) + 1);
        } else {
            this.align.put(key, 1);
        }
    }

    private void add(String s, String t) {
        String key = "" + s + "|" + t;
        if (this.align.containsKey(key)) {
            this.align.put(key, this.align.get(key) + 1);
        } else {
            this.align.put(key, 1);
        }
    }

    public HashMap<String, Integer> alignPath(String s, String t) {
        if (this.count++ < 10) {
            System.err.println(s + " - " + t);
        }
        String[] ts = s.split("/");
        String[] tt = t.split("/");
        boolean ii = false;
        boolean ij = false;
        if (ts[0].equals("")) {
            ts[0] = "$";
        }
        if (tt[0].equals("")) {
            tt[0] = "$";
        }
        for (int i = 0; i < ts.length; ++i) {
            this.add(ts[i], tt[i]);
        }
        return this.align;
    }

    public void alignChars(char[] s, char[] t, int si, int ti, int sl, int tl) {
        if (si >= sl || ti >= tl) {
            return;
        }
        if (s[si] == t[ti]) {
            this.add(s[si], t[ti]);
            this.alignChars(s, t, si + 1, ti + 1, sl, tl);
        } else if (ti < tl - 1 && s[si] == t[ti + 1]) {
            this.add('$', t[ti]);
            this.add(s[si], t[ti + 1]);
            this.alignChars(s, t, si + 1, ti + 2, sl, tl);
        } else if (si < sl - 1 && s[si + 1] == t[ti]) {
            this.add(s[si], '$');
            this.add(s[si + 1], t[ti]);
            this.alignChars(s, t, si + 2, ti + 1, sl, tl);
        } else {
            this.add(s[si], t[ti]);
            this.alignChars(s, t, si + 1, ti + 1, sl, tl);
        }
    }

    public void alignChars2(char[] s, char[] t, int si, int ti, int sl, int tl) {
        if (si >= sl || ti >= tl) {
            return;
        }
        float threshold = 0.75f;
        float sum = 0.0f;
        if (si >= sl || ti >= tl) {
            return;
        }
        if (this.d.distTwoChars(s[si], t[ti]) < threshold) {
            this.add(s[si], t[ti]);
            this.alignChars2(s, t, si + 1, ti + 1, sl, tl);
        } else if (ti < tl - 1 && this.d.distTwoChars(s[si], t[ti + 1]) < threshold) {
            this.add('$', t[ti]);
            this.add(s[si], t[ti + 1]);
            this.alignChars2(s, t, si + 1, ti + 2, sl, tl);
        } else if (si < sl - 1 && this.d.distTwoChars(s[si + 1], t[ti]) < threshold) {
            this.add(s[si], '$');
            this.add(s[si + 1], t[ti]);
            this.alignChars2(s, t, si + 2, ti + 1, sl, tl);
        } else {
            this.add(s[si], t[ti]);
            this.alignChars2(s, t, si + 1, ti + 1, sl, tl);
        }
    }

    public HashMap<String, Integer> Align(String s, String t) {
        this.alignChars(s.toLowerCase().toCharArray(), t.toLowerCase().toCharArray(), 0, 0, s.length(), t.length());
        return this.align;
    }

    public HashMap<String, Integer> Align2(String s, String t) {
        this.alignChars2(s.toLowerCase().toCharArray(), t.toLowerCase().toCharArray(), 0, 0, s.length(), t.length());
        return this.align;
    }
}

