/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.stringSim;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.wipo.stringSim.EditPath;
import org.wipo.stringSim.Ponderation;

public class Distance {
    public int MAXC = 1000;
    public String _ponderationfile;
    public Ponderation ponderation;
    public static int debug = 0;
    public int verbose = 0;
    private String[][] lastPath = null;
    private String lastPathS = "";
    private String lastPathT = "";
    private static PrintStream out = System.err;

    public Distance() {
        this.ponderation = new Ponderation();
    }

    public Distance(String ponderationFile) {
        this._ponderationfile = new File(ponderationFile).getName();
        this.ponderation = new Ponderation(ponderationFile);
    }

    public void setLog(String outputFileName) {
        try {
            if (outputFileName == null) {
                out = new PrintStream(new FileOutputStream("NUL:"));
                this.verbose = 0;
                this.ponderation.verbose = 0;
                return;
            }
            this.verbose = 2;
            System.err.println("STS: output log in file : " + outputFileName);
            out = new PrintStream(outputFileName, "UTF-8");
        }
        catch (FileNotFoundException ex) {
            System.err.println("ERR: FnF " + outputFileName);
            return;
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("ERR: Unkown Encoding");
            return;
        }
    }

    public static void printLog(String s) {
        out.println(s);
    }

    private static void log(String s) {
        if (debug > 0) {
            out.println(s);
        }
    }

    private int Minimum(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    private float Minimum(float a, float b, float c) {
        float mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    private float Minimum(float a, float b, float c, float d) {
        float mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        if (d < mi) {
            mi = d;
        }
        return mi;
    }

    private float Minimum(float a, float b, float c, float d, float e) {
        float mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        if (d < mi) {
            mi = d;
        }
        if (e < mi) {
            mi = e;
        }
        return mi;
    }

    private float Minimum(float a, float b, float c, float d, float e, float f) {
        float mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        if (d < mi) {
            mi = d;
        }
        if (e < mi) {
            mi = e;
        }
        if (f < mi) {
            mi = f;
        }
        return mi;
    }

    public int LD(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = this.Minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    public float LDp(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        float[][] d = new float[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                float cost = s_i == t_j ? 0.0f : this.ponderation.distTwoChars(s_i, t_j);
                d[i][j] = this.Minimum(d[i - 1][j] + this.ponderation.distTwoChars(s_i, '$'), d[i][j - 1] + this.ponderation.distTwoChars('$', t_j), d[i - 1][j - 1] + cost);
            }
        }
        this.displayMatrix(s, t, d);
        return d[n][m];
    }

    public float LDpb(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        float[][] d = new float[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                float cost = s_i == t_j ? 0.0f : this.ponderation.distTwoChars(s_i, t_j);
                if (i >= 2) {
                    if (j >= 2) {
                        d[i][j] = this.Minimum(d[i - 2][j - 2] + this.ponderation.distTwoStrings("" + s.charAt(i - 2) + s_i, "" + t.charAt(j - 2) + t_j), d[i - 2][j - 1] + this.ponderation.distTwoStrings("" + s.charAt(i - 2) + s_i, "" + t_j), d[i - 1][j - 2] + this.ponderation.distTwoStrings("" + s_i, "" + t.charAt(j - 2) + t_j), d[i - 1][j] + this.ponderation.distTwoChars(s_i, '$'), d[i][j - 1] + this.ponderation.distTwoChars('$', t_j), d[i - 1][j - 1] + cost);
                        continue;
                    }
                    d[i][j] = this.Minimum(d[i - 2][j - 1] + this.ponderation.distTwoStrings("" + s.charAt(i - 2) + s_i, "" + t_j), d[i - 1][j] + this.ponderation.distTwoChars(s_i, '$'), d[i][j - 1] + this.ponderation.distTwoChars('$', t_j), d[i - 1][j - 1] + cost);
                    continue;
                }
                d[i][j] = j >= 2 ? this.Minimum(d[i - 1][j - 2] + this.ponderation.distTwoStrings("" + s_i, "" + t.charAt(j - 2) + t_j), d[i - 1][j] + this.ponderation.distTwoChars(s_i, '$'), d[i][j - 1] + this.ponderation.distTwoChars('$', t_j), d[i - 1][j - 1] + cost) : this.Minimum(d[i - 1][j] + this.ponderation.distTwoChars(s_i, '$'), d[i][j - 1] + this.ponderation.distTwoChars('$', t_j), d[i - 1][j - 1] + cost);
            }
        }
        this.displayMatrix(s, t, d);
        return d[n][m];
    }

    public float LDpbp(String s, String t) {
        return this.LDpbp(s, t, 99);
    }

    private static float MinimumPath(float[][] d, Ponderation ponderation, EditPath path, char[] s1, char[] s2, int i, int j, int[][] t) {
        float min = 99.0f;
        String pathSoFar1 = "";
        String pathSoFar2 = "";
        for (int row = 0; row < t.length; ++row) {
            int di = t[row][0];
            int dj = t[row][1];
            if (i - di < 0 || j - dj < 0) continue;
            String sub1 = null;
            if (di == 0) {
                sub1 = "$";
            } else if (di == 1) {
                sub1 = Character.toString(s1[i - di]);
            } else {
                sub1 = Character.toString(s1[i - di]);
                for (int c = di - 1; c >= 1; --c) {
                    sub1 = sub1.concat(Character.toString(s1[i - c]));
                }
            }
            String sub2 = null;
            if (dj == 0) {
                sub2 = "$";
            } else if (dj == 1) {
                sub2 = Character.toString(s2[j - dj]);
            } else {
                sub2 = Character.toString(s2[j - dj]);
                for (int c = dj - 1; c >= 1; --c) {
                    sub2 = sub2.concat(Character.toString(s2[j - c]));
                }
            }
            float v = d[i - di][j - dj];
            if (!sub1.equals(sub2)) {
                float p = ponderation.distTwoStrings(sub1, sub2);
                v += p;
            }
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    public float LDpbp(String s, String t, int max) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        char[] s1 = s.toCharArray();
        char[] s2 = t.toCharArray();
        float[][] d = new float[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        max = 20;
        float bestSoFar = 300.0f;
        int besti = 0;
        int bestj = 0;
        for (i = 1; i <= n; ++i) {
            for (j = 1; j <= m; ++j) {
                d[i][j] = Distance.MinimumPath(d, this.ponderation, null, s1, s2, i, j, this.ponderation.getLookAt(s1[i - 1], s2[j - 1]));
                if (i != n || j != m || !(d[i][j] < bestSoFar)) continue;
                bestSoFar = d[i][j];
                besti = i;
                bestj = j;
            }
        }
        return bestSoFar;
    }

    public String getLastPathS() {
        return this.lastPathS;
    }

    public String getLastPathT() {
        return this.lastPathT;
    }

    public String[][] getLastPathAsAlign() {
        return this.lastPath;
    }

    private void displayMatrix(String s, String t, float[][] d) {
        out.printf("  ", new Object[0]);
        for (int j = 1; j <= t.length(); ++j) {
            out.printf("%5.5s ", Character.valueOf(t.charAt(j - 1)));
        }
        out.println("");
        for (int i = 1; i <= s.length(); ++i) {
            out.print(s.charAt(i - 1) + ":");
            for (int j = 1; j <= t.length(); ++j) {
                out.printf("%5.2f ", Float.valueOf(d[i][j]));
            }
            out.println("");
        }
    }

    public float LDsim(String s, String t) {
        int n = s.length();
        if (n == 0) {
            return 0.0f;
        }
        int m = t.length();
        if (m == 0) {
            return 0.0f;
        }
        float d = this.LDp(s, t);
        if (n > m) {
            return 1.0f - d / (float)n;
        }
        return 1.0f - d / (float)m;
    }

    public float LDsimpbp(String s, String t) {
        int n;
        if (debug > 0) {
            System.err.println("SIM:" + s + "//" + t);
        }
        if ((n = s.length()) == 0) {
            return 0.0f;
        }
        int m = t.length();
        if (m == 0) {
            return 0.0f;
        }
        float d = this.LDpbp(s, t);
        if (debug > 0) {
            System.err.println("SIM:" + s + "//" + t + "=" + d);
        }
        if (n > m) {
            return 1.0f - d / (float)n;
        }
        return 1.0f - d / (float)m;
    }

    private float nameSimilarityWithSpace(String src, String dst) {
        int m;
        float d = this.LDpbp(src + " ", dst + " ");
        int n = this.lastPathS.split("/").length - 1;
        if (n == 0) {
            return 0.0f;
        }
        if (src.length() < n) {
            n = src.length();
        }
        if ((m = this.lastPathT.split("/").length - 1) == 0) {
            return 0.0f;
        }
        if (dst.length() < m) {
            m = dst.length();
        }
        float sim = n > m ? 1.0f - d / (float)n : 1.0f - d / (float)m;
        return sim;
    }

    public float nameSim(String src, String dst) {
        float d;
        block6: {
            String[] tNameParts;
            boolean firstSrc;
            String tp;
            String sp;
            block7: {
                d = 0.0f;
                sp = src.toLowerCase();
                firstSrc = sp.compareTo(tp = dst.toLowerCase()) >= 0;
                d = firstSrc ? this.nameSimilarityWithSpace(src, dst) : this.nameSimilarityWithSpace(dst, src);
                if (!((double)d < 0.9)) break block6;
                String[] sNameParts = sp.split("[ \\-]");
                tNameParts = tp.split("[ \\-]");
                if (debug > 0) {
                    System.err.println("src=" + src + " dst=" + dst + " sl=" + sNameParts.length + " dl=" + tNameParts.length);
                }
                if (sNameParts.length <= tNameParts.length && (sNameParts.length != tNameParts.length || sNameParts.length <= 1 || !firstSrc)) break block7;
                if (debug > 0) {
                    System.err.println("Before: d=" + d);
                }
                for (int i = 0; i < sNameParts.length; ++i) {
                    sp = sp.replaceAll("(.*?)([ \\-])([^\\- ]+)+$", "$3$2$1");
                    float distSP = 0.95f * (firstSrc ? this.nameSimilarityWithSpace(sp, tp) : this.nameSimilarityWithSpace(tp, sp));
                    if (debug > 0) {
                        System.err.println("test for '" + sp + "'/tp='" + tp + "'=" + distSP);
                    }
                    if (!(distSP > d)) continue;
                    d = distSP;
                }
                break block6;
            }
            if (tNameParts.length <= 1) break block6;
            for (int i = 0; i < tNameParts.length; ++i) {
                tp = tp.replaceAll("(.*?)([ \\-])([^\\- ]+)+$", "$3$2$1");
                float distDP = 0.95f * (firstSrc ? this.nameSimilarityWithSpace(sp, tp) : this.nameSimilarityWithSpace(tp, sp));
                if (debug > 0) {
                    System.err.println("test for '" + sp + "'/tp='" + tp + "'=" + distDP);
                }
                if (!(distDP > d)) continue;
                d = distDP;
            }
        }
        return d;
    }
}

