/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.stringSim;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.wipo.stringSim.TransTable;

public final class Transliteration {
    private String _tablesdir;
    private Map<String, TransTable> _mtables;

    public Transliteration(String dir) {
        this._tablesdir = dir;
        this._mtables = new HashMap<String, TransTable>();
    }

    public void init(String sourceScript, String targetScript) throws IOException {
        if (!this._mtables.containsKey(sourceScript + targetScript)) {
            TransTable tt = new TransTable(new File(this._tablesdir, "matrix-" + sourceScript + "-" + targetScript + ".txt").getAbsolutePath());
            this._mtables.put(sourceScript + "|" + targetScript, tt);
        }
    }

    public String translit(String sourceScript, String sourceString, String targetScript) {
        TransTable tt = this._mtables.get(sourceScript + "|" + targetScript);
        if (tt == null) {
            return "[" + sourceString + "]";
        }
        String result = "";
        String source = sourceString + " ";
        boolean returnNotMatch = false;
        int sl = source.length();
        for (int i = 0; i < sl; ++i) {
            char sc = source.charAt(i);
            Set<Integer> t = tt.lookup(sc);
            if (t == null) {
                String m = tt.bestMatch(sc);
                result = result + (m == null ? (returnNotMatch ? "[" + sc + "]" : Character.valueOf(sc)) : m);
                continue;
            }
            int found = -1;
            String bsubs = "[null]";
            for (int k : t) {
                String subs;
                if (i + k - 1 >= sl || (subs = tt.bestMatch(source.substring(i, i + k))) == null || k <= found) continue;
                found = k;
                bsubs = subs;
            }
            if (found >= 0) {
                i += found - 1;
                result = result + bsubs;
                continue;
            }
            result = result + (returnNotMatch ? "[" + sc + "]" : Character.valueOf(sc));
        }
        if (result.length() > 0) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }
}

