/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.automaton.auxiliary;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import piskorski.fs.letterfs.fsa.AbstractLetterFSA;
import piskorski.fs.letterfs.fsa.DynamicLetterMarkedFSAInterface;
import piskorski.fs.letterfs.fsa.LetterFSAInterface;

public class AutomatonUtilities {
    public static LetterFSAInterface convertAutomatonToDynamiLetterFSA(Automaton a) {
        DynamicLetterMarkedFSAInterface outFSA = (DynamicLetterMarkedFSAInterface)AbstractLetterFSA.getInstance((String)"DYN_MARKED");
        HashMap<State, Integer> stateID = new HashMap<State, Integer>();
        State initial = a.getInitialState();
        stateID.put(initial, new Integer(0));
        Set states = a.getStates();
        Iterator stateIt = states.iterator();
        int counter = 1;
        while (stateIt.hasNext()) {
            State nextState = (State)stateIt.next();
            Integer nID = (Integer)stateID.get(nextState);
            if (nID != null) continue;
            stateID.put(nextState, new Integer(counter));
            outFSA.addState();
            if (nextState.isAccept()) {
                outFSA.setFinalState(counter);
            } else {
                outFSA.setNonFinalState(counter);
            }
            ++counter;
        }
        for (State nextState : states) {
            int nextStateID = (Integer)stateID.get(nextState);
            Set transitions = nextState.getTransitions();
            for (Transition nextT : transitions) {
                State targetState = nextT.getDest();
                int targetStateID = (Integer)stateID.get(targetState);
                for (char symbol = nextT.getMin(); symbol <= nextT.getMax(); symbol = (char)(symbol + '\u0001')) {
                    outFSA.addTransition(nextStateID, targetStateID, symbol);
                }
            }
        }
        return outFSA;
    }

    public static String printAutomaton(Automaton a) {
        HashMap<State, Integer> stateID = new HashMap<State, Integer>();
        StringBuffer out = new StringBuffer();
        State initial = a.getInitialState();
        stateID.put(initial, new Integer(0));
        out.append("Initial state: 0\n");
        Set states = a.getStates();
        Iterator stateIt = states.iterator();
        int counter = 1;
        while (stateIt.hasNext()) {
            State nextState = (State)stateIt.next();
            Integer nID = (Integer)stateID.get(nextState);
            if (nID != null) continue;
            stateID.put(nextState, new Integer(counter++));
        }
        for (State nextState : states) {
            int nextStateID = (Integer)stateID.get(nextState);
            Set transitions = nextState.getTransitions();
            out.append(nextStateID);
            out.append(" ");
            if (nextState.isAccept()) {
                out.append("accept\n");
            } else {
                out.append("reject\n");
            }
            out.append("---------------\n");
            for (Transition nextT : transitions) {
                State targetState = nextT.getDest();
                int targetStateID = (Integer)stateID.get(targetState);
                for (char symbol = nextT.getMin(); symbol <= nextT.getMax(); symbol = (char)(symbol + '\u0001')) {
                    out.append(nextStateID);
                    out.append(" ");
                    if (symbol == '-' || symbol == ':' || symbol == '#' || symbol == '*') {
                        out.append(symbol);
                    } else {
                        out.append('[');
                        out.append((int)symbol);
                        out.append(']');
                    }
                    out.append(" ");
                    out.append(targetStateID);
                    out.append('\n');
                }
            }
            out.append("---------------\n");
        }
        return out.toString();
    }
}

