/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FuncCallSpecification {
    private String name;
    private byte variable;
    private boolean[] argIsVariable;
    private String[] argString;
    private byte[] argVariable;
    public static byte UNBOUND = (byte)-1;

    public boolean writeToStream(DataOutputStream d) throws IOException {
        int i;
        int len = this.name.length();
        d.writeInt(len);
        d.writeChars(this.name);
        d.writeByte(this.variable);
        len = this.argIsVariable.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            d.writeBoolean(this.argIsVariable[i]);
        }
        for (i = 0; i < len; ++i) {
            d.writeByte(this.argVariable[i]);
        }
        for (i = 0; i < len; ++i) {
            int lenString = this.argString[i] == null ? -1 : this.argString[i].length();
            d.writeInt(lenString);
            if (lenString <= 0) continue;
            d.writeChars(this.argString[i]);
        }
        return true;
    }

    public boolean readFromStream(DataInputStream d) throws IOException {
        int i;
        int len = d.readInt();
        char[] temp = new char[len];
        for (int j = 0; j < len; ++j) {
            temp[j] = d.readChar();
        }
        this.name = new String(temp);
        this.variable = d.readByte();
        len = d.readInt();
        this.argIsVariable = new boolean[len];
        for (i = 0; i < len; ++i) {
            this.argIsVariable[i] = d.readBoolean();
        }
        this.argVariable = new byte[len];
        for (i = 0; i < len; ++i) {
            this.argVariable[i] = d.readByte();
        }
        this.argString = new String[len];
        for (i = 0; i < len; ++i) {
            int lenString = d.readInt();
            if (lenString >= 0) {
                temp = new char[lenString];
                for (int j = 0; j < lenString; ++j) {
                    temp[j] = d.readChar();
                }
                this.argString[i] = new String(temp);
                continue;
            }
            this.argString[i] = null;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte getVariable() {
        return this.variable;
    }

    public void SetVariable(byte variable) {
        this.variable = variable;
    }

    public FuncCallSpecification() {
        this.name = null;
        this.variable = (byte)-1;
        this.argIsVariable = null;
        this.argString = null;
        this.argVariable = null;
    }

    public FuncCallSpecification(FuncCallSpecification fCS) {
        this.name = fCS.name;
        this.variable = fCS.variable;
        int len = fCS.argIsVariable.length;
        this.argIsVariable = new boolean[len];
        this.argString = new String[len];
        this.argVariable = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.argIsVariable[i] = fCS.argIsVariable[i];
            if (this.argIsVariable[i]) {
                this.argVariable[i] = fCS.argVariable[i];
                this.argString[i] = null;
                continue;
            }
            this.argVariable[i] = UNBOUND;
            this.argString[i] = fCS.argString[i] == null ? null : new String(fCS.argString[i]);
        }
    }

    public void setArguments(int len, boolean[] argIsVariable, String[] argString, byte[] argVariable) {
        this.argIsVariable = new boolean[len];
        this.argString = new String[len];
        this.argVariable = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.argIsVariable[i] = argIsVariable[i];
            if (argIsVariable[i]) {
                this.argVariable[i] = argVariable[i];
                this.argString[i] = null;
                continue;
            }
            this.argVariable[i] = UNBOUND;
            this.argString[i] = argString[i] == null ? null : new String(argString[i]);
        }
    }

    public boolean isArgumentVariable(int i) {
        if (this.argIsVariable == null) {
            return false;
        }
        return i < 0 || i >= this.argIsVariable.length ? false : this.argIsVariable[i];
    }

    public int numberOfArguments() {
        return this.argIsVariable != null ? this.argIsVariable.length : 0;
    }

    public String getArgumentString(int i) {
        if (this.argString == null) {
            return null;
        }
        return i < 0 || i >= this.argString.length ? null : this.argString[i];
    }

    public byte getArgumentVariable(int i) {
        if (this.argVariable == null) {
            return UNBOUND;
        }
        return i < 0 || i >= this.argVariable.length ? null : Byte.valueOf(this.argVariable[i]);
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("#");
        out.append(this.variable);
        out.append("=");
        out.append(this.name);
        out.append("(");
        int len = this.argIsVariable.length;
        for (int i = 0; i < len; ++i) {
            if (this.argIsVariable[i]) {
                out.append("#");
                out.append(this.argVariable[i]);
            } else {
                out.append(this.argString[i]);
            }
            if (i >= len - 1) continue;
            out.append(",");
        }
        out.append(")");
        return out.toString();
    }
}

