/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.FunctionalOperatorName;
import it.jrc.lt.regexpfs.Variable;
import java.util.ArrayList;

public class FunctionalOperatorAssignment {
    private Variable variable;
    private FunctionalOperatorName operatorName;
    private ArrayList<Object> arguments;

    public Variable getVariable() {
        return this.variable;
    }

    public FunctionalOperatorName getName() {
        return this.operatorName;
    }

    public int getNumArguments() {
        return this.arguments != null ? this.arguments.size() : 0;
    }

    public ArrayList<Object> getArguments() {
        return this.arguments;
    }

    public Object getArgument(int i) {
        int numArguments = this.getNumArguments();
        if (i < 0 || i >= numArguments) {
            return null;
        }
        return this.arguments.get(i);
    }

    public void setVariable(Variable v) {
        this.variable = v != null ? new Variable(v) : null;
    }

    public void setName(FunctionalOperatorName name) {
        this.operatorName = name != null ? new FunctionalOperatorName(name) : null;
    }

    public void setArguments(ArrayList<Object> a) {
        if (a == null) {
            return;
        }
        this.arguments = new ArrayList();
        this.arguments.addAll(a);
    }

    public FunctionalOperatorAssignment() {
        this.variable = null;
        this.operatorName = null;
        this.arguments = null;
    }

    public FunctionalOperatorAssignment(FunctionalOperatorAssignment f) {
        this.setName(f.getName());
        this.setVariable(f.getVariable());
        this.setArguments(f.getArguments());
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(" with ");
        out.append(this.getVariable().toString());
        int len = this.getNumArguments();
        out.append(" := ");
        out.append(this.getName().toString());
        out.append("(");
        for (int i = 0; i < len; ++i) {
            out.append(this.getArgument(i).toString());
            if (i >= len - 1) continue;
            out.append(",");
        }
        out.append(")");
        return out.toString();
    }

    public String specialToString() {
        StringBuffer out = new StringBuffer();
        out.append(" with ");
        out.append(this.getVariable().toString());
        int len = this.getNumArguments();
        out.append(" := ");
        out.append(this.getName().specialToString());
        out.append("(");
        for (int i = 0; i < len; ++i) {
            out.append(this.getArgument(i).toString());
            if (i >= len - 1) continue;
            out.append(",");
        }
        out.append(")");
        return out.toString();
    }
}

