/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.BooleanPredicateSpecification;
import it.jrc.lt.regexpfs.FilteringAutomatonInstance;
import it.jrc.lt.regexpfs.FilteringAutomatonInstanceArrayList;
import it.jrc.lt.regexpfs.FuncCallSpecification;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFSDArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.InputFeatureStructureComparator;
import it.jrc.lt.regexpfs.InputFeatureStructureComparatorAccordingToStartPos;
import it.jrc.lt.regexpfs.InputFeatureStructureDisjunction;
import it.jrc.lt.regexpfs.LabelBinding;
import it.jrc.lt.regexpfs.NormalizedFeatureStructure;
import it.jrc.lt.regexpfs.ReefsCascade;
import it.jrc.lt.regexpfs.ReefsGrammar;
import it.jrc.lt.regexpfs.ReefsGrammarTypes;
import it.jrc.lt.regexpfs.RuleAutomatonInstance;
import it.jrc.lt.regexpfs.RuleAutomatonInstanceArrayList;
import it.jrc.lt.regexpfs.SystemEnv;
import it.jrc.lt.regexpfs.VariableBinding;
import it.jrc.lt.regexpfs.VariableBindingArrayList;
import it.jrc.lt.regexpfs.VariableBindings;
import it.jrc.lt.regexpfs.booleanOperator.BooleanOperatorCall;
import it.jrc.lt.regexpfs.funop.FunctionalOperatorCall;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.module.ModulePool;
import it.jrc.lt.regexpfs.module.NoSuchModuleException;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSA;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSAStatesArrayList;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSATraversing;
import piskorski.util.arraylist.IntArrayList;
import piskorski.util.arraylist.StringArrayList;
import piskorski.util.functions.Bit;
import piskorski.util.functions.Files;

public final class GrammarInterpreter {
    private boolean debugModusOn;
    private boolean debugAllGrammars;
    private boolean debugRuleStatistics;
    private boolean splitFilesToLines;
    long extraStart;
    long extraEnd;
    double extraFinal;
    double total;
    double[] module_time;
    double[] grammar_time;
    double[] output_time;
    private static final int UNDEFINED_POSITION = -1;
    private static final String EMPTY_TYPE = "empty";
    private int EMPTY_TYPE_CODE;
    protected static Logger logger = Logger.getLogger(GrammarInterpreter.class);
    private ReefsCascade cascade;
    private ReefsGrammarTypes types;
    private int numberOfPhases;
    private ModulePool mPool;
    private Module[][] modules;
    private short[][][] typeConvert;
    private FunctionalOperatorCall funOpPool;
    private BooleanOperatorCall boolOpPool;

    public GrammarInterpreter() {
        this.init();
        this.mPool = ModulePool.getInstance();
        this.funOpPool = FunctionalOperatorCall.getInstance();
        this.boolOpPool = BooleanOperatorCall.getInstance();
        this.debugModusOn = false;
        this.debugAllGrammars = false;
        this.debugRuleStatistics = false;
        this.splitFilesToLines = false;
        this.EMPTY_TYPE_CODE = ReefsGrammarTypes.UNKNOWN;
    }

    private void init() {
        this.cascade = null;
        this.types = null;
        this.mPool = null;
        this.modules = null;
        this.typeConvert = null;
        this.numberOfPhases = 0;
        this.funOpPool = null;
        this.boolOpPool = null;
        this.debugModusOn = false;
        this.debugAllGrammars = false;
        this.debugRuleStatistics = false;
        this.splitFilesToLines = false;
    }

    public Properties readProperties(String fileName) {
        Properties confProperties = new Properties();
        try {
            FileInputStream FIS = new FileInputStream(fileName);
            confProperties.load(FIS);
            FIS.close();
        }
        catch (IOException e) {
            GrammarInterpreter.loggerMessage("IO ERROR while reading property file " + fileName);
            return null;
        }
        return confProperties;
    }

    public StringArrayList getTypeNames() {
        StringArrayList result = new StringArrayList();
        int len = this.types.getNumberTypes();
        for (int i = 0; i < len; ++i) {
            result.add(this.types.getTypeName(i));
        }
        return result;
    }

    public String getTypeName(int type) {
        return this.types.getTypeName(type);
    }

    public int getTypeID(String name) {
        return this.types.getTypeID(name);
    }

    public String getAttributeName(int type, int which) {
        return this.types.getAttributeName(type, which);
    }

    public HashMap<String, Integer> getAttributesForType(int typeID) {
        HashMap<String, Integer> retVal = new HashMap<String, Integer>();
        int attributeCount = this.types.getNumberAttributesForType(typeID);
        for (int i = 0; i < attributeCount; ++i) {
            retVal.put(this.types.getAttributeName(typeID, i), i);
        }
        return retVal;
    }

    public void applyToFilesDebug(ArrayList<File> inputFiles, String characterSet, File outputDir) {
        int i;
        this.module_time = new double[this.numberOfPhases];
        this.grammar_time = new double[this.numberOfPhases];
        this.output_time = new double[this.numberOfPhases];
        this.total = 0.0;
        int numDocs = inputFiles.size();
        long time = 0L;
        System.out.println(SystemEnv.LINE_SEPARATOR);
        for (i = 0; i < numDocs; ++i) {
            InputFSDArrayList res;
            Object Input;
            File f = inputFiles.get(i);
            if (i % 100 == 0) {
                System.out.println("Number of processed files: " + i);
            }
            if (this.debugModusOn) {
                time = System.currentTimeMillis();
                System.out.println("FILE: --------> " + f.getAbsolutePath());
                System.out.println(SystemEnv.LINE_SEPARATOR);
            }
            if (this.splitFilesToLines) {
                try {
                    Input = Files.FileToStringArray((String)f.getAbsolutePath(), (String)characterSet);
                }
                catch (Exception e) {
                    Input = null;
                    GrammarInterpreter.loggerMessage("problems while reading/accessing file: " + f.getAbsolutePath());
                }
                int numLines = Input != null ? ((String[])Input).length : 0;
                for (int j = 0; j < numLines; ++j) {
                    if (((String)Input[j]).length() <= 0) continue;
                    if (this.debugModusOn) {
                        System.out.println();
                        System.out.println("LINE[" + j + "]: " + (String)Input[j]);
                        System.out.println("-----------------------------------------------------");
                    }
                    res = this.apply(((String)Input[j]).toCharArray());
                    if (!this.debugModusOn) continue;
                    System.out.println("Final result of applying the grammar cascade:");
                    System.out.println("-----------------------------------------------------");
                    System.out.println(this.resultsToString(res, (String)Input[j]));
                }
            } else {
                try {
                    Input = Files.FileToString((String)f.getAbsolutePath(), (String)characterSet);
                }
                catch (Exception e) {
                    Input = null;
                    GrammarInterpreter.loggerMessage("Problems while reading/accessing file: " + f.getAbsolutePath());
                }
                res = null;
                try {
                    res = this.apply(((String)Input).toCharArray());
                }
                catch (Exception e) {
                    GrammarInterpreter.loggerMessage("Problems while analysing file: " + f.getAbsolutePath());
                }
                if (res != null) {
                    if (this.debugModusOn) {
                        System.out.println("Final result of applying the grammar cascade:");
                        System.out.println("----------------------------------------------------");
                        System.out.println(this.resultsToString(res, (String)Input));
                        System.out.println("Num matches: " + res.size());
                    }
                    if (outputDir != null) {
                        String outputFileName = outputDir.getAbsolutePath() + "\\" + f.getName() + "-result.txt";
                        try {
                            if (this.debugModusOn) {
                                System.out.println("Writing to file: " + outputFileName);
                            }
                            Files.StringBufferToFile((String)outputFileName, (StringBuffer)this.resultsToTabSeparatedAttributeValuePairs(res, (String)Input), (String)characterSet);
                        }
                        catch (Exception e) {
                            GrammarInterpreter.loggerMessage("Problems while writing to file: " + outputFileName);
                        }
                    }
                }
            }
            if (!this.debugModusOn) continue;
            long timeEnd = System.currentTimeMillis();
            double finalTime = (float)(timeEnd - time) / 1000.0f;
            System.out.println("Processing time: " + finalTime);
        }
        System.out.println("Number documents: " + numDocs);
        for (i = 0; i < this.numberOfPhases; ++i) {
            System.out.println("Modules : " + i + " : " + this.module_time[i] / 1000.0 / (double)numDocs);
            System.out.println("Grammar : " + i + " : " + this.grammar_time[i] / 1000.0 / (double)numDocs);
            System.out.println("Output : " + i + " : " + this.output_time[i] / 1000.0 / (double)numDocs);
        }
        System.out.println("Total: " + this.total / 1000.0 / (double)numDocs);
    }

    public InputFSDArrayList applyToTextDebug(char[] text) {
        this.module_time = new double[this.numberOfPhases];
        this.grammar_time = new double[this.numberOfPhases];
        this.output_time = new double[this.numberOfPhases];
        this.total = 0.0;
        System.out.println(SystemEnv.LINE_SEPARATOR);
        InputFSDArrayList result = this.apply(text);
        if (result != null && this.debugModusOn) {
            System.out.println("Final result of applying the grammar cascade:");
            System.out.println("----------------------------------------------------");
            System.out.println(this.resultsToString(result, new String(text)));
            System.out.println("Num matches: " + result.size());
        }
        System.out.println("Total: " + this.total / 1000.0);
        for (int i = 0; i < this.numberOfPhases; ++i) {
            System.out.println("Modules : " + i + " : " + this.module_time[i] / 1000.0);
            System.out.println("Grammar : " + i + " : " + this.grammar_time[i] / 1000.0);
            System.out.println("Output : " + i + " : " + this.output_time[i] / 1000.0);
        }
        return result;
    }

    private DictionaryLetterFSA.State moveTo(CurrentGrammarData currentG, DictionaryLetterFSA.State currentState, InputFeatureStructure fs) {
        DictionaryLetterFSA.State cState = currentState;
        ReefsGrammar gr = currentG.currentGrammar;
        DictionaryLetterFSA.Transition cTransition = cState != null ? cState.getTransitionLabelledWith('*') : null;
        DictionaryLetterFSA.State state = cState = cTransition != null ? cTransition.getTargetState() : null;
        if (cState == null) {
            return null;
        }
        cTransition = cState.getTransitionLabelledWith((char)fs.getType());
        DictionaryLetterFSA.State state2 = cState = cTransition != null ? cTransition.getTargetState() : null;
        if (cState == null) {
            return null;
        }
        int len = fs.getLen();
        short type = fs.getType();
        for (int i = 0; i < len; ++i) {
            DictionaryLetterFSA.State tempState;
            String attributeValue = fs.getValue(i);
            String id = attributeValue != null ? gr.getValueID("\"" + attributeValue + "\"") : gr.getValueID("\"\"");
            DictionaryLetterFSA.State state3 = tempState = id != null ? DictionaryLetterFSATraversing.delta((DictionaryLetterFSA.State)cState, (String)id) : null;
            cState = tempState == null ? ((cTransition = cState.getTransitionLabelledWith('#')) != null ? cTransition.getTargetState() : null) : tempState;
            cTransition = cState != null ? cState.getTransitionLabelledWith(':') : null;
            DictionaryLetterFSA.State state4 = cState = cTransition != null ? cTransition.getTargetState() : null;
            if (cState == null) break;
        }
        return cState;
    }

    private boolean isFinal(DictionaryLetterFSA.State currentState) {
        DictionaryLetterFSA.Transition cTransition = currentState != null ? currentState.getTransitionLabelledWith('-') : null;
        DictionaryLetterFSA.State cState = cTransition != null ? cTransition.getTargetState() : null;
        return cState != null;
    }

    private boolean isFinalForRuleAutomata(DictionaryLetterFSA.State currentState) {
        DictionaryLetterFSA.Transition cTransition = currentState != null ? currentState.getTransitionLabelledWith('\ufdea') : null;
        DictionaryLetterFSA.State cState = cTransition != null ? cTransition.getTargetState() : null;
        return cState != null;
    }

    private void getRuleIDs(IntArrayList currentRuleIDs, DictionaryLetterFSA.State currentState) {
        DictionaryLetterFSA.State cState;
        currentRuleIDs.clear();
        DictionaryLetterFSA.Transition cTransition = currentState != null ? currentState.getTransitionLabelledWith('-') : null;
        DictionaryLetterFSA.State state = cState = cTransition != null ? cTransition.getTargetState() : null;
        if (cState != null) {
            cTransition = cState.getFirstTransition();
            while (cTransition != null) {
                currentRuleIDs.add((int)cTransition.getLabel());
                cTransition = cState.getNextTransition(cTransition);
            }
        }
    }

    private InputFSDArrayList apply(char[] inputText) {
        ResultPool rPool = ResultPool.getInstance();
        rPool.initialize(this.mPool, this.numberOfPhases);
        InputFSDArrayList input = null;
        InputFSDArrayList result = null;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.numberOfPhases; ++i) {
            long tempStartTime = System.currentTimeMillis();
            this.runModules(i, inputText, rPool);
            long tempEndTime = System.currentTimeMillis();
            int n = i;
            this.module_time[n] = this.module_time[n] + (double)(tempEndTime - tempStartTime);
            tempStartTime = System.currentTimeMillis();
            input = this.prepareInput(i, input, rPool);
            if (this.debugModusOn && this.debugAllGrammars) {
                System.out.println("Stream of input structures for the grammar interpreter at level: " + i);
                System.out.println("-----------------------------------------------------");
                System.out.println(this.resultsToString(input, new String(inputText)));
            }
            this.extraFinal = 0.0;
            result = this.runInterpreter(input, i);
            if (this.debugModusOn && this.debugRuleStatistics) {
                System.out.println("Rule application statistic at level: " + i);
                System.out.println("-----------------------------------------------------");
                System.out.println(this.ruleStatistics(result, i));
            }
            rPool.addGrammarApplicationResult(result, i);
            tempEndTime = System.currentTimeMillis();
            int n2 = i;
            this.output_time[n2] = this.output_time[n2] + this.extraFinal;
            int n3 = i;
            this.grammar_time[n3] = this.grammar_time[n3] + (double)(tempEndTime - tempStartTime);
            if (!this.debugModusOn || !this.debugAllGrammars) continue;
            System.out.println("Result of the application of the grammar at level: " + i);
            System.out.println("-----------------------------------------------------");
            System.out.println(this.resultsToString(result, new String(inputText)));
        }
        long endTime = System.currentTimeMillis();
        this.total += (double)(endTime - startTime);
        return rPool.getGrammarResult(this.numberOfPhases - 1);
    }

    public InputFSDArrayList applyOnText(char[] inputText) {
        ResultPool rPool = ResultPool.getInstance();
        rPool.initialize(this.mPool, this.numberOfPhases);
        InputFSDArrayList input = null;
        InputFSDArrayList result = null;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.runModules(i, inputText, rPool);
            input = this.prepareInput(i, input, rPool);
            result = this.runInterpreter(input, i);
            rPool.addGrammarApplicationResult(result, i);
        }
        return rPool.getGrammarResult(this.numberOfPhases - 1);
    }

    private InputFSDArrayList prepareInput(int phase, InputFSDArrayList input, ResultPool rPool) {
        int mode = phase == 0 ? 4 : this.cascade.getGrammar(phase - 1).getOutputTypeID();
        int numModulesAtCurrentStage = this.modules[phase].length;
        ListMerging listMerge = new ListMerging(this.mPool.getModules().size() * 2 + 1);
        int currentIndex = 0;
        for (int i = 0; i < numModulesAtCurrentStage; ++i) {
            String name = this.modules[phase][i].getComponentName();
            listMerge.inputList[currentIndex] = rPool.getModuleResult(name, phase);
            if (listMerge.inputList[currentIndex] == null || listMerge.inputList[currentIndex].size() <= 0) continue;
            listMerge.inputListNumElement[currentIndex] = listMerge.inputList[currentIndex].size();
            listMerge.inputListCounter[currentIndex] = 0;
            ++currentIndex;
        }
        listMerge.numLists = currentIndex;
        InputFSDArrayList grammarResult = mode != 4 && phase > 0 ? rPool.getGrammarResult(phase - 1) : null;
        switch (mode) {
            case 1: {
                if (listMerge.numLists > 0) {
                    return this.merge(listMerge, null, grammarResult, false);
                }
                return grammarResult;
            }
            case 2: {
                return this.merge(listMerge, input, grammarResult, true);
            }
            case 3: {
                return this.merge(listMerge, input, grammarResult, false);
            }
            case 4: {
                return this.mergeLists(listMerge);
            }
        }
        return null;
    }

    private InputFSDArrayList merge(ListMerging listMerge, InputFSDArrayList previousInput, InputFSDArrayList previousGrammar, boolean discardConsumedItems) {
        int len;
        InputFSArrayList newInputList;
        int currentNumLists = listMerge.numLists;
        boolean[] consumed = null;
        InputFSArrayList tempInputList = null;
        if (previousGrammar != null && previousGrammar.size() > 0) {
            listMerge.inputList[currentNumLists] = newInputList = previousGrammar.convertToFlatList();
            listMerge.inputListCounter[currentNumLists] = 0;
            listMerge.inputListNumElement[currentNumLists] = newInputList.size();
            ++currentNumLists;
        }
        if (previousInput != null) {
            tempInputList = previousInput.convertToFlatList();
        }
        if (discardConsumedItems && tempInputList != null && previousGrammar != null) {
            len = tempInputList.size();
            consumed = new boolean[len];
            Arrays.fill(consumed, false);
            int startI = 0;
            int endI = tempInputList.size();
            int endG = previousGrammar.size();
            for (int startG = 0; startG < endG; ++startG) {
                InputFeatureStructure fsInInput;
                InputFeatureStructureDisjunction currentEl = previousGrammar.get(startG);
                InputFeatureStructure fs = currentEl.getFeatureStructure(0);
                int sizeOfCurrentEl = currentEl.getLen();
                int currentStart = fs.getStart();
                int currentEnd = fs.getEnd();
                for (int i = 1; i < sizeOfCurrentEl; ++i) {
                    int nextEnd = currentEl.getFeatureStructure(i).getEnd();
                    if (nextEnd <= currentEnd) continue;
                    currentEnd = nextEnd;
                }
                while (startI < endI && (fsInInput = tempInputList.get(startI)).getEnd() < currentStart) {
                    ++startI;
                }
                while (startI < endI && (fsInInput = tempInputList.get(startI)).getStart() <= currentEnd) {
                    consumed[startI++] = true;
                }
                if (startI < endI) continue;
                break;
            }
        }
        if (tempInputList != null) {
            if (consumed != null) {
                len = tempInputList.size();
                newInputList = new InputFSArrayList(tempInputList.size());
                for (int i = 0; i < len; ++i) {
                    if (consumed[i]) continue;
                    newInputList.add(tempInputList.get(i));
                }
            } else {
                newInputList = tempInputList;
            }
            listMerge.inputList[currentNumLists] = newInputList;
            listMerge.inputListCounter[currentNumLists] = 0;
            listMerge.inputListNumElement[currentNumLists] = newInputList.size();
            ++currentNumLists;
        }
        listMerge.numLists = currentNumLists;
        return this.mergeLists(listMerge);
    }

    private InputFSDArrayList mergeLists(ListMerging listMerge) {
        int maxLen = 10;
        for (int i = 0; i < listMerge.numLists; ++i) {
            if (listMerge.inputListNumElement[i] <= maxLen) continue;
            maxLen = listMerge.inputListNumElement[i];
        }
        InputFSDArrayList result = new InputFSDArrayList(maxLen * 2);
        int hasMoreItems = ~(-1 << listMerge.numLists);
        InputFSArrayList itemsInDisj = new InputFSArrayList();
        while (hasMoreItems != 0) {
            int i;
            int listIDWithCurrentMinimum = 0;
            while (!Bit.isSet((int)hasMoreItems, (int)listIDWithCurrentMinimum)) {
                ++listIDWithCurrentMinimum;
            }
            int numOfListsWithCurrentMinimum = 0;
            int currentMinimum = listMerge.inputList[listIDWithCurrentMinimum].get(listMerge.inputListCounter[listIDWithCurrentMinimum]).getStart();
            listMerge.listsWithCurrentMinimum[numOfListsWithCurrentMinimum++] = listIDWithCurrentMinimum;
            for (i = listIDWithCurrentMinimum + 1; i < listMerge.numLists; ++i) {
                int nextMin;
                if (!Bit.isSet((int)hasMoreItems, (int)i) || (nextMin = listMerge.inputList[i].get(listMerge.inputListCounter[i]).getStart()) > currentMinimum) continue;
                if (nextMin < currentMinimum) {
                    numOfListsWithCurrentMinimum = 0;
                    currentMinimum = nextMin;
                }
                listMerge.listsWithCurrentMinimum[numOfListsWithCurrentMinimum++] = i;
            }
            itemsInDisj.clear();
            for (i = 0; i < numOfListsWithCurrentMinimum; ++i) {
                InputFeatureStructure nextFs;
                int counter;
                int currentList = listMerge.listsWithCurrentMinimum[i];
                for (counter = listMerge.inputListCounter[currentList]; counter < listMerge.inputListNumElement[currentList] && (nextFs = listMerge.inputList[currentList].get(counter)).getStart() == currentMinimum; ++counter) {
                    itemsInDisj.add(nextFs);
                }
                listMerge.inputListCounter[currentList] = counter;
                if (counter < listMerge.inputListNumElement[currentList]) continue;
                hasMoreItems = Bit.unsetBit((int)hasMoreItems, (int)currentList);
            }
            result.add(InputFeatureStructureDisjunction.createNewInputFSD(itemsInDisj));
        }
        return result;
    }

    private int updateIndex(int start, int endCharPosition, CurrentGrammarData currentG) {
        InputFeatureStructureDisjunction singleResult;
        int currentStart;
        for (currentStart = start; currentStart < currentG.currentInputLen && (singleResult = currentG.currentInput.get(currentStart)).getFeatureStructure(0).getStart() <= endCharPosition; ++currentStart) {
        }
        return currentStart;
    }

    private InputFSDArrayList runInterpreter(InputFSDArrayList input, int phase) {
        InputFSDArrayList result = new InputFSDArrayList();
        InputFSDArrayList singleResult = new InputFSDArrayList();
        CurrentGrammarData currentG = new CurrentGrammarData(this.cascade.getGrammar(phase), input);
        MatchingData mData = new MatchingData();
        int searchTypeID = currentG.currentGrammar.getSearchTypeID();
        boolean longestMatch = searchTypeID == 1;
        int start = 0;
        int end = currentG.currentInputLen;
        while (start < end) {
            int newPosition = this.findMatchAtPosition(searchTypeID, start, singleResult, currentG, mData);
            if (singleResult.size() == 0) {
                if (!mData.emptyMatch) {
                    ++start;
                    continue;
                }
            } else {
                result.add(singleResult);
            }
            start = longestMatch ? this.updateIndex(start + 1, newPosition - 1, currentG) : start + 1;
        }
        if (!longestMatch) {
            InputFSArrayList flatList = result.convertToFlatList();
            flatList.sort(InputFeatureStructureComparatorAccordingToStartPos.getInstance());
            result = InputFSDArrayList.createFromSortedInputFSArrayList(flatList);
        }
        return result;
    }

    private int findMatchAtPosition(int searchTypeID, int start, InputFSDArrayList singleResult, CurrentGrammarData currentG, MatchingData mData) {
        IntArrayList prioritizedAutomataInstances = new IntArrayList(10);
        IntArrayList prioritizedRuleIDs = new IntArrayList(10);
        IntArrayList tobeInspectedInstances = new IntArrayList();
        mData.clear();
        FilteringAutomatonInstance fsaInst = new FilteringAutomatonInstance();
        DictionaryLetterFSA.State initState = currentG.currentAutomaton.getInitialState();
        fsaInst.setState(initState);
        fsaInst.setNextDisjunctionID(start);
        mData.fsaInstances.add(fsaInst);
        mData.currentInstances.add(0);
        int currentMaxEnd = 0;
        singleResult.clear();
        while (mData.currentInstances.size() > 0) {
            tobeInspectedInstances.clear();
            int numCurrentInstances = mData.currentInstances.size();
            for (int i = 0; i < numCurrentInstances; ++i) {
                int currentInstanceID = mData.currentInstances.get(i);
                fsaInst = mData.fsaInstances.get(currentInstanceID);
                int nextDisj = fsaInst.getNextDisjunctionID();
                DictionaryLetterFSA.State cState = fsaInst.getState();
                InputFeatureStructureDisjunction cDisj = currentG.currentInput.get(nextDisj);
                int numStructures = cDisj.getLen();
                mData.candidateInstances.clear();
                for (int j = 0; j < numStructures; ++j) {
                    IntArrayList stateInA;
                    DictionaryLetterFSA.State tState;
                    InputFeatureStructure nextFs = cDisj.getFeatureStructure(j);
                    if (cState.equals(initState) && !currentG.currentGrammar.isTypeAtInitialState(nextFs.getType()) || (tState = this.moveTo(currentG, cState, nextFs)) == null) continue;
                    HashMap<Integer, IntArrayList> stateIn = mData.candidateInstances.get(tState);
                    Integer endOfNextFs = new Integer(nextFs.getEnd());
                    if (stateIn == null) {
                        stateInA = new IntArrayList(5);
                        stateInA.add(j);
                        HashMap<Integer, IntArrayList> newElement = new HashMap<Integer, IntArrayList>();
                        newElement.put(endOfNextFs, stateInA);
                        mData.candidateInstances.put(tState, newElement);
                        continue;
                    }
                    stateInA = stateIn.get(endOfNextFs);
                    if (stateInA == null) {
                        stateInA = new IntArrayList(5);
                        stateInA.add(j);
                        stateIn.put(endOfNextFs, stateInA);
                        continue;
                    }
                    stateInA.add(j);
                }
                for (DictionaryLetterFSA.State tState : mData.candidateInstances.keySet()) {
                    HashMap<Integer, IntArrayList> transList = mData.candidateInstances.get(tState);
                    for (Integer nextEnd : transList.keySet()) {
                        int nEnd = nextEnd;
                        IntArrayList trans = transList.get(nextEnd);
                        int maxEnd = nEnd;
                        int nextDisjID = this.updateIndex(nextDisj, maxEnd, currentG);
                        FilteringAutomatonInstance newAutomatonInstance = FilteringAutomatonInstance.createInstance(tState, nextDisj, trans.size(), trans, currentInstanceID, nextDisjID, maxEnd);
                        mData.fsaInstances.add(newAutomatonInstance);
                        if (nextDisjID < currentG.currentInputLen) {
                            tobeInspectedInstances.add(mData.fsaInstances.size() - 1);
                        }
                        if (!this.isFinal(tState)) continue;
                        mData.currentLongestMatches.add(mData.fsaInstances.size() - 1);
                    }
                }
            }
            IntArrayList tempInstances = mData.currentInstances;
            mData.currentInstances = tobeInspectedInstances;
            tobeInspectedInstances = tempInstances;
        }
        this.extraStart = System.currentTimeMillis();
        InputFSArrayList outputStructures = this.extractOutputStructures(prioritizedAutomataInstances, prioritizedRuleIDs, currentG, mData);
        if (outputStructures != null) {
            if (outputStructures.size() > 0) {
                currentMaxEnd = this.sortOutputStructures(singleResult, outputStructures, searchTypeID, currentG);
            }
            if (singleResult.size() == 0) {
                mData.emptyMatch = true;
            }
        }
        this.extraEnd = System.currentTimeMillis();
        this.extraFinal += (double)(this.extraEnd - this.extraStart);
        return currentMaxEnd;
    }

    private InputFSArrayList extractOutputStructures(IntArrayList prioritizedAutomataInstances, IntArrayList prioritizedRuleIDs, CurrentGrammarData currentG, MatchingData mData) {
        int numMatches = mData.currentLongestMatches.size();
        prioritizedAutomataInstances.clear();
        prioritizedRuleIDs.clear();
        IntArrayList currentRuleIDs = new IntArrayList();
        for (int i = 0; i < numMatches; ++i) {
            int instanceID = mData.currentLongestMatches.get(i);
            FilteringAutomatonInstance fAI = mData.fsaInstances.get(instanceID);
            this.getRuleIDs(currentRuleIDs, fAI.getState());
            int numIDs = currentRuleIDs.size();
            for (int j = 0; j < numIDs; ++j) {
                prioritizedAutomataInstances.add(instanceID);
                prioritizedRuleIDs.add(currentRuleIDs.get(j));
            }
        }
        if (prioritizedAutomataInstances.size() == 0) {
            return null;
        }
        DictionaryLetterFSAStatesArrayList statesL = new DictionaryLetterFSAStatesArrayList();
        IntArrayList labelIndices = new IntArrayList();
        InputFSArrayList result = new InputFSArrayList();
        IntArrayList aInstancesOnThePath = new IntArrayList();
        IntArrayList tobeInspectedInstances = new IntArrayList();
        LabelBindingData labelBindingData = new LabelBindingData();
        VariableBindingArrayList tempVarBindings = new VariableBindingArrayList();
        HashSet<RuleAutomatonInstance> RAI = new HashSet<RuleAutomatonInstance>();
        for (int i = 0; i < prioritizedAutomataInstances.size(); ++i) {
            int ruleID = prioritizedRuleIDs.get(i);
            DictionaryLetterFSA automaton = currentG.currentGrammar.ruleAutomata[ruleID];
            aInstancesOnThePath.clear();
            int cFAIindex = prioritizedAutomataInstances.get(i);
            FilteringAutomatonInstance cFAI = mData.fsaInstances.get(cFAIindex);
            this.collectPath(aInstancesOnThePath, cFAIindex, mData.fsaInstances);
            int pathSize = aInstancesOnThePath.size() - 2;
            mData.currentInstances.clear();
            DictionaryLetterFSA.State initState = automaton.getInitialState();
            RuleAutomatonInstanceArrayList ruleFsaInstances = new RuleAutomatonInstanceArrayList();
            RuleAutomatonInstance ruleInst = RuleAutomatonInstance.createInstance(initState, pathSize, FilteringAutomatonInstance.UNDEFINED, null, null);
            ruleFsaInstances.add(ruleInst);
            mData.currentInstances.add(0);
            while (mData.currentInstances.size() > 0) {
                tobeInspectedInstances.clear();
                int numCurrentInstances = mData.currentInstances.size();
                for (int k = 0; k < numCurrentInstances; ++k) {
                    RuleAutomatonInstance newRuleInst;
                    int l;
                    int numNewInstances;
                    RAI.clear();
                    int currentInstanceID = mData.currentInstances.get(k);
                    ruleInst = ruleFsaInstances.get(currentInstanceID);
                    DictionaryLetterFSA.State cState = ruleInst.getState();
                    int pathIndex = ruleInst.getNextDisjunctionID();
                    mData.candidateInstances.clear();
                    int nextDisj = -1;
                    if (pathIndex >= 0) {
                        nextDisj = aInstancesOnThePath.get(pathIndex);
                        FilteringAutomatonInstance filterFsaInst = mData.fsaInstances.get(nextDisj);
                        InputFeatureStructureDisjunction cDisj = currentG.currentInput.get(filterFsaInst.disjunctionID);
                        int[] indices = filterFsaInst.disjunctionElementIDs;
                        int numStructures = indices.length;
                        int start = cDisj.getFeatureStructure(indices[0]).getStart();
                        statesL.clear();
                        labelIndices.clear();
                        if (this.getStatesAfterLabel(cState, statesL, labelIndices, '\ufde8')) {
                            numNewInstances = labelIndices.size();
                            for (l = 0; l < numNewInstances; ++l) {
                                LabelBinding newLabelBinding = LabelBinding.createInstance(true, (byte)labelIndices.get(l), start);
                                RuleAutomatonInstance newRuleInst2 = RuleAutomatonInstance.createInstance(statesL.get(l), pathIndex, currentInstanceID, newLabelBinding, null);
                                if (RAI.contains(newRuleInst2)) continue;
                                ruleFsaInstances.add(newRuleInst2);
                                tobeInspectedInstances.add(ruleFsaInstances.size() - 1);
                                RAI.add(newRuleInst2);
                            }
                        }
                        for (int j = 0; j < numStructures; ++j) {
                            InputFeatureStructure nextFs = cDisj.getFeatureStructure(indices[j]);
                            DictionaryLetterFSA.Transition currentTransition = cState.getFirstTransition();
                            while (currentTransition != null) {
                                NormalizedFeatureStructure normFs;
                                char currentLabel = currentTransition.getLabel();
                                if (currentLabel != '\ufde8' && currentLabel != '\ufde9' && currentLabel != '\ufdea' && this.matchInputStructure(tempVarBindings, nextFs, normFs = currentG.currentGrammar.transitionFS[currentLabel])) {
                                    newRuleInst = RuleAutomatonInstance.createInstance(currentTransition.getTargetState(), pathIndex - 1, currentInstanceID, null, null);
                                    if (tempVarBindings.size() > 0) {
                                        VariableBindings newVarBindings = new VariableBindings();
                                        newVarBindings.setBindings(tempVarBindings);
                                        newRuleInst.setVariableBindings(newVarBindings);
                                    }
                                    if (!RAI.contains(newRuleInst)) {
                                        ruleFsaInstances.add(newRuleInst);
                                        tobeInspectedInstances.add(ruleFsaInstances.size() - 1);
                                        RAI.add(newRuleInst);
                                    }
                                }
                                currentTransition = cState.getNextTransition(currentTransition);
                            }
                        }
                    } else if (this.isFinalForRuleAutomata(cState)) {
                        this.collectVariableAndLabelBindings(labelBindingData, currentInstanceID, ruleFsaInstances, ruleID, currentG);
                        this.createFinalOutputStructures(labelBindingData, ruleID, cFAI.getCharEnd(), result, currentG);
                    }
                    statesL.clear();
                    labelIndices.clear();
                    if (!this.getStatesAfterLabel(cState, statesL, labelIndices, '\ufde9')) continue;
                    numNewInstances = labelIndices.size();
                    for (l = 0; l < numNewInstances; ++l) {
                        FilteringAutomatonInstance extraFilterFsaInst = mData.fsaInstances.get(aInstancesOnThePath.get(pathIndex + 1));
                        InputFeatureStructureDisjunction eDisj = currentG.currentInput.get(extraFilterFsaInst.disjunctionID);
                        int endChar = eDisj.getFeatureStructure(extraFilterFsaInst.disjunctionElementIDs[0]).getEnd();
                        LabelBinding newLabelBinding = LabelBinding.createInstance(false, (byte)labelIndices.get(l), endChar);
                        newRuleInst = RuleAutomatonInstance.createInstance(statesL.get(l), pathIndex, currentInstanceID, newLabelBinding, null);
                        if (RAI.contains(newRuleInst)) continue;
                        ruleFsaInstances.add(newRuleInst);
                        tobeInspectedInstances.add(ruleFsaInstances.size() - 1);
                        RAI.add(newRuleInst);
                    }
                }
                IntArrayList tempInstances = mData.currentInstances;
                mData.currentInstances = tobeInspectedInstances;
                tobeInspectedInstances = tempInstances;
            }
        }
        return result;
    }

    private void createFinalOutputStructures(LabelBindingData labelBindingData, int ruleID, int maxEndPosition, InputFSArrayList results, CurrentGrammarData currentG) {
        NormalizedFeatureStructure[] outFS = currentG.currentActions[ruleID];
        int len = outFS.length;
        for (int i = 0; i < len; ++i) {
            String variableValue;
            NormalizedFeatureStructure outputFS;
            if (labelBindingData.labelBindingStart[i] == -1 || labelBindingData.labelBindingEnd[i] == -1 || (outputFS = outFS[i]) == null) continue;
            InputFeatureStructure finalOutputFS = new InputFeatureStructure();
            finalOutputFS.setPosition(labelBindingData.labelBindingStart[i], labelBindingData.labelBindingEnd[i]);
            finalOutputFS.setType((short)outputFS.getType());
            byte numAttr = (byte)this.types.getNumberAttributesForType(outputFS.getType());
            finalOutputFS.initializeAttributes(numAttr);
            int numAttr2 = outputFS.getLen();
            for (int j = 0; j < numAttr2; ++j) {
                String tempValue = outputFS.getValue(j);
                if (tempValue != null) {
                    tempValue = tempValue.substring(1, tempValue.length() - 1);
                }
                finalOutputFS.setAttribute(j, tempValue);
                byte varID = outputFS.getVariable(j);
                if (varID == NormalizedFeatureStructure.UNBOUND || (variableValue = labelBindingData.variableBindings[varID]) == null) continue;
                finalOutputFS.setAttribute(j, variableValue);
            }
            int numFuncCalls = outputFS.getNumFuncCalls();
            if (numFuncCalls > 0) {
                int k;
                for (k = 0; k < numFuncCalls; ++k) {
                    FuncCallSpecification fCs = outputFS.getFunccCallSpecification(k);
                    int numArgs = fCs.numberOfArguments();
                    String[] arguments = new String[numArgs];
                    for (int l = 0; l < numArgs; ++l) {
                        byte vId;
                        arguments[l] = fCs.isArgumentVariable(l) ? (labelBindingData.variableBindings[vId = fCs.getArgumentVariable(l)] != null ? labelBindingData.variableBindings[vId] : "") : fCs.getArgumentString(l);
                    }
                    try {
                        labelBindingData.variableBindings[fCs.getVariable()] = this.funOpPool.callOperator(fCs.getName(), arguments);
                        continue;
                    }
                    catch (Exception e) {
                        GrammarInterpreter.loggerMessage(e.getMessage());
                    }
                }
                for (k = 0; k < numAttr2; ++k) {
                    byte varID = outputFS.getVariable(k);
                    if (varID == NormalizedFeatureStructure.UNBOUND || (variableValue = labelBindingData.variableBindings[varID]) == null) continue;
                    finalOutputFS.setAttribute(k, variableValue);
                }
            }
            boolean booleanPredicatesTrue = true;
            int numBoolCalls = outputFS.getNumBoolCalls();
            if (numBoolCalls > 0) {
                for (int k = 0; k < numBoolCalls; ++k) {
                    BooleanPredicateSpecification bPS = outputFS.getBooleanPredicateSpecification(k);
                    int numArgs = bPS.numberOfArguments();
                    String[] arguments = new String[numArgs];
                    for (int l = 0; l < numArgs; ++l) {
                        byte vId;
                        arguments[l] = bPS.isArgumentVariable(l) ? (labelBindingData.variableBindings[vId = bPS.getArgumentVariable(l)] != null ? labelBindingData.variableBindings[vId] : "") : bPS.getArgumentString(l);
                    }
                    try {
                        if (this.boolOpPool.callOperator(bPS.getName(), arguments)) continue;
                        booleanPredicatesTrue = false;
                        break;
                    }
                    catch (Exception e) {
                        GrammarInterpreter.loggerMessage("Exception while applying boolean predicate: " + bPS.getName() + " : " + e.getMessage());
                    }
                }
            }
            if (!booleanPredicatesTrue) continue;
            finalOutputFS.setRuleID(ruleID);
            finalOutputFS.setEndPosition(maxEndPosition);
            results.add(finalOutputFS);
        }
    }

    private void initializeVariableAndLabelBindings(LabelBindingData labelBindingData, int ruleID, CurrentGrammarData currentG) {
        int len = currentG.currentGrammar.getNumberOfRules();
        if (ruleID < 0 || ruleID >= len) {
            return;
        }
        int howMany = currentG.currentGrammar.numVariablesForRule[ruleID];
        for (int i = 0; i < howMany; ++i) {
            labelBindingData.variableBindings[i] = null;
        }
        NormalizedFeatureStructure[][] outFS = currentG.currentActions;
        if (outFS.length != len) {
            return;
        }
        howMany = outFS[ruleID] != null ? outFS[ruleID].length : 0;
        for (int i = 0; i < howMany; ++i) {
            labelBindingData.labelBindingStart[i] = -1;
            labelBindingData.labelBindingEnd[i] = -1;
        }
    }

    private void collectVariableAndLabelBindings(LabelBindingData labelBindingData, int ruleAutomataInstanceID, RuleAutomatonInstanceArrayList ruleFsaInstances, int ruleID, CurrentGrammarData currentG) {
        int nextInstID = ruleAutomataInstanceID;
        this.initializeVariableAndLabelBindings(labelBindingData, ruleID, currentG);
        while (nextInstID != RuleAutomatonInstance.UNDEFINED) {
            RuleAutomatonInstance rA = ruleFsaInstances.get(nextInstID);
            LabelBinding labelB = rA.getLabelBinding();
            if (labelB != null) {
                if (labelB.startOfLabel) {
                    labelBindingData.labelBindingStart[labelB.getIndex()] = labelB.getValue();
                } else {
                    labelBindingData.labelBindingEnd[labelB.getIndex()] = labelB.getValue();
                }
            } else {
                VariableBindings variableB = rA.getVariableBindings();
                if (variableB != null) {
                    int numVar = variableB.getNumBindings();
                    for (int j = 0; j < numVar; ++j) {
                        VariableBinding currentVarBinding = variableB.getBinding(j);
                        byte curId = currentVarBinding.getVariableID();
                        String curBin = labelBindingData.variableBindings[curId];
                        boolean append = curBin != null ? curBin.length() > 0 : false;
                        labelBindingData.variableBindings[curId] = append ? currentVarBinding.getValue() + " " + curBin : currentVarBinding.getValue();
                    }
                }
            }
            nextInstID = rA.getPreviousInstanceID();
        }
    }

    private int sortOutputStructures(InputFSDArrayList singleResult, InputFSArrayList outputStructures, int searchTypeID, CurrentGrammarData currentG) {
        InputFeatureStructure currentFS;
        int size;
        InputFSArrayList featureStructureList = new InputFSArrayList();
        Comparator<InputFeatureStructure> myComparator = searchTypeID != 3 ? InputFeatureStructureComparator.getInstance() : InputFeatureStructureComparatorAccordingToStartPos.getInstance();
        outputStructures.sort(myComparator);
        int lastPos = outputStructures.get(0).getStart() + 1;
        int whereToEnd = size = outputStructures.size();
        if (searchTypeID != 3) {
            lastPos = outputStructures.get(0).getEndPosition();
            for (whereToEnd = 1; whereToEnd < size && outputStructures.get(whereToEnd).getEndPosition() == lastPos; ++whereToEnd) {
            }
            ++lastPos;
        }
        IntArrayList structuresToConsider = new IntArrayList(5);
        InputFeatureStructure previousFS = outputStructures.get(0);
        int currentPriority = currentG.currentGrammarPriorities[previousFS.getRuleID()];
        if (previousFS.getType() != this.EMPTY_TYPE_CODE) {
            structuresToConsider.add(0);
        }
        for (int i = 1; i < whereToEnd; ++i) {
            currentFS = outputStructures.get(i);
            int newPriority = currentG.currentGrammarPriorities[currentFS.getRuleID()];
            if (newPriority > currentPriority) {
                structuresToConsider.clear();
                currentPriority = newPriority;
            } else if (newPriority < currentPriority) continue;
            previousFS = currentFS;
            if (previousFS.getType() == this.EMPTY_TYPE_CODE) continue;
            structuresToConsider.add(i);
        }
        if (structuresToConsider.size() > 0) {
            previousFS = outputStructures.get(structuresToConsider.get(0));
            int currentStartPosition = previousFS.getStart();
            featureStructureList.add(previousFS);
            int sizeStructs = structuresToConsider.size();
            for (int current = 1; current < sizeStructs; ++current) {
                currentFS = outputStructures.get(structuresToConsider.get(current));
                int nextPosition = currentFS.getStart();
                if (nextPosition != currentStartPosition) {
                    if (featureStructureList.size() > 0) {
                        singleResult.add(InputFeatureStructureDisjunction.createNewInputFSD(featureStructureList));
                    }
                    featureStructureList.clear();
                    currentStartPosition = nextPosition;
                } else if (currentFS.matchesTheSameRegion(previousFS) && currentFS.hasEqualContent(previousFS)) continue;
                previousFS = currentFS;
                featureStructureList.add(currentFS);
            }
            if (featureStructureList.size() > 0) {
                singleResult.add(InputFeatureStructureDisjunction.createNewInputFSD(featureStructureList));
            }
        }
        return lastPos;
    }

    private void collectPath(IntArrayList aInstancesOnThePath, int indexOfLastInstance, FilteringAutomatonInstanceArrayList fAList) {
        aInstancesOnThePath.add(indexOfLastInstance);
        FilteringAutomatonInstance fA = fAList.get(indexOfLastInstance);
        int previousInstanceID = fA.getPreviousInstanceID();
        while (previousInstanceID != FilteringAutomatonInstance.UNDEFINED) {
            aInstancesOnThePath.add(previousInstanceID);
            fA = fAList.get(previousInstanceID);
            previousInstanceID = fA.getPreviousInstanceID();
        }
    }

    private boolean matchInputStructure(VariableBindingArrayList tempVarBindings, InputFeatureStructure iFs, NormalizedFeatureStructure nFs) {
        if (nFs.getType() != iFs.getType()) {
            return false;
        }
        int len = iFs.getLen();
        if (nFs.getLen() != len) {
            return false;
        }
        tempVarBindings.clear();
        for (int i = 0; i < len; ++i) {
            String currentValue = nFs.getValue(i);
            String inputValue = iFs.getValue(i);
            if (currentValue != null && (inputValue != null ? currentValue.compareTo("\"" + inputValue + "\"") != 0 : currentValue.compareTo("\"\"") != 0)) {
                return false;
            }
            if (nFs.getVariable(i) == NormalizedFeatureStructure.UNBOUND || inputValue == null) continue;
            tempVarBindings.add(VariableBinding.createInstance(nFs.getVariable(i), inputValue));
        }
        return true;
    }

    private boolean getStatesAfterLabel(DictionaryLetterFSA.State state, DictionaryLetterFSAStatesArrayList states, IntArrayList labelIndices, char label) {
        DictionaryLetterFSA.State currentState;
        DictionaryLetterFSA.Transition currentTransition = state.getTransitionLabelledWith(label);
        DictionaryLetterFSA.State state2 = currentState = currentTransition != null ? currentTransition.getTargetState() : null;
        if (currentState != null) {
            currentTransition = currentState.getFirstTransition();
            while (currentTransition != null) {
                states.add(currentTransition.getTargetState());
                labelIndices.add((int)currentTransition.getLabel());
                currentTransition = currentState.getNextTransition(currentTransition);
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        GrammarInterpreter gInterpreter = new GrammarInterpreter();
        String configurationFile = args[0];
        Properties confProperties = gInterpreter.readProperties(configurationFile);
        if (gInterpreter.launch(confProperties)) {
            File outputDir;
            String InputFileDirectory = confProperties.getProperty("InputFileDirectory", null);
            String CharacterSet = confProperties.getProperty("CharacterSet", "UTF-8");
            String OutputFileDirectory = confProperties.getProperty("OutputFileDirectory", null);
            ArrayList<File> myFiles = new ArrayList<File>();
            boolean status = Files.readFileNamesFromDirectory((String)InputFileDirectory, myFiles);
            if (!status) {
                GrammarInterpreter.loggerErrorMessageAndReturn("Errors encountered while reading the directory: " + InputFileDirectory);
                System.exit(0);
            }
            status = true;
            File file = outputDir = OutputFileDirectory != null ? new File(OutputFileDirectory) : null;
            if (!(outputDir == null || outputDir.isDirectory() && outputDir.canWrite())) {
                status = false;
            }
            if (!status) {
                GrammarInterpreter.loggerErrorMessageAndReturn("Errors encountered while accessing the directory: " + OutputFileDirectory);
                System.exit(0);
            }
            gInterpreter.applyToFilesDebug(myFiles, CharacterSet, outputDir);
        }
    }

    public String resultsToString(InputFSDArrayList result, String Input) {
        if (result == null) {
            return null;
        }
        int numDisj = result.size();
        StringBuffer output = new StringBuffer(numDisj);
        for (int i = 0; i < numDisj; ++i) {
            InputFeatureStructureDisjunction current = result.get(i);
            int size = current.getLen();
            for (int j = 0; j < size; ++j) {
                output.append(this.structureToString(current.getFeatureStructure(j), Input));
                output.append(SystemEnv.LINE_SEPARATOR);
                output.append("-----------------------");
                output.append(SystemEnv.LINE_SEPARATOR);
            }
            output.append("-----------------------");
            output.append(SystemEnv.LINE_SEPARATOR);
        }
        return output.toString();
    }

    private String ruleStatistics(InputFSDArrayList result, int level) {
        int i;
        ReefsGrammar myGrammar = this.cascade.getGrammar(level);
        int numRules = myGrammar.getNumberOfRules();
        int[] stats = new int[numRules];
        Arrays.fill(stats, 0);
        int numDisj = result != null ? result.size() : 0;
        int totalCount = 0;
        StringBuffer output = new StringBuffer(numDisj);
        for (i = 0; i < numDisj; ++i) {
            InputFeatureStructureDisjunction current = result.get(i);
            int size = current.getLen();
            for (int j = 0; j < size; ++j) {
                InputFeatureStructure myFS = current.getFeatureStructure(j);
                int n = myFS.getRuleID();
                stats[n] = stats[n] + 1;
                ++totalCount;
            }
        }
        for (i = 0; i < numRules; ++i) {
            String myStat = "Rule: <" + myGrammar.getRuleName(i) + ">  :  " + stats[i];
            output.append(myStat);
            output.append(SystemEnv.LINE_SEPARATOR);
        }
        String myStat = "Total number of rules applied: " + totalCount;
        output.append(myStat);
        output.append(SystemEnv.LINE_SEPARATOR);
        return output.toString();
    }

    private StringBuffer resultsToTabSeparatedAttributeValuePairs(InputFSDArrayList result, String input) {
        if (result == null) {
            return null;
        }
        int numDisj = result.size();
        StringBuffer output = new StringBuffer(numDisj);
        for (int i = 0; i < numDisj; ++i) {
            InputFeatureStructureDisjunction current = result.get(i);
            int size = current.getLen();
            for (int j = 0; j < size; ++j) {
                output.append(this.structureToTabSeparatedAttibuteValuePairs(current.getFeatureStructure(j), input));
                output.append(SystemEnv.LINE_SEPARATOR);
            }
        }
        return output;
    }

    private String structureToString(InputFeatureStructure result, String Input) {
        StringBuffer out = new StringBuffer();
        int start = result.getStart();
        int end = result.getEnd();
        StringTokenizer sT = new StringTokenizer(Input.substring(start, end + 1), " \t\n\r");
        out.append("CONTENT: ");
        while (sT.hasMoreTokens()) {
            out.append(sT.nextToken());
            out.append(' ');
        }
        out.append(SystemEnv.LINE_SEPARATOR);
        out.append("POSITION: ");
        out.append('[');
        out.append(start);
        out.append(',');
        out.append(end);
        out.append("]");
        out.append(SystemEnv.LINE_SEPARATOR);
        out.append("STRUCTURE-TYPE: ");
        short type = result.getType();
        out.append(this.types.getTypeName(type));
        out.append(SystemEnv.LINE_SEPARATOR);
        int len = result.getLen();
        out.append("FEATURES:");
        out.append(SystemEnv.LINE_SEPARATOR);
        for (int i = 0; i < len; ++i) {
            out.append(this.types.getAttributeName(type, i));
            out.append("=");
            if (result.getValue(i) != null) {
                out.append(result.getValue(i));
            } else {
                out.append("-");
            }
            if (i + 1 >= len) continue;
            out.append(SystemEnv.LINE_SEPARATOR);
        }
        return out.toString();
    }

    private String structureToTabSeparatedAttibuteValuePairs(InputFeatureStructure result, String Input) {
        StringBuffer out = new StringBuffer();
        int start = result.getStart();
        int end = result.getEnd();
        StringTokenizer sT = new StringTokenizer(Input.substring(start, end + 1), " \t\n\r");
        out.append('\"');
        while (sT.hasMoreTokens()) {
            out.append(sT.nextToken());
            if (!sT.hasMoreTokens()) continue;
            out.append(' ');
        }
        out.append('\"');
        out.append('\t');
        out.append(start);
        out.append('\t');
        out.append(end);
        out.append('\t');
        short type = result.getType();
        out.append(this.types.getTypeName(type));
        int len = result.getLen();
        for (int i = 0; i < len; ++i) {
            if (result.getValue(i) == null) continue;
            out.append('\t');
            out.append(this.types.getAttributeName(type, i));
            out.append("\t");
            out.append(result.getValue(i));
        }
        return out.toString();
    }

    public boolean launch(Properties configuration) {
        GrammarInterpreter.loggerMessage("Launching the grammar interpreter");
        GrammarInterpreter.loggerMessage("Loading resources started");
        if (!this.initialize(configuration)) {
            return GrammarInterpreter.loggerErrorMessageAndReturn("Error encountered while loading the resources specified in the configuration properties: ");
        }
        GrammarInterpreter.loggerMessage("Loading resources ended");
        GrammarInterpreter.loggerMessage("Checking consistency of resources started");
        if (!this.checkConsistency()) {
            return GrammarInterpreter.loggerErrorMessageAndReturn("Incosistencies in the loaded resources were encountered");
        }
        GrammarInterpreter.loggerMessage("Checking consistency of resources ended");
        GrammarInterpreter.loggerMessage("Launching the grammar interpreter completed");
        return true;
    }

    private boolean initialize(Properties confProperties) {
        boolean status = true;
        GrammarInterpreter.loggerMessage("Reading configuration properties");
        status = confProperties != null;
        String CascadedGrammarFile = null;
        String ModuleConfigurationDirectory = null;
        String DebugModusOn = null;
        String DebugAllGrammarsOn = null;
        String SplitingFilesIntoLine = null;
        String DebugRuleStatistics = null;
        if (status) {
            CascadedGrammarFile = confProperties.getProperty("CascadedGrammarFile");
            ModuleConfigurationDirectory = confProperties.getProperty("ModuleConfigDirectory");
            DebugModusOn = confProperties.getProperty("DebugModusOn", "");
            DebugAllGrammarsOn = confProperties.getProperty("DebugAllGrammarsOn", "");
            SplitingFilesIntoLine = confProperties.getProperty("SplitingFilesIntoLine", "");
            DebugRuleStatistics = confProperties.getProperty("DebugRuleStatistics", "");
            if (CascadedGrammarFile == null) {
                logger.error((Object)GrammarInterpreter.PropertyError("CascadedGrammarFile"));
                status = false;
            }
            if (ModuleConfigurationDirectory == null) {
                logger.error((Object)GrammarInterpreter.PropertyError("ModuleConfigDirectory"));
                status = false;
            }
        }
        if (status) {
            GrammarInterpreter.loggerMessage("Load cascaded grammar from the file: " + CascadedGrammarFile);
            this.cascade = new ReefsCascade();
            status = this.cascade.readFromFile(CascadedGrammarFile);
            if (!status) {
                return GrammarInterpreter.loggerErrorMessageAndReturn("Could not initialize cascaded grammar from file: " + CascadedGrammarFile);
            }
            this.types = this.cascade.getTypes();
            this.EMPTY_TYPE_CODE = this.types.getTypeIDtoInt(EMPTY_TYPE);
            this.numberOfPhases = this.cascade.getNumPhases();
            GrammarInterpreter.loggerMessage("Initialize modules specified in the module configuration directory: " + ModuleConfigurationDirectory);
            ArrayList moduleConfigurationFiles = new ArrayList();
            status = Files.readFileNamesFromDirectory((String)ModuleConfigurationDirectory, moduleConfigurationFiles);
            if (!status) {
                return GrammarInterpreter.loggerErrorMessageAndReturn("Errors while accessing the directory: " + ModuleConfigurationDirectory + " containing module configuration files.");
            }
            int numModules = moduleConfigurationFiles.size();
            for (int i = 0; i < numModules; ++i) {
                String modulePath = ((File)moduleConfigurationFiles.get(i)).getAbsolutePath();
                if (!modulePath.endsWith(".cfg")) continue;
                GrammarInterpreter.loggerMessage("Launching module specified in the file: " + modulePath);
                if (Module.initialize(ModuleConfigurationDirectory, modulePath, this.mPool) != null) continue;
                return GrammarInterpreter.loggerErrorMessageAndReturn("Error while initializing module via loading a configuration file: " + modulePath);
            }
            HashMap<String, Module> cModules = this.mPool.getModules();
            GrammarInterpreter.loggerMessage(cModules.size() + " MODULES INSTALLED");
            Iterator<String> it = cModules.keySet().iterator();
            while (it.hasNext()) {
                GrammarInterpreter.loggerMessage(it.next() + " INSTALLED");
            }
            if (DebugModusOn.compareTo("true") == 0) {
                this.setDebugModusOn();
            } else {
                this.setDebugModusOff();
            }
            if (DebugAllGrammarsOn.compareTo("true") == 0) {
                this.setDebugAllGrammarsModusOn();
            } else {
                this.setDebugAllGrammarsModusOff();
            }
            if (DebugRuleStatistics.compareTo("true") == 0) {
                this.setDebugRuleStatisticsOn();
            } else {
                this.setDebugRuleStatisticsOff();
            }
            GrammarInterpreter.loggerMessage("Debugging mode is: " + (this.debugModusOn() ? "ON" : "OFF"));
            GrammarInterpreter.loggerMessage("Debugging all grammars mode is: " + (this.debugAllGrammarsModusOn() ? "ON" : "OFF"));
            GrammarInterpreter.loggerMessage("Debugging rule statistics is: " + (this.debugRuleStatisticsOn() ? "ON" : "OFF"));
            if (SplitingFilesIntoLine.compareTo("true") == 0) {
                this.setSplitingFilesToLinesOn();
            } else {
                this.setSplitingFilesToLinesOff();
            }
            GrammarInterpreter.loggerMessage("Spliting files into an array of lines is : " + (this.splitingFilesToLinesOn() ? "ON" : "OFF"));
        }
        return status;
    }

    public void setDebugModusOn() {
        this.debugModusOn = true;
    }

    public void setDebugAllGrammarsModusOn() {
        this.debugAllGrammars = true;
    }

    public void setDebugRuleStatisticsOn() {
        this.debugRuleStatistics = true;
    }

    public void setSplitingFilesToLinesOn() {
        this.splitFilesToLines = true;
    }

    public void setDebugModusOff() {
        this.debugModusOn = false;
    }

    public void setDebugAllGrammarsModusOff() {
        this.debugAllGrammars = false;
    }

    public void setDebugRuleStatisticsOff() {
        this.debugRuleStatistics = false;
    }

    public void setSplitingFilesToLinesOff() {
        this.splitFilesToLines = false;
    }

    public boolean debugModusOn() {
        return this.debugModusOn;
    }

    public boolean debugAllGrammarsModusOn() {
        return this.debugAllGrammars;
    }

    public boolean debugRuleStatisticsOn() {
        return this.debugRuleStatistics;
    }

    public boolean splitingFilesToLinesOn() {
        return this.splitFilesToLines;
    }

    private boolean checkConsistency() {
        ArrayList<String> errors = new ArrayList<String>();
        GrammarInterpreter.loggerMessage("Checking whether module names appearing in the grammar are launched");
        int numGrammars = this.cascade.getNumPhases();
        this.modules = new Module[numGrammars][];
        this.typeConvert = new short[numGrammars][][];
        HashSet<String> myModuleNames = new HashSet<String>();
        for (int i = 0; i < numGrammars; ++i) {
            ReefsGrammar grammar = this.cascade.getGrammar(i);
            int numComponents = grammar.getNumberComponents();
            this.modules[i] = new Module[numComponents];
            this.typeConvert[i] = new short[numComponents][];
            for (int j = 0; j < numComponents; ++j) {
                String componentName = grammar.getComponentName(j);
                try {
                    this.modules[i][j] = this.mPool.getModuleViaName(componentName);
                    int numTypes = this.modules[i][j].getNumberTypes();
                    this.typeConvert[i][j] = new short[numTypes];
                    myModuleNames.add(componentName);
                    continue;
                }
                catch (NoSuchModuleException e) {
                    errors.add("Module: " + componentName + " declared in grammar (phase[" + i + "]) is not present in the module pool.");
                }
            }
        }
        GrammarInterpreter.loggerMessage("Checking whether global types specification is consistent with type specification for each of the launched modules (which will be used)");
        for (String nextModuleName : myModuleNames) {
            Module nextModule = null;
            try {
                nextModule = this.mPool.getModuleViaName(nextModuleName);
                if (nextModule.checkTypeConsistency(this.types)) continue;
                errors.add("Type inconsistency in module: " + nextModuleName);
            }
            catch (NoSuchModuleException e) {
                errors.add("Module: " + nextModuleName + " does not exist.");
            }
        }
        if (errors.size() == 0) {
            int numPhases = this.modules.length;
            for (int i = 0; i < numPhases; ++i) {
                int numComponents = this.modules[i].length;
                for (int j = 0; j < numComponents; ++j) {
                    Module m = this.modules[i][j];
                    int numTypes = this.modules[i][j].getNumberTypes();
                    for (int k = 0; k < numTypes; ++k) {
                        String type = m.getTypeName(k);
                        this.typeConvert[i][j][k] = this.types.getTypeID(type).shortValue();
                    }
                }
            }
        }
        int numErrors = errors.size();
        for (int i = 0; i < numErrors; ++i) {
            GrammarInterpreter.loggerMessage((String)errors.get(i));
        }
        return errors.size() <= 0;
    }

    private boolean runModules(int phase, char[] inputText, ResultPool rPool) {
        if (phase < 0 || phase >= this.cascade.getNumPhases()) {
            return false;
        }
        int numModules = this.modules[phase].length;
        for (int i = 0; i < numModules; ++i) {
            Object nativeResult = this.modules[phase][i].process(inputText, rPool);
            InputFSArrayList result = this.modules[phase][i].convert(nativeResult, inputText);
            if (result != null) {
                this.convertTypes(phase, i, result);
                boolean status = rPool.addModuleResult(this.modules[phase][i].getComponentName(), result, phase);
                if (status) {
                    status = rPool.addModuleNativeResult(this.modules[phase][i].getComponentName(), nativeResult, phase);
                }
                if (status) continue;
                GrammarInterpreter.loggerMessage("Error while adding results to result pool by: " + this.modules[phase][i].getComponentName() + " in phase: " + phase);
                return false;
            }
            GrammarInterpreter.loggerMessage("Error while applying module: " + this.modules[phase][i].getComponentName());
            return false;
        }
        return true;
    }

    private void convertTypes(int phase, int module, InputFSArrayList result) {
        int len = result.size();
        for (int i = 0; i < len; ++i) {
            InputFeatureStructure fs = result.get(i);
            fs.setType(this.typeConvert[phase][module][fs.getType()]);
        }
    }

    protected static void loggerMessage(String message) {
        logger.info((Object)message);
    }

    protected static boolean loggerErrorMessageAndReturn(String message) {
        logger.error((Object)message);
        return false;
    }

    private static String PropertyError(String PropertyName) {
        return "Missing Property: " + PropertyName;
    }

    private class LabelBindingData {
        String[] variableBindings = new String[256];
        int[] labelBindingStart = new int[256];
        int[] labelBindingEnd = new int[256];
    }

    private class MatchingData {
        IntArrayList currentLongestMatches = new IntArrayList(100);
        FilteringAutomatonInstanceArrayList fsaInstances = new FilteringAutomatonInstanceArrayList(300);
        IntArrayList currentInstances = new IntArrayList(100);
        HashMap<DictionaryLetterFSA.State, HashMap<Integer, IntArrayList>> candidateInstances = new HashMap(100);
        boolean emptyMatch = false;

        public void clear() {
            this.currentInstances.clear();
            this.currentLongestMatches.clear();
            this.fsaInstances.clear();
            this.emptyMatch = false;
            this.candidateInstances.clear();
        }
    }

    private class CurrentGrammarData {
        ReefsGrammar currentGrammar;
        DictionaryLetterFSA currentAutomaton;
        NormalizedFeatureStructure[][] currentActions;
        int[] currentGrammarPriorities;
        InputFSDArrayList currentInput;
        int currentInputLen;

        public CurrentGrammarData(ReefsGrammar grammar, InputFSDArrayList input) {
            this.currentGrammar = grammar;
            this.currentAutomaton = grammar.grammarAutomaton;
            this.currentActions = grammar != null ? grammar.outputFS : (NormalizedFeatureStructure[][])null;
            this.currentGrammarPriorities = grammar.rulePriorities;
            this.currentInput = input;
            this.currentInputLen = input.size();
        }
    }

    private class ListMerging {
        InputFSArrayList[] inputList;
        int[] inputListCounter;
        int[] inputListNumElement;
        int[] listsWithCurrentMinimum;
        int numLists;

        public ListMerging(int max) {
            this.inputList = new InputFSArrayList[max];
            this.inputListCounter = new int[max];
            this.inputListNumElement = new int[max];
            this.listsWithCurrentMinimum = new int[max];
            this.numLists = 0;
        }
    }
}

