/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

public class InputFeatureStructure {
    private int ruleID;
    private int endPosition;
    private short type;
    private int start;
    private short lenMatch;
    private byte len;
    private String[] value;
    public static short UNBOUND = (short)-1;

    public void setRuleID(int i) {
        this.ruleID = i;
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public byte getLen() {
        return this.len;
    }

    public short getLenOfMatch() {
        return this.lenMatch;
    }

    public short getType() {
        return this.type;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.start + this.lenMatch;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public String getValue(int i) {
        return i >= 0 && i < this.value.length ? this.value[i] : null;
    }

    public void setType(short type) {
        this.type = type;
    }

    public void setPosition(int start, int end) {
        this.start = start;
        this.lenMatch = (short)(end - start);
    }

    public void setEndPosition(int i) {
        this.endPosition = i;
    }

    public void setAttributes(byte len, String[] val) {
        this.len = len;
        this.value = new String[len];
        for (int i = 0; i < len; ++i) {
            this.value[i] = new String(val[i]);
        }
    }

    public void initializeAttributes(byte len) {
        this.len = len;
        this.value = new String[len];
        for (int i = 0; i < len; ++i) {
            this.value[i] = null;
        }
    }

    public void setAttribute(int index, String value) {
        if (index >= 0 && index < this.len) {
            this.value[index] = value;
        }
    }

    public InputFeatureStructure() {
        this.type = UNBOUND;
        this.len = 0;
        this.value = null;
        this.start = UNBOUND;
        this.lenMatch = 0;
        this.ruleID = UNBOUND;
        this.endPosition = UNBOUND;
    }

    public InputFeatureStructure(InputFeatureStructure fs) {
        this.type = fs.type;
        this.len = fs.len;
        this.start = fs.start;
        this.ruleID = fs.ruleID;
        this.lenMatch = fs.lenMatch;
        this.value = new String[fs.len];
        for (int i = 0; i < this.len; ++i) {
            this.value[i] = fs.value[i] != null ? new String(fs.value[i]) : null;
        }
        this.endPosition = fs.endPosition;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(this.start);
        out.append(' ');
        out.append(this.start + this.lenMatch);
        out.append(' ');
        out.append(this.type);
        out.append(' ');
        out.append(this.len);
        out.append(' ');
        out.append(this.endPosition);
        out.append('\n');
        for (int i = 0; i < this.len; ++i) {
            out.append(i);
            out.append(":");
            if (this.value[i] != null) {
                out.append(this.value[i]);
            } else {
                out.append(UNBOUND);
            }
            out.append("  ");
        }
        out.append('\n');
        return out.toString();
    }

    public boolean isEqualTo(InputFeatureStructure fs) {
        if (fs == null) {
            return false;
        }
        if (this.start != fs.start) {
            return false;
        }
        if (this.lenMatch != fs.lenMatch) {
            return false;
        }
        if (this.type != fs.type) {
            return false;
        }
        if (this.len != fs.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            String val2;
            String val1 = this.value[i];
            if (val1 == null ^ (val2 = fs.getValue(i)) == null) {
                return false;
            }
            if (val1 == null || val1.compareTo(val2) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean matchesTheSameRegion(InputFeatureStructure fs) {
        if (fs == null) {
            return false;
        }
        if (this.start != fs.start) {
            return false;
        }
        return this.lenMatch == fs.lenMatch;
    }

    public boolean hasEqualContent(InputFeatureStructure fs) {
        if (fs == null) {
            return false;
        }
        if (this.type != fs.type) {
            return false;
        }
        if (this.len != fs.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            String val2;
            String val1 = this.value[i];
            if (val1 == null ^ (val2 = fs.getValue(i)) == null) {
                return false;
            }
            if (val1 == null || val1.compareTo(val2) == 0) continue;
            return false;
        }
        return true;
    }
}

