/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;

public class InputFeatureStructureDisjunction {
    private InputFeatureStructure[] structures;
    private short len;

    public short getLen() {
        return this.len;
    }

    public InputFeatureStructure getFeatureStructure(int i) {
        return i < 0 || i >= this.len ? null : this.structures[i];
    }

    public InputFeatureStructureDisjunction() {
        this.len = 0;
        this.structures = null;
    }

    public void setLen(int len) {
        this.len = (short)len;
    }

    public void setLen(short len) {
        this.len = len;
    }

    public void setFeatureStructures(InputFSArrayList fsList) {
        if (fsList == null) {
            return;
        }
        int len = fsList.size();
        this.setLen(len);
        this.structures = new InputFeatureStructure[len];
        for (int i = 0; i < len; ++i) {
            this.structures[i] = fsList.get(i);
        }
    }

    public static InputFeatureStructureDisjunction createNewInputFSD(InputFSArrayList fsList) {
        InputFeatureStructureDisjunction iFSD = new InputFeatureStructureDisjunction();
        iFSD.setFeatureStructures(fsList);
        return iFSD;
    }

    public void setFeatureStructures(InputFeatureStructure[] fsList) {
        if (fsList == null) {
            return;
        }
        int len = fsList.length;
        this.setLen(len);
        this.structures = new InputFeatureStructure[len];
        for (int i = 0; i < len; ++i) {
            this.structures[i] = fsList[i];
        }
    }

    public InputFeatureStructureDisjunction(InputFeatureStructureDisjunction disj) {
        if (disj != null) {
            this.setFeatureStructures(disj.structures);
        }
    }

    public int computeMaxEnd() {
        int maxEnd = -1;
        for (int i = 0; i < this.len; ++i) {
            int cEnd = this.structures[i].getEnd();
            if (cEnd <= maxEnd) continue;
            maxEnd = cEnd;
        }
        return maxEnd;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(this.len);
        out.append(" structures");
        out.append('\n');
        for (int i = 0; i < this.len; ++i) {
            out.append(this.structures[i].toString());
            out.append("------------------------------------");
            out.append('\n');
        }
        return out.toString();
    }
}

