/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.BooleanPredicateSpecification;
import it.jrc.lt.regexpfs.FuncCallSpecification;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class NormalizedFeatureStructure {
    private int type;
    private byte len;
    private String[] value;
    private byte[] variable;
    private FuncCallSpecification[] funCalls;
    private BooleanPredicateSpecification[] boolCalls;
    public static byte UNBOUND = (byte)-1;

    public boolean writeToStream(DataOutputStream d) throws IOException {
        int i;
        int len;
        int i2;
        d.writeInt(this.type);
        d.writeByte(this.len);
        for (i2 = 0; i2 < this.len; ++i2) {
            if (this.value[i2] != null) {
                d.writeBoolean(true);
                d.writeInt(this.value[i2].length());
                d.writeChars(this.value[i2]);
                continue;
            }
            d.writeBoolean(false);
        }
        for (i2 = 0; i2 < this.len; ++i2) {
            d.writeByte(this.variable[i2]);
        }
        if (this.funCalls == null) {
            d.writeInt(UNBOUND);
        } else {
            len = this.funCalls.length;
            d.writeInt(len);
            for (i = 0; i < len; ++i) {
                this.funCalls[i].writeToStream(d);
            }
        }
        if (this.boolCalls == null) {
            d.writeInt(UNBOUND);
        } else {
            len = this.boolCalls.length;
            d.writeInt(len);
            for (i = 0; i < len; ++i) {
                this.boolCalls[i].writeToStream(d);
            }
        }
        return true;
    }

    public boolean readFromStream(DataInputStream d) throws IOException {
        int i;
        this.type = d.readInt();
        this.len = d.readByte();
        this.value = new String[this.len];
        this.variable = new byte[this.len];
        for (i = 0; i < this.len; ++i) {
            boolean exist = d.readBoolean();
            if (exist) {
                int entryLen = d.readInt();
                char[] temp = new char[entryLen];
                for (int j = 0; j < entryLen; ++j) {
                    temp[j] = d.readChar();
                }
                this.value[i] = new String(temp);
                continue;
            }
            this.value[i] = null;
        }
        for (i = 0; i < this.len; ++i) {
            this.variable[i] = d.readByte();
        }
        int len = d.readInt();
        if (len == UNBOUND) {
            this.funCalls = null;
        } else {
            this.funCalls = new FuncCallSpecification[len];
            for (int i2 = 0; i2 < len; ++i2) {
                this.funCalls[i2] = new FuncCallSpecification();
                this.funCalls[i2].readFromStream(d);
            }
        }
        len = d.readInt();
        if (len == UNBOUND) {
            this.boolCalls = null;
        } else {
            this.boolCalls = new BooleanPredicateSpecification[len];
            for (int i3 = 0; i3 < len; ++i3) {
                this.boolCalls[i3] = new BooleanPredicateSpecification();
                this.boolCalls[i3].readFromStream(d);
            }
        }
        return true;
    }

    public int getNumFuncCalls() {
        return this.funCalls == null ? 0 : this.funCalls.length;
    }

    public int getNumBoolCalls() {
        return this.boolCalls == null ? 0 : this.boolCalls.length;
    }

    public FuncCallSpecification getFunccCallSpecification(int i) {
        if (i < 0 || i >= this.getNumFuncCalls()) {
            return null;
        }
        return this.funCalls[i];
    }

    public BooleanPredicateSpecification getBooleanPredicateSpecification(int i) {
        if (i < 0 || i >= this.getNumBoolCalls()) {
            return null;
        }
        return this.boolCalls[i];
    }

    public void setFuncCalls(FuncCallSpecification[] fCalls) {
        if (fCalls == null) {
            return;
        }
        int len = fCalls.length;
        this.funCalls = new FuncCallSpecification[len];
        for (int i = 0; i < len; ++i) {
            this.funCalls[i] = new FuncCallSpecification(fCalls[i]);
        }
    }

    public void setBoolCalls(BooleanPredicateSpecification[] bCalls) {
        if (bCalls == null) {
            return;
        }
        int len = bCalls.length;
        this.boolCalls = new BooleanPredicateSpecification[len];
        for (int i = 0; i < len; ++i) {
            this.boolCalls[i] = new BooleanPredicateSpecification(bCalls[i]);
        }
    }

    public void setFuncCalls(ArrayList<FuncCallSpecification> fCalls) {
        if (fCalls == null) {
            return;
        }
        int len = fCalls.size();
        this.funCalls = new FuncCallSpecification[len];
        for (int i = 0; i < len; ++i) {
            this.funCalls[i] = new FuncCallSpecification(fCalls.get(i));
        }
    }

    public void setBoolCalls(ArrayList<BooleanPredicateSpecification> bCalls) {
        if (bCalls == null) {
            return;
        }
        int len = bCalls.size();
        this.boolCalls = new BooleanPredicateSpecification[len];
        for (int i = 0; i < len; ++i) {
            this.boolCalls[i] = new BooleanPredicateSpecification(bCalls.get(i));
        }
    }

    public byte getLen() {
        return this.len;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public NormalizedFeatureStructure() {
        this.type = -1;
        this.len = 0;
        this.value = null;
        this.value = null;
        this.funCalls = null;
        this.boolCalls = null;
    }

    public NormalizedFeatureStructure(NormalizedFeatureStructure fs) {
        int numBCalls;
        this.type = fs.type;
        this.len = fs.len;
        this.value = new String[this.len];
        this.variable = new byte[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.value[i] = fs.value[i];
            this.variable[i] = fs.variable[i];
        }
        int numFCalls = fs.getNumFuncCalls();
        if (numFCalls > 0) {
            this.funCalls = new FuncCallSpecification[numFCalls];
            for (int i = 0; i < numFCalls; ++i) {
                this.funCalls[i] = new FuncCallSpecification(fs.getFunccCallSpecification(i));
            }
        } else {
            this.funCalls = null;
        }
        if ((numBCalls = fs.getNumBoolCalls()) > 0) {
            this.boolCalls = new BooleanPredicateSpecification[numBCalls];
            for (int i = 0; i < numBCalls; ++i) {
                this.boolCalls[i] = new BooleanPredicateSpecification(fs.getBooleanPredicateSpecification(i));
            }
        } else {
            this.boolCalls = null;
        }
    }

    public void set(int type, byte len, String[] val, byte[] var) {
        this.type = type;
        this.len = len;
        this.value = new String[len];
        this.variable = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.value[i] = new String(val[i]);
            this.variable[i] = var[i];
        }
    }

    public void set(byte len, String[] val, byte[] var) {
        this.len = len;
        this.value = new String[len];
        this.variable = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.value[i] = val[i] != null ? val[i] : null;
            this.variable[i] = var[i];
        }
    }

    public String getValue(int i) {
        return i >= 0 && i < this.value.length ? this.value[i] : null;
    }

    public byte getVariable(int i) {
        return i >= 0 && i < this.variable.length ? this.variable[i] : UNBOUND;
    }

    public String toStringFull() {
        int i;
        int len;
        StringBuffer out = new StringBuffer();
        out.append(this.type);
        for (int i2 = 0; i2 < this.len; ++i2) {
            out.append(" ");
            out.append(i2);
            out.append(":");
            if (this.value[i2] != null) {
                out.append(this.value[i2]);
            }
            out.append(":");
            out.append(this.variable[i2]);
        }
        if (this.funCalls != null) {
            len = this.funCalls.length;
            for (i = 0; i < len; ++i) {
                out.append(" | ");
                out.append(this.funCalls[i].toString());
            }
        }
        if (this.boolCalls != null) {
            len = this.boolCalls.length;
            for (i = 0; i < len; ++i) {
                out.append(" | ");
                out.append(this.boolCalls[i].toString());
            }
        }
        return out.toString();
    }

    public String toStringReduced() {
        StringBuffer out = new StringBuffer();
        out.append(this.type);
        for (int i = 0; i < this.len; ++i) {
            out.append(" ");
            out.append(i);
            out.append(":");
            if (this.value[i] == null) continue;
            out.append(this.value[i]);
        }
        return out.toString();
    }
}

