/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.FeatureStructure;
import it.jrc.lt.regexpfs.Label;
import java.util.ArrayList;

public class ParseNode {
    public static final char ROOT = 'r';
    public static final char CONCATENATION = 'c';
    public static final char DISJUNCTION = 'd';
    public static final char KLEENE_TOP = 'k';
    public static final char KLEENE_PLUS = 'p';
    public static final char KLEENE_STAR = 's';
    public static final char ZERO_ONE = 'z';
    public static final char RANGE = 'x';
    public static final char ELEMENT = 'e';
    public static final char BASIC_ELEMENT = 'b';
    public static final char UNDERSPECIFIED = 'n';
    private char type;
    private int from;
    private int to;
    private ArrayList<ParseNode> kids;
    private Label label;
    private FeatureStructure fs;

    public void setFS(FeatureStructure f) {
        this.fs = f != null ? new FeatureStructure(f) : null;
    }

    public FeatureStructure getFS() {
        return this.fs;
    }

    public void setFromTo(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public void setLabel(Label label) {
        this.label = label != null ? new Label(label) : null;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setType(char c) {
        this.type = c;
    }

    public char getType() {
        return this.type;
    }

    public void addKid(ParseNode o) {
        if (this.kids == null) {
            this.kids = new ArrayList();
        }
        this.kids.add(o);
    }

    public ArrayList<ParseNode> getKids() {
        return this.kids;
    }

    public int getNumKids() {
        return this.kids != null ? this.kids.size() : 0;
    }

    public ParseNode getKid(int i) {
        return i >= 0 && i < this.kids.size() ? this.kids.get(i) : null;
    }

    public void setKids(ArrayList<ParseNode> a) {
        int len = a.size();
        this.kids = new ArrayList();
        for (int i = 0; i < len; ++i) {
            ParseNode next = a.get(i);
            if (next == null) {
                this.kids.add(null);
                continue;
            }
            this.kids.add(next);
        }
    }

    public ParseNode() {
        this.kids = null;
        this.type = (char)110;
        this.fs = null;
        this.label = null;
        this.from = 0;
        this.to = 0;
    }

    public ParseNode(ParseNode p) {
        this.setFS(p.fs);
        this.setLabel(p.label);
        this.setType(p.type);
        this.setKids(p.kids);
    }

    public void print(String sep) {
        System.out.print(sep + this.type);
        if (this.label != null) {
            System.out.print(" LABEL: " + this.label.toString());
        }
        if (this.fs != null) {
            System.out.print(" STRUCT: " + this.fs.toString());
        }
        System.out.println("");
        int numKids = this.kids != null ? this.kids.size() : 0;
        for (int i = 0; i < numKids; ++i) {
            this.getKid(i).print(sep + "  ");
        }
    }
}

