/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.ReefsGrammar;
import it.jrc.lt.regexpfs.ReefsGrammarTypes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import piskorski.util.functions.Files;

public class ReefsCascade {
    private ReefsGrammarTypes types;
    private ReefsGrammar[] grammars;
    private int numPhases;

    private void init() {
        this.grammars = null;
        this.types = null;
        this.numPhases = 0;
    }

    public ReefsCascade() {
        this.init();
    }

    public int getNumPhases() {
        return this.numPhases;
    }

    public ReefsGrammarTypes getTypes() {
        return this.types != null ? this.types : null;
    }

    public ReefsGrammar getGrammar(int index) {
        if (this.grammars == null) {
            return null;
        }
        return index >= 0 && index < this.grammars.length ? this.grammars[index] : null;
    }

    public boolean set(ReefsGrammarTypes types, ArrayList<ReefsGrammar> grammars) {
        if (types == null || grammars == null) {
            return false;
        }
        this.numPhases = grammars.size();
        this.types = new ReefsGrammarTypes(types);
        this.grammars = new ReefsGrammar[this.numPhases];
        for (int i = 0; i < this.numPhases; ++i) {
            this.grammars[i] = new ReefsGrammar(grammars.get(i));
        }
        return true;
    }

    public ReefsCascade(ReefsCascade cascade) {
        this.numPhases = cascade.numPhases;
        this.types = new ReefsGrammarTypes(cascade.types);
        this.grammars = new ReefsGrammar[this.numPhases];
        for (int i = 0; i < this.numPhases; ++i) {
            this.grammars[i] = new ReefsGrammar(cascade.grammars[i]);
        }
    }

    public boolean saveToFile(String file) {
        byte[] fill = null;
        boolean status = true;
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            DataOutputStream d = new DataOutputStream(byteOS);
            status = this.writeToStream(d);
            d.close();
            byteOS.close();
            if (status) {
                fill = byteOS.toByteArray();
            }
        }
        catch (IOException e) {
            return false;
        }
        if (status) {
            status = Files.writeByteArrayToFile((byte[])fill, (String)file);
        }
        fill = null;
        return status;
    }

    public boolean readFromFile(String file) {
        byte[] randomAccess = null;
        File FileName = new File(file);
        int size = (int)FileName.length();
        randomAccess = new byte[size];
        boolean status = Files.readByteArrayFromFile((byte[])randomAccess, (String)file);
        if (!status) {
            return false;
        }
        try {
            ByteArrayInputStream byteIS = new ByteArrayInputStream(randomAccess);
            DataInputStream d = new DataInputStream(byteIS);
            this.readFromStream(d);
            d.close();
            byteIS.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean writeToStream(DataOutputStream d) throws IOException {
        if (this.grammars == null || this.types == null) {
            return false;
        }
        d.writeInt(this.numPhases);
        this.types.writeToStream(d);
        for (int i = 0; i < this.numPhases; ++i) {
            this.grammars[i].writeToStream(d);
        }
        return true;
    }

    public boolean readFromStream(DataInputStream d) throws IOException {
        this.numPhases = d.readInt();
        this.types = new ReefsGrammarTypes();
        this.types.readFromStream(d);
        this.grammars = new ReefsGrammar[this.numPhases];
        for (int i = 0; i < this.numPhases; ++i) {
            this.grammars[i] = new ReefsGrammar();
            this.grammars[i].readFromStream(d);
        }
        return true;
    }

    public void print() {
        System.out.println("CASCADE:");
        System.out.println("----------------");
        System.out.println("Types: ");
        System.out.println("----------------");
        System.out.println(this.types.toString());
        System.out.println("Grammars: ");
        System.out.println("----------------");
        int size = this.grammars.length;
        for (int i = 0; i < size; ++i) {
            System.out.println("Grammar: " + i);
            System.out.println("----------------");
            this.grammars[i].print();
        }
    }
}

