/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import dk.brics.automaton.Automaton;
import it.jrc.lt.automaton.auxiliary.AutomatonUtilities;
import it.jrc.lt.regexpfs.Action;
import it.jrc.lt.regexpfs.Attribute;
import it.jrc.lt.regexpfs.AttributeValuePair;
import it.jrc.lt.regexpfs.BooleanPredicateAssignment;
import it.jrc.lt.regexpfs.BooleanPredicateName;
import it.jrc.lt.regexpfs.BooleanPredicateSpecification;
import it.jrc.lt.regexpfs.Components;
import it.jrc.lt.regexpfs.FeatureStructure;
import it.jrc.lt.regexpfs.FuncCallSpecification;
import it.jrc.lt.regexpfs.FunctionalOperatorAssignment;
import it.jrc.lt.regexpfs.FunctionalOperatorName;
import it.jrc.lt.regexpfs.Label;
import it.jrc.lt.regexpfs.NormalizedFeatureStructure;
import it.jrc.lt.regexpfs.ParseNode;
import it.jrc.lt.regexpfs.ReefsGrammarCompilationStatus;
import it.jrc.lt.regexpfs.ReefsGrammarTypes;
import it.jrc.lt.regexpfs.RightHandSide;
import it.jrc.lt.regexpfs.Rule;
import it.jrc.lt.regexpfs.RulePriorities;
import it.jrc.lt.regexpfs.RulePriority;
import it.jrc.lt.regexpfs.SimpleValue;
import it.jrc.lt.regexpfs.Type;
import it.jrc.lt.regexpfs.Value;
import it.jrc.lt.regexpfs.Variable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSA;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSATraversing;
import piskorski.util.functions.Files;

public class ReefsGrammar {
    static final char TYPE_START = '*';
    static final char ATTRIBUTE_VALUE_MARKER = ':';
    static final char ANY_VALUE = '#';
    static final char RULE_ID_MARKER = '-';
    static final char LABEL_START_MARKER = '\ufde8';
    static final char LABEL_END_MARKER = '\ufde9';
    static final char RULE_END_MARKER = '\ufdea';
    static final int OUTPUT_TYPE_GRAMMAR_AND_UNCONSUMED = 2;
    static final int OUTPUT_TYPE_ALL = 3;
    static final int OUTPUT_TYPE_GRAMMAR = 1;
    static final int OUTPUT_TYPE_NONE = 4;
    static final int OUTPUT_TYPE_UNKNOWN = 0;
    static final int SEARCHING_STRATEGY_LONGEST_MATCH = 1;
    static final int SEARCHING_STRATEGY_ALL_LONGEST_MATCHES = 2;
    static final int SEARCHING_STRATEGY_ALL_MATCHES = 3;
    static final int SEARCHING_STRATEGY_UNKNOWN = 0;
    private transient ReefsGrammarTypes types;
    private transient HashMap<String, Integer> labels;
    NormalizedFeatureStructure[][] outputFS;
    int[] rulePriorities;
    int[] numVariablesForRule;
    private transient HashMap<String, Byte> variablesInRule;
    private transient int globalVariableCounter;
    private transient Automaton[][] specialAutomata;
    private HashMap<String, String> mapValueToID;
    private transient Rule[] rules;
    private transient String grammarFile;
    DictionaryLetterFSA[] ruleAutomata;
    String[] ruleName;
    private transient String prioritiesFile;
    DictionaryLetterFSA grammarAutomaton;
    private transient HashMap<String, Integer> globalAlphabet;
    private transient ArrayList<NormalizedFeatureStructure> tempFS;
    NormalizedFeatureStructure[] transitionFS;
    private transient int globalAlphabetCounter;
    private transient HashMap<String, Rule> ruleNameToRule;
    private Components components;
    private String outputType;
    private int outputTypeID;
    private String searchMode;
    private int searchModeID;
    private boolean[] typesAtInitialState;

    boolean isTypeAtInitialState(short type) {
        if (type < 0 || type >= this.typesAtInitialState.length) {
            return false;
        }
        return this.typesAtInitialState[type];
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
        if (outputType == null) {
            this.outputTypeID = 0;
        }
        this.outputTypeID = outputType.compareTo("grammar") == 0 ? 1 : (outputType.compareTo("grammar_and_unconsumed") == 0 ? 2 : (outputType.compareTo("all") == 0 ? 3 : (outputType.compareTo("none") == 0 ? 4 : 0)));
    }

    public void setSearchMode(String mode) {
        this.searchMode = mode;
        if (mode == null) {
            this.searchModeID = 0;
        }
        this.searchModeID = mode.compareTo("longest_match") == 0 ? 1 : (mode.compareTo("all_longest_matches") == 0 ? 2 : (mode.compareTo("all_match") == 0 ? 3 : 0));
    }

    public String getOutputType() {
        return this.outputType;
    }

    public int getOutputTypeID() {
        return this.outputTypeID;
    }

    public String getSearchMode() {
        return this.searchMode;
    }

    public int getSearchTypeID() {
        return this.searchModeID;
    }

    public String getComponentName(int i) {
        if (this.components == null) {
            return null;
        }
        return i >= 0 && i < this.components.getNumberComponents() ? this.components.getComponent(i) : null;
    }

    public int getNumberComponents() {
        if (this.components == null) {
            return 0;
        }
        return this.components.getNumberComponents();
    }

    public void setComponents(Components c) {
        if (c != null) {
            this.components = new Components(c);
        }
    }

    String getGrammarFileName() {
        return this.grammarFile;
    }

    String getPrioirtiesFileName() {
        return this.prioritiesFile;
    }

    void setGrammarFileName(String name) {
        this.grammarFile = name;
    }

    void setPrioritiesFileName(String name) {
        this.prioritiesFile = name;
    }

    ReefsGrammarTypes getAssociatedTypes() {
        return this.types;
    }

    Rule[] getRules() {
        return this.rules;
    }

    String getValueID(String s) {
        return this.mapValueToID.get(s);
    }

    private int getNumberRules() {
        return this.rules != null ? this.rules.length : 0;
    }

    public int getNumberOfRules() {
        return this.ruleAutomata != null ? this.ruleAutomata.length : 0;
    }

    Rule getRule(int i) {
        return i >= 0 && i < this.rules.length ? this.rules[i] : null;
    }

    String getRuleName(int i) {
        return i >= 0 && i < this.ruleName.length ? this.ruleName[i] : null;
    }

    void setRules(Rule[] newRules) {
        int len = newRules.length;
        this.rules = new Rule[len];
        for (int i = 0; i < len; ++i) {
            this.rules[i] = newRules[i] != null ? new Rule(newRules[i]) : null;
        }
    }

    void setRules(ArrayList<Rule> newRules) {
        int len = newRules.size();
        this.rules = new Rule[len];
        for (int i = 0; i < len; ++i) {
            this.rules[i] = new Rule(newRules.get(i));
        }
    }

    ReefsGrammarCompilationStatus checkLHSFS(FeatureStructure fs, Rule rule, HashSet<String> typesOnLHS, HashSet<String> variablesInLHS) {
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        Type type = fs.getType();
        String typeName = type.getName();
        AttributeValuePair[] avp = fs.getAVPairs();
        if (!this.types.isType(typeName)) {
            statusComp.addError("[" + this.getGrammarFileName() + "] " + "Non-declared type \"" + typeName + "\"" + " in the rule \"" + rule.getName() + "\"" + " at line: " + type.getBeginLine() + " and column: " + type.getBeginColumn());
        } else {
            String typeOfCurrentFS;
            if (avp != null) {
                int numAttr = avp.length;
                HashSet<String> attributeNames = new HashSet<String>();
                HashSet<String> variableNames = new HashSet<String>();
                for (int i = 0; i < numAttr; ++i) {
                    Variable v;
                    Value val;
                    Attribute a = avp[i].getAttribute();
                    String aName = a.getName();
                    if (attributeNames.contains(aName)) {
                        statusComp.addError("[" + this.getGrammarFileName() + "] " + "Attribute \"" + aName + "\" at line: " + a.getBeginLine() + " and column: " + a.getBeginColumn() + " appears more than once in the same feature structure");
                    } else {
                        attributeNames.add(aName);
                    }
                    if (!this.types.isAttribute(typeName, aName)) {
                        statusComp.addError("[" + this.getGrammarFileName() + "] " + "Attribute \"" + aName + "\" at line: " + a.getBeginLine() + " and column: " + a.getBeginColumn() + " is not appropriate for type \"" + typeName + "\"");
                    }
                    if ((val = avp[i].getValue()) == null || (v = val.getVariable()) == null) continue;
                    String vName = v.getName();
                    if (variableNames.contains(vName)) {
                        statusComp.addError("[" + this.getGrammarFileName() + "] " + "Variable \"" + vName + "\" at line: " + v.getBeginLine() + " and column: " + v.getBeginColumn() + " appears more than once in the same feature structure on the LHS");
                    } else {
                        variableNames.add(vName);
                    }
                    if (this.variablesInRule.get(rule.getName() + " " + vName) != null) continue;
                    this.variablesInRule.put(rule.getName() + " " + vName, new Byte((byte)this.globalVariableCounter));
                    variablesInLHS.add(vName);
                    ++this.globalVariableCounter;
                }
            }
            if (!typesOnLHS.contains(typeOfCurrentFS = fs.getType().getName())) {
                typesOnLHS.add(typeOfCurrentFS);
            }
        }
        return statusComp;
    }

    ReefsGrammarCompilationStatus checkRHSFSandFO(FeatureStructure fs, Rule rule, ArrayList<FunctionalOperatorAssignment> foA, ArrayList<BooleanPredicateAssignment> boP, HashSet<String> varOnRHS, HashSet<String> typesOnRHS, HashSet<String> variablesInLHS) {
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        Type type = fs.getType();
        String typeName = type.getName();
        AttributeValuePair[] avp = fs.getAVPairs();
        HashSet<String> variablesInRHS = new HashSet<String>();
        HashSet<String> variablesInFoAssigmnents = new HashSet<String>();
        HashSet<String> variablesAsFoBpArguments = new HashSet<String>();
        if (!this.types.isType(typeName)) {
            statusComp.addError("[" + this.getGrammarFileName() + "] " + "Non-declared type \"" + typeName + "\"" + " in the rule \"" + rule.getName() + "\"" + " at line: " + type.getBeginLine() + " and column: " + type.getBeginColumn());
        } else {
            String typeOfCurrentFS;
            int i;
            if (avp != null) {
                int numAttr = avp.length;
                HashSet<String> attributeNames = new HashSet<String>();
                for (i = 0; i < numAttr; ++i) {
                    Variable v;
                    Value val;
                    Attribute a = avp[i].getAttribute();
                    String aName = a.getName();
                    if (attributeNames.contains(aName)) {
                        statusComp.addError("[" + this.getGrammarFileName() + "] " + "Attribute \"" + aName + "\" at line: " + a.getBeginLine() + " and column: " + a.getBeginColumn() + " appears more than once in the same feature structure");
                    } else {
                        attributeNames.add(aName);
                    }
                    if (!this.types.isAttribute(typeName, aName)) {
                        statusComp.addError("[" + this.getGrammarFileName() + "] " + "Attribute \"" + aName + "\" at line: " + a.getBeginLine() + " and column: " + a.getBeginColumn() + " is not appropriate for type \"" + typeName + "\"");
                    }
                    if ((val = avp[i].getValue()) == null || (v = val.getVariable()) == null) continue;
                    String vName = v.getName();
                    if (this.variablesInRule.get(rule.getName() + " " + vName) == null) {
                        this.variablesInRule.put(rule.getName() + " " + vName, new Byte((byte)this.globalVariableCounter));
                        ++this.globalVariableCounter;
                    }
                    if (variablesInRHS.contains(vName)) continue;
                    variablesInRHS.add(vName);
                    varOnRHS.add(vName);
                }
            }
            if (!typesOnRHS.contains(typeOfCurrentFS = fs.getType().getName())) {
                typesOnRHS.add(typeOfCurrentFS);
            }
            int numOperators = foA != null ? foA.size() : 0;
            for (i = 0; i < numOperators; ++i) {
                Class<?> oC;
                FunctionalOperatorAssignment fA = foA.get(i);
                FunctionalOperatorName fAN = fA.getName();
                String name = fAN.getName();
                Variable vF = fA.getVariable();
                String vFName = vF.getName();
                int numArgs = fA.getNumArguments();
                if (!variablesInFoAssigmnents.contains(vFName)) {
                    variablesInFoAssigmnents.add(vFName);
                } else {
                    statusComp.addError("[" + this.getGrammarFileName() + "] " + "Variable \"" + vFName + "\" at line: " + vF.getBeginLine() + " and column: " + vF.getBeginColumn() + " appears more than once in the list of functional operator assignemnts in the RHS of the rule " + rule.getName());
                }
                try {
                    oC = Thread.currentThread().getContextClassLoader().loadClass("it.jrc.lt.regexpfs.funop." + name);
                }
                catch (Exception e) {
                    oC = null;
                }
                catch (Error e) {
                    oC = null;
                }
                if (oC == null) {
                    statusComp.addError("[" + this.getGrammarFileName() + "] " + "Functional operator \"" + name + "\" at line: " + fAN.getBeginLine() + " and column: " + fAN.getBeginColumn() + " is not implemented");
                }
                if (!variablesInRHS.contains(vFName)) {
                    statusComp.addError("[" + this.getGrammarFileName() + "] " + "Variable \"" + vFName + "\" at line: " + vF.getBeginLine() + " and column: " + vF.getBeginColumn() + " does not appear elsewhere in the RHS of the rule " + rule.getName());
                }
                for (int k = 0; k < numArgs; ++k) {
                    Class<?> c;
                    Object argument = fA.getArgument(k);
                    if (argument == null || (c = argument.getClass()).getName().compareTo("it.jrc.lt.regexpfs.Variable") != 0) continue;
                    Variable nextV = (Variable)argument;
                    String nextVName = nextV.getName();
                    if (vFName.compareTo(nextVName) == 0) {
                        statusComp.addError("[" + this.getGrammarFileName() + "] " + "Variable \"" + nextVName + "\" at line: " + nextV.getBeginLine() + " and column: " + nextV.getBeginColumn() + " appears on the left and right side of functional operator assignment in the rule " + rule.getName());
                    }
                    if (this.variablesInRule.get(rule.getName() + " " + nextVName) == null) {
                        statusComp.addError("[" + this.getGrammarFileName() + "] " + "Variable \"" + nextVName + "\" at line: " + nextV.getBeginLine() + " and column: " + nextV.getBeginColumn() + " does not appear elsewhere in the rule " + rule.getName());
                    }
                    if (variablesAsFoBpArguments.contains(nextVName)) continue;
                    variablesAsFoBpArguments.add(nextVName);
                    varOnRHS.add(nextVName);
                }
            }
            int numBoolOperators = boP != null ? boP.size() : 0;
            for (int i2 = 0; i2 < numBoolOperators; ++i2) {
                Class<?> oC;
                BooleanPredicateAssignment bP = boP.get(i2);
                BooleanPredicateName bPN = bP.getName();
                String name = bPN.getName();
                int numArgs = bP.getNumArguments();
                try {
                    oC = Thread.currentThread().getContextClassLoader().loadClass("it.jrc.lt.regexpfs.booleanOperator." + name);
                }
                catch (Exception e) {
                    oC = null;
                }
                catch (Error e) {
                    oC = null;
                }
                if (oC == null) {
                    statusComp.addError("[" + this.getGrammarFileName() + "] " + "Boolean operator \"" + name + "\" at line: " + bPN.getBeginLine() + " and column: " + bPN.getBeginColumn() + " is not implemented");
                }
                for (int k = 0; k < numArgs; ++k) {
                    Class<?> c;
                    Object argument = bP.getArgument(k);
                    if (argument == null || (c = argument.getClass()).getName().compareTo("it.jrc.lt.regexpfs.Variable") != 0) continue;
                    Variable nextV = (Variable)argument;
                    String nextVName = nextV.getName();
                    if (this.variablesInRule.get(rule.getName() + " " + nextVName) == null) {
                        statusComp.addError("[" + this.getGrammarFileName() + "] " + "Variable \"" + nextVName + "\" at line: " + nextV.getBeginLine() + " and column: " + nextV.getBeginColumn() + " does not appear elsewhere in the rule " + rule.getName());
                    }
                    if (variablesAsFoBpArguments.contains(nextVName)) continue;
                    variablesAsFoBpArguments.add(nextVName);
                    varOnRHS.add(nextVName);
                }
            }
        }
        for (String variable : variablesInRHS) {
            if (variablesInLHS.contains(variable) || variablesInFoAssigmnents.contains(variable)) continue;
            statusComp.addWarning("[" + this.getGrammarFileName() + "] " + "Variable: " + variable + " that appears on RHS of the rule " + rule.getName() + " at line: " + rule.getBeginLine() + " and column: " + rule.getBeginColumn() + " is never defined (neither on LHS nor in FO assignment.");
        }
        return statusComp;
    }

    ReefsGrammarCompilationStatus checkIfContainsLabeledConstructions(ParseNode node, Rule rule) {
        int to;
        int from;
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        if (node == null) {
            return statusComp;
        }
        int numKids = node.getNumKids();
        Label label = node.getLabel();
        char type = node.getType();
        if (label != null) {
            String lab = label.getName();
            statusComp.addError("[" + this.getGrammarFileName() + "] " + "Illegal construction: Label \"" + lab + "\" used within a Kleene (or Range) structure" + " in the rule \"" + rule.getName() + "\"" + " at line: " + label.getBeginLine() + " and column: " + label.getBeginColumn());
        }
        if (type == 'x' && (from = node.getFrom()) > (to = node.getTo())) {
            statusComp.addError("[" + this.getGrammarFileName() + "] " + "Incorrect values: <" + from + "," + to + "> used in the range operator" + " in the rule \"" + rule.getName() + "\"" + " at line: " + rule.getBeginLine() + " and column: " + rule.getBeginColumn());
        }
        for (int j = 0; j < numKids; ++j) {
            statusComp.addToCompilationsStatus(this.checkIfContainsLabeledConstructions(node.getKid(j), rule));
        }
        return statusComp;
    }

    ReefsGrammarCompilationStatus checkKleeneConstructions(ParseNode node, Rule rule) {
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        if (node == null) {
            return statusComp;
        }
        int numKids = node.getNumKids();
        char type = node.getType();
        switch (type) {
            case 'p': 
            case 's': 
            case 'x': 
            case 'z': {
                statusComp.addToCompilationsStatus(this.checkIfContainsLabeledConstructions(node, rule));
                break;
            }
            default: {
                for (int j = 0; j < numKids; ++j) {
                    statusComp.addToCompilationsStatus(this.checkKleeneConstructions(node.getKid(j), rule));
                }
            }
        }
        return statusComp;
    }

    private boolean acceptsEpsilon(ParseNode node) {
        if (node == null) {
            return false;
        }
        int numKids = node.getNumKids();
        char type = node.getType();
        switch (type) {
            case 's': 
            case 'z': {
                return true;
            }
            case 'b': {
                return false;
            }
            case 'x': {
                return node.getFrom() == 0;
            }
        }
        for (int j = 0; j < numKids; ++j) {
            if (this.acceptsEpsilon(node.getKid(j))) continue;
            return false;
        }
        return true;
    }

    ReefsGrammarCompilationStatus checkLabeledConstructions(ParseNode node, Rule rule) {
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        if (node != null) {
            int numKids = node.getNumKids();
            if (node.getLabel() != null && this.acceptsEpsilon(node)) {
                Label label = node.getLabel();
                String lab = node.getLabel().getName();
                statusComp.addError("[" + this.getGrammarFileName() + "] " + "Illegal construction: Structure labeled with \"" + lab + "\" accepts empty input in the rule \"" + rule.getName() + "\"" + " at line: " + label.getBeginLine() + " and column: " + label.getBeginColumn());
            }
            for (int j = 0; j < numKids; ++j) {
                statusComp.addToCompilationsStatus(this.checkLabeledConstructions(node.getKid(j), rule));
            }
        }
        return statusComp;
    }

    ReefsGrammarCompilationStatus checkLHS(ParseNode node, HashMap<String, Label> labels, Rule rule, HashSet<String> typesOnLHS, HashSet<String> variablesInLHS) {
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        if (node != null) {
            FeatureStructure fs = node.getFS();
            Label label = node.getLabel();
            if (fs != null) {
                statusComp.addToCompilationsStatus(this.checkLHSFS(fs, rule, typesOnLHS, variablesInLHS));
            }
            if (label != null) {
                String lab = label.getName();
                if (labels.containsKey(lab)) {
                    statusComp.addError("[" + this.getGrammarFileName() + "] " + "Multiple occurence of the label \"" + lab + "\"" + " in the rule \"" + rule.getName() + "\"" + " at line: " + label.getBeginLine() + " and column: " + label.getBeginColumn());
                } else {
                    labels.put(lab, label);
                }
            }
            int numKids = node.getNumKids();
            for (int j = 0; j < numKids; ++j) {
                statusComp.addToCompilationsStatus(this.checkLHS(node.getKid(j), labels, rule, typesOnLHS, variablesInLHS));
            }
        }
        return statusComp;
    }

    ReefsGrammarCompilationStatus checkRHS(Rule rule, HashMap<String, Label> labelsRHS, HashSet<String> typesOnRHS, HashSet<String> variablesInLHS) {
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        RightHandSide rhs = rule.getRHS();
        if (rhs != null) {
            int numActions = rhs.getNumberActions();
            HashSet<String> variablesOnRHS = new HashSet<String>();
            for (int i = 0; i < numActions; ++i) {
                Action nextAction = rhs.getAction(i);
                Label nextLabel = nextAction.getLabel();
                String label = nextLabel.getName();
                FeatureStructure fs = nextAction.getFS();
                ArrayList<FunctionalOperatorAssignment> foA = nextAction.getFunctionalOperatorAssignment();
                ArrayList<BooleanPredicateAssignment> boP = nextAction.getBooleanPredicates();
                statusComp.addToCompilationsStatus(this.checkRHSFSandFO(fs, rule, foA, boP, variablesOnRHS, typesOnRHS, variablesInLHS));
                if (labelsRHS.containsKey(label)) {
                    statusComp.addError("[" + this.getGrammarFileName() + "] " + "Multiple occurence of the label \"" + label + "\"" + " in the RHS of the rule \"" + rule.getName() + "\"" + " at line: " + nextLabel.getBeginLine() + " and column: " + nextLabel.getBeginColumn());
                    continue;
                }
                labelsRHS.put(label, nextLabel);
            }
            for (String variable : variablesInLHS) {
                if (variablesOnRHS.contains(variable)) continue;
                statusComp.addWarning("[" + this.getGrammarFileName() + "] " + "Variable: " + variable + " that appears on LHS of the rule " + rule.getName() + " at line: " + rule.getBeginLine() + " and column: " + rule.getBeginColumn() + " is never used on the RHS.");
            }
        }
        return statusComp;
    }

    ReefsGrammarCompilationStatus checkRules() {
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        this.ruleNameToRule = new HashMap();
        int numRules = this.getNumberRules();
        this.variablesInRule = new HashMap();
        this.numVariablesForRule = new int[numRules];
        this.ruleName = new String[numRules];
        HashSet<String> variablesInLHS = new HashSet<String>();
        HashSet<String> typesOnLHS = new HashSet<String>();
        HashSet<String> typesOnRHS = new HashSet<String>();
        for (int i = 0; i < numRules; ++i) {
            Label l;
            typesOnLHS.clear();
            typesOnRHS.clear();
            variablesInLHS.clear();
            Rule currentRule = this.rules[i];
            String ruleName = currentRule.getName();
            this.ruleName[i] = currentRule.getName();
            if (this.ruleNameToRule.containsKey(ruleName)) {
                statusComp.addError("[" + this.getGrammarFileName() + "] " + "Multiple definition of rule \"" + ruleName + "\" at line: " + currentRule.getBeginLine() + " and column: " + currentRule.getBeginColumn());
            } else {
                this.ruleNameToRule.put(ruleName, currentRule);
            }
            HashMap<String, Label> labelsLHS = new HashMap<String, Label>();
            this.globalVariableCounter = 0;
            statusComp.addToCompilationsStatus(this.checkLHS(currentRule.getLHS().getRoot(), labelsLHS, currentRule, typesOnLHS, variablesInLHS));
            statusComp.addToCompilationsStatus(this.checkKleeneConstructions(currentRule.getLHS().getRoot(), currentRule));
            statusComp.addToCompilationsStatus(this.checkLabeledConstructions(currentRule.getLHS().getRoot(), currentRule));
            HashMap<String, Label> labelsRHS = new HashMap<String, Label>();
            statusComp.addToCompilationsStatus(this.checkRHS(currentRule, labelsRHS, typesOnRHS, variablesInLHS));
            this.numVariablesForRule[i] = this.globalVariableCounter;
            Set<String> keySet = labelsLHS.keySet();
            if (keySet.size() > 0) {
                for (String next : keySet) {
                    if (labelsRHS.containsKey(next)) continue;
                    l = labelsLHS.get(next);
                    statusComp.addError("[" + this.getGrammarFileName() + "] " + "Label \"" + next + "\" in the LHS of the rule at line: " + l.getBeginLine() + " and column: " + l.getBeginColumn() + " does not appear on the RHS");
                }
            }
            if ((keySet = labelsRHS.keySet()).size() > 0) {
                for (String next : keySet) {
                    if (labelsLHS.containsKey(next)) continue;
                    l = labelsRHS.get(next);
                    statusComp.addError("[" + this.getGrammarFileName() + "] " + "Label \"" + next + "\" in the RHS of the rule at line: " + l.getBeginLine() + " and column: " + l.getBeginColumn() + " does not appear on the LHS");
                }
            }
            statusComp.addToCompilationsStatus(this.checkWhetherSameTypeAppearsOnBothSides(currentRule, typesOnLHS, typesOnRHS));
        }
        return statusComp;
    }

    private ReefsGrammarCompilationStatus checkWhetherSameTypeAppearsOnBothSides(Rule currentRule, HashSet<String> typesOnLHS, HashSet<String> typesOnRHS) {
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        for (String currentType : typesOnRHS) {
            if (!typesOnLHS.contains(currentType)) continue;
            statusComp.addWarning("[" + this.getGrammarFileName() + "] " + "Type: " + currentType + " appears on both LHS/RHS of the rule " + currentRule.getName() + " at line: " + currentRule.getBeginLine() + " and column: " + currentRule.getBeginColumn());
        }
        return statusComp;
    }

    ReefsGrammarCompilationStatus checkOutputType() {
        ReefsGrammarCompilationStatus status = ReefsGrammarCompilationStatus.createInstance();
        if (this.outputTypeID == 0) {
            status.addError("[" + this.getGrammarFileName() + "] The value of the OUTPUT parameter: \"" + this.outputType + "\" specified in the settings section is invalid");
        }
        return status;
    }

    ReefsGrammarCompilationStatus checkSearchMode() {
        ReefsGrammarCompilationStatus status = ReefsGrammarCompilationStatus.createInstance();
        if (this.searchModeID == 0) {
            status.addError("[" + this.getGrammarFileName() + "] The value of the SEARCH MODE parameter: \"" + this.searchMode + "\" specified in the settings section is invalid");
        }
        return status;
    }

    ReefsGrammarCompilationStatus checkComponents() {
        ReefsGrammarCompilationStatus status = ReefsGrammarCompilationStatus.createInstance();
        if (this.components != null) {
            int numComps = this.components.getNumberComponents();
            HashSet<String> comps = new HashSet<String>();
            for (int i = 0; i < numComps; ++i) {
                String next = this.components.getComponent(i);
                if (comps.contains(next)) {
                    status.addError("[" + this.getGrammarFileName() + "] The component name : \"" + next + "\" specified in the settings section appears more than once");
                }
                comps.add(next);
            }
        }
        return status;
    }

    void associateTypes(ReefsGrammarTypes t) {
        this.types = t;
    }

    ReefsGrammarCompilationStatus checkGrammar(RulePriorities p) {
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        System.out.println("Checking grammar");
        System.out.println("Checking output types");
        statusComp.addToCompilationsStatus(this.checkOutputType());
        System.out.println("Checking search mode");
        statusComp.addToCompilationsStatus(this.checkSearchMode());
        System.out.println("Checking component names");
        statusComp.addToCompilationsStatus(this.checkComponents());
        System.out.println("Checking rules");
        statusComp.addToCompilationsStatus(this.checkRules());
        if (statusComp.noErrorsPresent()) {
            if (p != null) {
                statusComp.addToCompilationsStatus(this.checkAndUpdatePriorities(p));
            }
            this.computeTypeAttributeMatrix();
            this.computeLabelsMapping();
            if (statusComp.noErrorsPresent()) {
                // empty if block
            }
            System.out.println("Convert each rule to a finite-state representation");
            this.convertRulesToFSA();
            this.computeTypesAtInitialState();
        }
        return statusComp;
    }

    private ReefsGrammarCompilationStatus checkAndUpdatePriorities(RulePriorities priorities) {
        ReefsGrammarCompilationStatus statusComp = ReefsGrammarCompilationStatus.createInstance();
        RulePriority[] pr = priorities.getRulePriorities();
        int numPriorities = pr.length;
        HashSet<String> ruleNames = new HashSet<String>();
        for (int i = 0; i < numPriorities; ++i) {
            RulePriority p = pr[i];
            String ruleName = p.getName();
            if (ruleNames.contains(ruleName)) {
                statusComp.addError("[" + this.prioritiesFile + "] " + "Multiple declaration of priority for rule \"" + ruleName + "\" at line: " + p.getBeginLine() + " and column: " + p.getBeginColumn());
            } else {
                ruleNames.add(ruleName);
            }
            if (this.ruleNameToRule.containsKey(ruleName)) {
                Rule r = this.ruleNameToRule.get(ruleName);
                r.setPriority(p.getPriority());
                continue;
            }
            statusComp.addError("[" + this.prioritiesFile + "] " + "Rule named \"" + ruleName + "\" at line: " + p.getBeginLine() + " and column: " + p.getBeginColumn() + " does not exist in the grammar file");
        }
        return statusComp;
    }

    private void init() {
        this.types = null;
        this.variablesInRule = null;
        this.labels = null;
        this.specialAutomata = null;
        this.mapValueToID = null;
        this.rules = null;
        this.grammarFile = null;
        this.prioritiesFile = null;
        this.globalAlphabet = null;
        this.tempFS = null;
        this.ruleNameToRule = null;
        this.outputFS = null;
        this.rulePriorities = null;
        this.numVariablesForRule = null;
        this.ruleAutomata = null;
        this.ruleName = null;
        this.grammarAutomaton = null;
        this.transitionFS = null;
        this.components = null;
        this.outputType = null;
        this.typesAtInitialState = null;
        this.searchMode = null;
    }

    public ReefsGrammar() {
        this.init();
    }

    private void setOutputFeatureStructures(NormalizedFeatureStructure[][] outFS) {
        int len = outFS.length;
        this.outputFS = new NormalizedFeatureStructure[len][];
        for (int i = 0; i < len; ++i) {
            int numLabels = outFS[i].length;
            this.outputFS[i] = new NormalizedFeatureStructure[numLabels];
            for (int j = 0; j < numLabels; ++j) {
                this.outputFS[i][j] = new NormalizedFeatureStructure(outFS[i][j]);
            }
        }
    }

    private void setRulePriorities(int[] priorities) {
        int len = priorities.length;
        this.rulePriorities = new int[len];
        for (int i = 0; i < len; ++i) {
            this.rulePriorities[i] = priorities[i];
        }
    }

    private void setNumberOfVariables(int[] numVar) {
        int len = numVar.length;
        this.numVariablesForRule = new int[len];
        for (int i = 0; i < len; ++i) {
            this.numVariablesForRule[i] = numVar[i];
        }
    }

    private void setTypesAtInitialState(boolean[] typesAIS) {
        int len = typesAIS.length;
        this.typesAtInitialState = new boolean[len];
        for (int i = 0; i < len; ++i) {
            this.typesAtInitialState[i] = typesAIS[i];
        }
    }

    private void setTransitionLabels(NormalizedFeatureStructure[] transitionLabels) {
        int len = transitionLabels.length;
        this.transitionFS = new NormalizedFeatureStructure[len];
        for (int i = 0; i < len; ++i) {
            this.transitionFS[i] = new NormalizedFeatureStructure(transitionLabels[i]);
        }
    }

    private void setGrammarAutomaton(DictionaryLetterFSA a) {
        this.grammarAutomaton = a;
    }

    private void setRuleAutomata(DictionaryLetterFSA[] a) {
        int len = a.length;
        this.ruleAutomata = new DictionaryLetterFSA[len];
        for (int i = 0; i < len; ++i) {
            this.ruleAutomata[i] = DictionaryLetterFSA.getInstance((String)"BASIC");
            this.ruleAutomata[i] = a[i];
        }
    }

    private void setRuleNames(String[] ruleNames) {
        int len = ruleNames.length;
        this.ruleName = new String[len];
        for (int i = 0; i < len; ++i) {
            this.ruleName[i] = new String(ruleNames[i]);
        }
    }

    private void setMapValToID(HashMap<String, String> myMap) {
        Iterator<String> it = myMap.keySet().iterator();
        this.mapValueToID = new HashMap();
        while (it.hasNext()) {
            String next = it.next();
            this.mapValueToID.put(next, myMap.get(next));
        }
    }

    public HashMap<String, String> getINC() {
        return this.mapValueToID;
    }

    public ReefsGrammar(ReefsGrammar gr) {
        this.init();
        this.setComponents(gr.components);
        this.setOutputType(gr.outputType);
        this.setSearchMode(gr.searchMode);
        this.setOutputFeatureStructures(gr.outputFS);
        this.setRulePriorities(gr.rulePriorities);
        this.setNumberOfVariables(gr.numVariablesForRule);
        this.setTransitionLabels(gr.transitionFS);
        this.setGrammarAutomaton(gr.grammarAutomaton);
        this.setRuleAutomata(gr.ruleAutomata);
        this.setTypesAtInitialState(gr.typesAtInitialState);
        this.setMapValToID(gr.mapValueToID);
        this.setRuleNames(gr.ruleName);
    }

    void printRules() {
        int size = this.rules.length;
        for (int i = 0; i < size; ++i) {
            System.out.println("Rule: " + this.rules[i].getName());
            this.rules[i].printRule();
        }
    }

    private Automaton concatFSA(ArrayList<ParseNode> a, Rule rule) {
        int len = a.size();
        LinkedList<Automaton> aList = new LinkedList<Automaton>();
        for (int i = 0; i < len; ++i) {
            aList.add(this.convertRuleToFSA(a.get(i), rule));
        }
        return Automaton.concatenate(aList);
    }

    private Automaton disjFSA(ArrayList<ParseNode> a, Rule rule) {
        int len = a.size();
        LinkedList<Automaton> aList = new LinkedList<Automaton>();
        for (int i = 0; i < len; ++i) {
            aList.add(this.convertRuleToFSA(a.get(i), rule));
        }
        return Automaton.union(aList);
    }

    private Automaton concatFilterFSA(ArrayList<ParseNode> a, Rule rule) {
        int len = a.size();
        LinkedList<Automaton> aList = new LinkedList<Automaton>();
        for (int i = 0; i < len; ++i) {
            aList.add(this.convertRuleToFilterFSA(a.get(i), rule));
        }
        return Automaton.concatenate(aList);
    }

    private Automaton disjFilterFSA(ArrayList<ParseNode> a, Rule rule) {
        int len = a.size();
        LinkedList<Automaton> aList = new LinkedList<Automaton>();
        for (int i = 0; i < len; ++i) {
            aList.add(this.convertRuleToFilterFSA(a.get(i), rule));
        }
        return Automaton.union(aList);
    }

    private NormalizedFeatureStructure convertFsToNfs(FeatureStructure fs, Rule rule) {
        NormalizedFeatureStructure nfs = new NormalizedFeatureStructure();
        String type = fs.getType().getName();
        int typeID = this.types.getTypeIDtoInt(type);
        nfs.setType(typeID);
        int len = this.types.getNumberAttributesForType(typeID);
        String[] val = new String[len];
        byte[] var = new byte[len];
        for (int i = 0; i < len; ++i) {
            val[i] = null;
            var[i] = NormalizedFeatureStructure.UNBOUND;
        }
        for (AttributeValuePair av : fs.getAVPairs()) {
            String aName = av.getAttribute().getName();
            int aIndex = this.types.getAttributeIDtoInt(type, aName);
            SimpleValue sv = av.getValue().getSimpleValue();
            Variable v = av.getValue().getVariable();
            String string = val[aIndex] = sv != null ? sv.getName() : null;
            if (v != null) {
                byte varIndex;
                String varName = v.getName();
                var[aIndex] = varIndex = this.variablesInRule.get(rule.getName() + " " + varName).byteValue();
                continue;
            }
            var[aIndex] = NormalizedFeatureStructure.UNBOUND;
        }
        nfs.set((byte)len, val, var);
        return nfs;
    }

    private Automaton computeFSAutomaton(NormalizedFeatureStructure fs) {
        ArrayList<Automaton> aCol = new ArrayList<Automaton>();
        int type = fs.getType();
        Automaton a = Automaton.makeChar((char)'*');
        aCol.add(a);
        a = Automaton.makeChar((char)((char)type));
        aCol.add(a);
        Automaton marker = Automaton.makeChar((char)':');
        int len = fs.getLen();
        for (int i = 0; i < len; ++i) {
            String val = fs.getValue(i);
            if (val != null) {
                String ID = this.mapValueToID.get(val);
                Automaton b = Automaton.makeString((String)ID);
                aCol.add(b);
            } else {
                aCol.add(this.specialAutomata[type][i]);
            }
            aCol.add(marker);
        }
        return Automaton.concatenate(aCol);
    }

    private void computeTypesAtInitialState() {
        int numTypes = this.types.getNumberTypes();
        this.typesAtInitialState = new boolean[numTypes];
        Arrays.fill(this.typesAtInitialState, false);
        DictionaryLetterFSA.State q = this.grammarAutomaton.getInitialState();
        DictionaryLetterFSA.Transition t = q.getTransitionLabelledWith('*');
        if (t != null) {
            q = t.getTargetState();
            t = q.getFirstTransition();
            while (t != null) {
                this.typesAtInitialState[t.getLabel()] = true;
                t = q.getNextTransition(t);
            }
        }
    }

    private Automaton convertRuleToFSA(ParseNode p, Rule rule) {
        char type = p.getType();
        switch (type) {
            case 'r': {
                if (p.getNumKids() > 0) {
                    if (p.getLabel() == null) {
                        return this.convertRuleToFSA(p.getKid(0), rule);
                    }
                    int index = this.labels.get(rule.getName() + " " + p.getLabel());
                    Automaton startLabel = Automaton.makeChar((char)'\ufde8');
                    Automaton endLabel = Automaton.makeChar((char)'\ufde9');
                    Automaton indexA = Automaton.makeChar((char)((char)index));
                    Automaton expr = this.convertRuleToFSA(p.getKid(0), rule);
                    ArrayList<Automaton> list = new ArrayList<Automaton>();
                    list.add(startLabel);
                    list.add(indexA);
                    list.add(expr);
                    list.add(endLabel);
                    list.add(indexA);
                    return Automaton.concatenate(list);
                }
                System.out.println("Error !!!");
                System.exit(0);
                break;
            }
            case 'c': {
                if (p.getNumKids() > 1) {
                    return this.concatFSA(p.getKids(), rule);
                }
                return this.convertRuleToFSA(p.getKid(0), rule);
            }
            case 'd': {
                if (p.getNumKids() > 1) {
                    return this.disjFSA(p.getKids(), rule);
                }
                return this.convertRuleToFSA(p.getKid(0), rule);
            }
            case 'k': {
                return this.convertRuleToFSA(p.getKid(0), rule);
            }
            case 'p': {
                return this.convertRuleToFSA(p.getKid(0), rule).repeat(1);
            }
            case 's': {
                return this.convertRuleToFSA(p.getKid(0), rule).repeat();
            }
            case 'z': {
                return this.convertRuleToFSA(p.getKid(0), rule).optional();
            }
            case 'x': {
                return this.convertRuleToFSA(p.getKid(0), rule).repeat(p.getFrom(), p.getTo());
            }
            case 'e': {
                return this.convertRuleToFSA(p.getKid(0), rule);
            }
            case 'b': {
                int currentLabelIndex;
                FeatureStructure fs = p.getFS();
                NormalizedFeatureStructure nfs = this.convertFsToNfs(fs, rule);
                String label = nfs.toStringFull();
                Integer index = this.globalAlphabet.get(label);
                if (index == null) {
                    currentLabelIndex = this.globalAlphabetCounter++;
                    this.globalAlphabet.put(label, new Integer(currentLabelIndex));
                    this.tempFS.add(nfs);
                } else {
                    currentLabelIndex = index;
                }
                return Automaton.makeChar((char)((char)currentLabelIndex));
            }
            case 'n': {
                if (p.getNumKids() > 0) {
                    return this.convertRuleToFSA(p.getKid(0), rule);
                }
                System.out.println("Error !!!");
                System.exit(0);
            }
        }
        return null;
    }

    private Automaton convertRuleToFilterFSA(ParseNode p, Rule rule) {
        char type = p.getType();
        switch (type) {
            case 'r': {
                if (p.getNumKids() > 0) {
                    return this.convertRuleToFilterFSA(p.getKid(0), rule);
                }
                System.out.println("Error !!!");
                System.exit(0);
            }
            case 'c': {
                if (p.getNumKids() > 1) {
                    return this.concatFilterFSA(p.getKids(), rule);
                }
                return this.convertRuleToFilterFSA(p.getKid(0), rule);
            }
            case 'd': {
                if (p.getNumKids() > 1) {
                    return this.disjFilterFSA(p.getKids(), rule);
                }
                return this.convertRuleToFilterFSA(p.getKid(0), rule);
            }
            case 'k': {
                return this.convertRuleToFilterFSA(p.getKid(0), rule);
            }
            case 'p': {
                return this.convertRuleToFilterFSA(p.getKid(0), rule).repeat(1);
            }
            case 's': {
                return this.convertRuleToFilterFSA(p.getKid(0), rule).repeat();
            }
            case 'z': {
                return this.convertRuleToFilterFSA(p.getKid(0), rule).optional();
            }
            case 'x': {
                return this.convertRuleToFilterFSA(p.getKid(0), rule).repeat(p.getFrom(), p.getTo());
            }
            case 'e': {
                return this.convertRuleToFilterFSA(p.getKid(0), rule);
            }
            case 'b': {
                FeatureStructure fs = p.getFS();
                NormalizedFeatureStructure nfs = this.convertFsToNfs(fs, rule);
                return this.computeFSAutomaton(nfs);
            }
            case 'n': {
                if (p.getNumKids() > 0) {
                    return this.convertRuleToFilterFSA(p.getKid(0), rule);
                }
                System.out.println("Error !!!");
                System.exit(0);
            }
        }
        return null;
    }

    private void computeLabelsMapping() {
        this.labels = new HashMap();
        int len = this.getNumberRules();
        this.outputFS = new NormalizedFeatureStructure[len][];
        this.rulePriorities = new int[len];
        for (int i = 0; i < len; ++i) {
            Rule r = this.rules[i];
            this.outputFS[i] = null;
            this.rulePriorities[i] = r.getPriority();
            RightHandSide rhs = r.getRHS();
            if (rhs != null) {
                int numActions = rhs.getNumberActions();
                if (numActions > 0) {
                    this.outputFS[i] = new NormalizedFeatureStructure[numActions];
                }
                for (int j = 0; j < numActions; ++j) {
                    Action act = rhs.getAction(j);
                    String nextLabel = act.getLabel().getName();
                    this.labels.put(r.getName() + " " + nextLabel, j);
                    FeatureStructure fs = act.getFS();
                    this.outputFS[i][j] = this.convertFsToNfs(fs, r);
                    if (act.getNumFuncOperatorAssignments() > 0) {
                        this.setFunctionCalls(this.outputFS[i][j], act, r);
                    }
                    if (act.getNumBooleanPredicates() <= 0) continue;
                    this.setBooleanPredicateCalls(this.outputFS[i][j], act, r);
                }
                continue;
            }
            this.outputFS[i] = new NormalizedFeatureStructure[0];
        }
    }

    private String trimSimpleValue(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length() - 2;
        if (len < 1) {
            return "";
        }
        char[] temp = new char[len];
        for (int i = 0; i < len; ++i) {
            temp[i] = s.charAt(i + 1);
        }
        return new String(temp);
    }

    private void setBooleanPredicateCalls(NormalizedFeatureStructure fs, Action a, Rule r) {
        int numBoolPredCalls = a.getNumBooleanPredicates();
        ArrayList<BooleanPredicateSpecification> boolPredCalls = new ArrayList<BooleanPredicateSpecification>();
        BooleanPredicateSpecification bPS = null;
        BooleanPredicateAssignment bPA = null;
        String ruleName = r.getName();
        for (int i = 0; i < numBoolPredCalls; ++i) {
            bPA = a.getBooleanPredicate(i);
            bPS = new BooleanPredicateSpecification();
            bPS.setName(bPA.getName().getName());
            int numArgs = bPA.getNumArguments();
            String[] val = new String[numArgs];
            byte[] var = new byte[numArgs];
            boolean[] isVariable = new boolean[numArgs];
            for (int k = 0; k < numArgs; ++k) {
                Object argument = bPA.getArgument(k);
                Class<?> c = argument.getClass();
                if (c.getName().compareTo("it.jrc.lt.regexpfs.Variable") == 0) {
                    isVariable[k] = true;
                    val[k] = null;
                    Variable nextV = (Variable)argument;
                    String nextVName = nextV.getName();
                    var[k] = this.variablesInRule.get(ruleName + " " + nextVName);
                    continue;
                }
                isVariable[k] = false;
                val[k] = this.trimSimpleValue(((SimpleValue)argument).getName());
                var[k] = NormalizedFeatureStructure.UNBOUND;
            }
            bPS.setArguments(numArgs, isVariable, val, var);
            boolPredCalls.add(bPS);
        }
        fs.setBoolCalls(boolPredCalls);
    }

    private void setFunctionCalls(NormalizedFeatureStructure fs, Action a, Rule r) {
        int numFuncCalls = a.getNumFuncOperatorAssignments();
        ArrayList<FuncCallSpecification> funcCalls = new ArrayList<FuncCallSpecification>();
        FuncCallSpecification fcS = null;
        FunctionalOperatorAssignment foA = null;
        String ruleName = r.getName();
        for (int i = 0; i < numFuncCalls; ++i) {
            foA = a.getFunctionalOperatorAssignment(i);
            fcS = new FuncCallSpecification();
            fcS.setName(foA.getName().getName());
            String varName = foA.getVariable().getName();
            byte varIndex = this.variablesInRule.get(ruleName + " " + varName);
            fcS.SetVariable(varIndex);
            int numArgs = foA.getNumArguments();
            String[] val = new String[numArgs];
            byte[] var = new byte[numArgs];
            boolean[] isVariable = new boolean[numArgs];
            for (int k = 0; k < numArgs; ++k) {
                Object argument = foA.getArgument(k);
                Class<?> c = argument.getClass();
                if (c.getName().compareTo("it.jrc.lt.regexpfs.Variable") == 0) {
                    isVariable[k] = true;
                    val[k] = null;
                    Variable nextV = (Variable)argument;
                    String nextVName = nextV.getName();
                    var[k] = this.variablesInRule.get(ruleName + " " + nextVName);
                    continue;
                }
                isVariable[k] = false;
                val[k] = this.trimSimpleValue(((SimpleValue)argument).getName());
                var[k] = NormalizedFeatureStructure.UNBOUND;
            }
            fcS.setArguments(numArgs, isVariable, val, var);
            funcCalls.add(fcS);
        }
        fs.setFuncCalls(funcCalls);
    }

    private void computeAttributeValues(ParseNode p, HashMap<String, HashSet<String>> typeAttributeValues) {
        FeatureStructure fs = p.getFS();
        if (fs != null) {
            String type = fs.getType().getName();
            AttributeValuePair[] avp = fs.getAVPairs();
            int len = avp.length;
            for (int i = 0; i < len; ++i) {
                String attribute = avp[i].getAttribute().getName();
                SimpleValue val = avp[i].getValue().getSimpleValue();
                String valString = null;
                if (val != null) {
                    valString = val.getName();
                }
                if (valString == null) continue;
                String key = type + " " + attribute;
                HashSet<String> s = typeAttributeValues.get(key);
                if (s != null) {
                    s.add(valString);
                    continue;
                }
                HashSet<String> newS = new HashSet<String>();
                newS.add(valString);
                typeAttributeValues.put(key, newS);
            }
        }
        int numKids = p.getNumKids();
        for (int i = 0; i < numKids; ++i) {
            this.computeAttributeValues(p.getKid(i), typeAttributeValues);
        }
    }

    private void computeTypeAttributeMatrix() {
        int i;
        HashMap<String, HashSet<String>> typeAttributeValues = new HashMap<String, HashSet<String>>();
        int len = this.types.getNumberTypes();
        this.mapValueToID = new HashMap();
        int mapValIndex = 36;
        this.specialAutomata = new Automaton[len][];
        for (i = 0; i < len; ++i) {
            int attrNum = this.types.getNumberAttributesForType(i);
            this.specialAutomata[i] = new Automaton[attrNum];
        }
        len = this.getNumberRules();
        for (i = 0; i < len; ++i) {
            this.computeAttributeValues(this.rules[i].getLHS().getRoot(), typeAttributeValues);
        }
        int numTypes = this.types.getNumberTypes();
        for (int i2 = 0; i2 < numTypes; ++i2) {
            int NumAttr = this.types.getNumberAttributesForType(i2);
            for (int j = 0; j < NumAttr; ++j) {
                int size;
                HashSet<String> s = typeAttributeValues.get(this.types.getTypeName(i2) + " " + this.types.getAttributeName(i2, j));
                int n = size = s != null ? s.size() : 0;
                if (size > 0) {
                    ArrayList<Automaton> aCol = new ArrayList<Automaton>();
                    Iterator<String> it = s.iterator();
                    int counter = 0;
                    while (it.hasNext()) {
                        String next = it.next();
                        ++counter;
                        String id = this.mapValueToID.get(next);
                        if (id == null) {
                            StringBuffer st = new StringBuffer();
                            st.append((char)mapValIndex);
                            this.mapValueToID.put(next, st.toString());
                            id = this.mapValueToID.get(next);
                            ++mapValIndex;
                        }
                        Automaton a = Automaton.makeString((String)id);
                        aCol.add(a);
                    }
                    Automaton a = Automaton.makeChar((char)'#');
                    aCol.add(a);
                    this.specialAutomata[i2][j] = Automaton.union(aCol);
                    continue;
                }
                this.specialAutomata[i2][j] = Automaton.makeChar((char)'#');
            }
        }
    }

    void convertRulesToFSA() {
        int len = this.getNumberRules();
        this.globalAlphabet = new HashMap();
        this.globalAlphabetCounter = 0;
        this.ruleAutomata = new DictionaryLetterFSA[len];
        char[] ruleID = new char[2];
        ruleID[0] = 45;
        char[] ruleEndMarker = new char[]{'\ufdea', '\ufdea'};
        ArrayList<Automaton> aCol = new ArrayList<Automaton>();
        this.tempFS = new ArrayList();
        for (int i = 0; i < len; ++i) {
            ParseNode root = this.rules[i].getLHS().getRoot();
            System.out.println("Converting rule: " + this.rules[i].getName());
            Automaton nextA = this.convertRuleToFSA(root, this.rules[i]);
            nextA = nextA.concatenate(Automaton.makeString((String)new String(ruleEndMarker)));
            nextA.determinize();
            nextA.minimize();
            this.ruleAutomata[i] = DictionaryLetterFSA.getInstance((String)"BASIC");
            this.ruleAutomata[i].initializeFrom(AutomatonUtilities.convertAutomatonToDynamiLetterFSA(nextA));
            Automaton a = this.convertRuleToFilterFSA(root, this.rules[i]);
            ruleID[1] = (char)i;
            a = a.concatenate(Automaton.makeString((String)new String(ruleID)));
            a.determinize();
            aCol.add(a);
        }
        System.out.println("Conversion of rule automata into Rule Filtering automaton");
        Automaton filterAutomaton = Automaton.union(aCol);
        System.out.println("Determinisation of Rule Filtering automaton");
        filterAutomaton.determinize();
        System.out.println("Converting Deterministic Rule Filtering automaton into efficient representation");
        this.grammarAutomaton = DictionaryLetterFSA.getInstance((String)"BASIC");
        this.grammarAutomaton.initializeFrom(AutomatonUtilities.convertAutomatonToDynamiLetterFSA(filterAutomaton));
        System.out.println("Initialise auxilliary data structures");
        len = this.tempFS.size();
        this.transitionFS = new NormalizedFeatureStructure[len];
        for (int i = 0; i < len; ++i) {
            this.transitionFS[i] = this.tempFS.get(i);
        }
        len = this.transitionFS.length;
    }

    public boolean saveToFile(String file) {
        byte[] fill = null;
        boolean status = true;
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            DataOutputStream d = new DataOutputStream(byteOS);
            status = this.writeToStream(d);
            d.close();
            byteOS.close();
            if (status) {
                fill = byteOS.toByteArray();
            }
        }
        catch (IOException e) {
            return false;
        }
        if (status) {
            status = Files.writeByteArrayToFile((byte[])fill, (String)file);
        }
        fill = null;
        return status;
    }

    public boolean readFromFile(String file) {
        byte[] randomAccess = null;
        File FileName = new File(file);
        int size = (int)FileName.length();
        randomAccess = new byte[size];
        boolean status = Files.readByteArrayFromFile((byte[])randomAccess, (String)file);
        if (!status) {
            return false;
        }
        try {
            ByteArrayInputStream byteIS = new ByteArrayInputStream(randomAccess);
            DataInputStream d = new DataInputStream(byteIS);
            this.readFromStream(d);
            d.close();
            byteIS.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean writeToStream(DataOutputStream d) throws IOException {
        int i;
        this.grammarAutomaton.writeToDataOutputStream(d);
        int len = this.ruleAutomata.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            this.ruleAutomata[i].writeToDataOutputStream(d);
        }
        len = this.transitionFS.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            this.transitionFS[i].writeToStream(d);
        }
        len = this.outputFS.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            int numLabels = this.outputFS[i].length;
            d.writeInt(numLabels);
            for (int j = 0; j < numLabels; ++j) {
                this.outputFS[i][j].writeToStream(d);
            }
        }
        len = this.rulePriorities.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            d.writeInt(this.rulePriorities[i]);
        }
        if (this.components != null) {
            d.writeBoolean(true);
            this.components.writeToStream(d);
        } else {
            d.writeBoolean(false);
        }
        len = this.outputType.length();
        d.writeInt(len);
        d.writeChars(this.outputType);
        d.writeInt(this.outputTypeID);
        len = this.searchMode.length();
        d.writeInt(len);
        d.writeChars(this.searchMode);
        d.writeInt(this.searchModeID);
        len = this.numVariablesForRule.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            d.writeInt(this.numVariablesForRule[i]);
        }
        len = this.typesAtInitialState.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            d.writeBoolean(this.typesAtInitialState[i]);
        }
        len = this.mapValueToID.keySet().size();
        d.writeInt(len);
        for (String myNext : this.mapValueToID.keySet()) {
            d.writeInt(myNext.length());
            d.writeChars(myNext);
            String myVal = this.mapValueToID.get(myNext);
            d.writeInt(myVal.length());
            d.writeChars(myVal);
        }
        len = this.ruleName.length;
        d.writeInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            String nextName = this.ruleName[i2];
            d.writeInt(nextName.length());
            d.writeChars(nextName);
        }
        return true;
    }

    public boolean readFromStream(DataInputStream d) throws IOException {
        StringBuffer buf;
        int myLength;
        int i;
        int i2;
        this.grammarAutomaton = DictionaryLetterFSA.getInstance((String)"BASIC");
        this.grammarAutomaton.readFromDataInputStream(d);
        int len = d.readInt();
        this.ruleAutomata = new DictionaryLetterFSA[len];
        for (i2 = 0; i2 < len; ++i2) {
            this.ruleAutomata[i2] = DictionaryLetterFSA.getInstance((String)"BASIC");
            this.ruleAutomata[i2].readFromDataInputStream(d);
        }
        len = d.readInt();
        this.transitionFS = new NormalizedFeatureStructure[len];
        for (i2 = 0; i2 < len; ++i2) {
            this.transitionFS[i2] = new NormalizedFeatureStructure();
            this.transitionFS[i2].readFromStream(d);
        }
        len = d.readInt();
        this.outputFS = new NormalizedFeatureStructure[len][];
        for (i2 = 0; i2 < len; ++i2) {
            int numLabels = d.readInt();
            this.outputFS[i2] = new NormalizedFeatureStructure[numLabels];
            for (int j = 0; j < numLabels; ++j) {
                this.outputFS[i2][j] = new NormalizedFeatureStructure();
                this.outputFS[i2][j].readFromStream(d);
            }
        }
        len = d.readInt();
        this.rulePriorities = new int[len];
        for (i2 = 0; i2 < len; ++i2) {
            this.rulePriorities[i2] = d.readInt();
        }
        boolean componentsExist = d.readBoolean();
        if (componentsExist) {
            this.components = new Components();
            this.components.readFromStream(d);
        } else {
            this.components = null;
        }
        len = d.readInt();
        char[] temp = new char[len];
        for (i = 0; i < len; ++i) {
            temp[i] = d.readChar();
        }
        this.outputType = new String(temp);
        this.outputTypeID = d.readInt();
        len = d.readInt();
        temp = new char[len];
        for (i = 0; i < len; ++i) {
            temp[i] = d.readChar();
        }
        this.searchMode = new String(temp);
        this.searchModeID = d.readInt();
        len = d.readInt();
        this.numVariablesForRule = new int[len];
        for (i = 0; i < len; ++i) {
            this.numVariablesForRule[i] = d.readInt();
        }
        len = d.readInt();
        this.typesAtInitialState = new boolean[len];
        for (i = 0; i < len; ++i) {
            this.typesAtInitialState[i] = d.readBoolean();
        }
        this.mapValueToID = new HashMap();
        len = d.readInt();
        for (i = 0; i < len; ++i) {
            myLength = d.readInt();
            buf = new StringBuffer();
            for (int j = 0; j < myLength; ++j) {
                buf.append(d.readChar());
            }
            StringBuffer bufVal = new StringBuffer();
            myLength = d.readInt();
            for (int j = 0; j < myLength; ++j) {
                bufVal.append(d.readChar());
            }
            this.mapValueToID.put(buf.toString(), bufVal.toString());
        }
        len = d.readInt();
        this.ruleName = new String[len];
        for (i = 0; i < len; ++i) {
            myLength = d.readInt();
            buf = new StringBuffer();
            for (int j = 0; j < myLength; ++j) {
                buf.append(d.readChar());
            }
            this.ruleName[i] = buf.toString();
        }
        return true;
    }

    public void print() {
        int i;
        System.out.println("Settings:");
        System.out.println("----------------");
        if (this.components != null) {
            System.out.println(this.components.toString());
        }
        System.out.println("Output: " + this.outputType);
        System.out.println("Search Mode: " + this.searchMode);
        System.out.println("Current Grammar:");
        System.out.println("----------------");
        System.out.println("FS on Transitions:");
        int len = this.transitionFS.length;
        for (i = 0; i < len; ++i) {
            System.out.println("[" + i + "] " + this.transitionFS[i].toStringFull());
        }
        System.out.println("----------------");
        System.out.println("Rules:");
        len = this.ruleAutomata.length;
        for (i = 0; i < len; ++i) {
            System.out.println("Rule: " + i + " : " + this.ruleName[i]);
            System.out.println("Automaton: " + i);
            System.out.println(DictionaryLetterFSATraversing.toString((DictionaryLetterFSA)this.ruleAutomata[i]));
            System.out.println("Priority: " + this.rulePriorities[i]);
            System.out.println("Output FS:");
            int numOutFS = this.outputFS[i].length;
            for (int j = 0; j < numOutFS; ++j) {
                System.out.println(this.outputFS[i][j].toStringFull());
            }
        }
        System.out.println("----------------");
        System.out.println("Filtering Automaton: ");
        System.out.println(DictionaryLetterFSATraversing.toString((DictionaryLetterFSA)this.grammarAutomaton));
    }
}

