/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import java.util.ArrayList;

public class ReefsGrammarCompilationStatus {
    private final ArrayList<String> errors;
    private final ArrayList<String> warnings = new ArrayList();

    public static ReefsGrammarCompilationStatus createInstance() {
        return new ReefsGrammarCompilationStatus();
    }

    private ReefsGrammarCompilationStatus() {
        this.errors = new ArrayList();
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public ArrayList<String> getWarnings() {
        return this.warnings;
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    public void clear() {
        this.warnings.clear();
        this.errors.clear();
    }

    public int getNumberOfErrors() {
        return this.errors.size();
    }

    public int getNumberOfWarnings() {
        return this.warnings.size();
    }

    public boolean errorsPresent() {
        return this.errors.size() > 0;
    }

    public boolean noErrorsPresent() {
        return this.errors.size() == 0;
    }

    public boolean warningsPresent() {
        return this.warnings.size() > 0;
    }

    public boolean noWarningsPresent() {
        return this.warnings.size() == 0;
    }

    public void addToCompilationsStatus(ReefsGrammarCompilationStatus newCompilationStatus) {
        this.errors.addAll(newCompilationStatus.getErrors());
        this.warnings.addAll(newCompilationStatus.getWarnings());
    }

    public void printWarnings() {
        int numWarnings = this.getNumberOfWarnings();
        System.out.println("There are " + numWarnings + " warnings:");
        for (String warning : this.warnings) {
            System.out.println(warning);
        }
    }

    public void printErrors() {
        int numErrors = this.getNumberOfErrors();
        System.out.println("There are " + numErrors + " errors:");
        for (String error : this.errors) {
            System.out.println(error);
        }
    }
}

