/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.Attribute;
import it.jrc.lt.regexpfs.ReefsGrammarCompilationStatus;
import it.jrc.lt.regexpfs.ReefsGrammarType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import piskorski.util.functions.Files;

public final class ReefsGrammarTypes {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private int numTypes;
    private String[] typeName;
    private int[] typeNumAttributes;
    private String[][] attributeNames;
    private transient HashMap<String, Integer> typeID;
    private transient HashMap<String, Integer> typeAttributeID;
    public static int UNKNOWN = -1;

    private void init() {
        this.numTypes = 0;
        this.typeName = null;
        this.typeNumAttributes = null;
        this.attributeNames = null;
        this.typeID = null;
        this.typeAttributeID = null;
    }

    public ReefsGrammarTypes() {
        this.init();
    }

    public int getNumberTypes() {
        return this.numTypes;
    }

    public String getTypeName(int i) {
        if (this.typeName == null) {
            return null;
        }
        return i >= 0 && i < this.typeName.length ? this.typeName[i] : null;
    }

    public int getNumberAttributesForType(int i) {
        if (this.typeNumAttributes == null) {
            return 0;
        }
        return i >= 0 && i < this.typeNumAttributes.length ? this.typeNumAttributes[i] : 0;
    }

    public String getAttributeName(int typeID, int attributeID) {
        if (this.attributeNames == null) {
            return null;
        }
        if (typeID < 0 && typeID >= this.typeName.length) {
            return null;
        }
        return attributeID >= 0 && attributeID < this.attributeNames[typeID].length ? this.attributeNames[typeID][attributeID] : null;
    }

    public Integer getTypeID(String type) {
        return this.typeID == null ? null : this.typeID.get(type);
    }

    public boolean isType(String type) {
        if (type == null) {
            return false;
        }
        return this.typeID.containsKey(type);
    }

    public Integer getAttributeID(String type, String attribute) {
        return this.typeAttributeID == null ? null : this.typeAttributeID.get(type + " " + attribute);
    }

    public int getTypeIDtoInt(String type) {
        if (this.typeID == null) {
            return UNKNOWN;
        }
        Integer id = this.typeID.get(type);
        return id != null ? id : UNKNOWN;
    }

    public int getAttributeIDtoInt(String type, String attribute) {
        if (this.typeAttributeID == null) {
            return UNKNOWN;
        }
        Integer id = this.typeAttributeID.get(type + " " + attribute);
        return id != null ? id : UNKNOWN;
    }

    public boolean isAttribute(String type, String attribute) {
        if (type == null) {
            return false;
        }
        if (attribute == null) {
            return false;
        }
        return this.typeAttributeID.containsKey(type + " " + attribute);
    }

    public void setNumTypes(int num) {
        this.numTypes = num;
    }

    public boolean setTypesAndAttributes(String[] types, String[][] attributes) {
        int i;
        if (types == null || attributes == null) {
            return false;
        }
        if (types.length != attributes.length) {
            return false;
        }
        this.numTypes = types.length;
        this.typeName = new String[this.numTypes];
        for (i = 0; i < this.numTypes; ++i) {
            this.typeName[i] = types[i] != null ? new String(types[i]) : null;
        }
        this.builtTypeIDMapping();
        this.typeNumAttributes = new int[this.numTypes];
        this.attributeNames = new String[this.numTypes][];
        for (i = 0; i < this.numTypes; ++i) {
            int numAttr;
            this.typeNumAttributes[i] = numAttr = attributes[i].length;
            this.attributeNames[i] = new String[numAttr];
            for (int j = 0; j < numAttr; ++j) {
                this.attributeNames[i][j] = attributes[i][j] != null ? new String(attributes[i][j]) : null;
            }
        }
        this.builtTypeAttributeIDMapping();
        return true;
    }

    public boolean setTypesAndAttributes(ArrayList<String> types, ArrayList<ArrayList<String>> attributes) {
        int i;
        if (types == null || attributes == null) {
            return false;
        }
        if (types.size() != attributes.size()) {
            return false;
        }
        this.numTypes = types.size();
        this.typeName = new String[this.numTypes];
        for (i = 0; i < this.numTypes; ++i) {
            this.typeName[i] = types.get(i) != null ? new String(types.get(i)) : null;
        }
        this.builtTypeIDMapping();
        this.typeNumAttributes = new int[this.numTypes];
        this.attributeNames = new String[this.numTypes][];
        for (i = 0; i < this.numTypes; ++i) {
            int numAttr;
            ArrayList<String> nextAttributes = attributes.get(i);
            this.typeNumAttributes[i] = numAttr = nextAttributes.size();
            this.attributeNames[i] = new String[numAttr];
            for (int j = 0; j < numAttr; ++j) {
                this.attributeNames[i][j] = nextAttributes.get(j) != null ? new String(nextAttributes.get(j)) : null;
            }
        }
        this.builtTypeAttributeIDMapping();
        return true;
    }

    private void builtTypeIDMapping() {
        int len = this.numTypes;
        this.typeID = new HashMap();
        for (int i = 0; i < len; ++i) {
            this.typeID.put(this.typeName[i], i);
        }
    }

    private void builtTypeAttributeIDMapping() {
        int len = this.numTypes;
        this.typeAttributeID = new HashMap();
        for (int i = 0; i < len; ++i) {
            int numAttr = this.attributeNames[i].length;
            for (int j = 0; j < numAttr; ++j) {
                this.typeAttributeID.put(this.typeName[i] + " " + this.attributeNames[i][j], j);
            }
        }
    }

    public boolean saveToFile(String file) {
        byte[] fill = null;
        boolean status = true;
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            DataOutputStream d = new DataOutputStream(byteOS);
            status = this.writeToStream(d);
            d.close();
            byteOS.close();
            if (status) {
                fill = byteOS.toByteArray();
            }
        }
        catch (IOException e) {
            return false;
        }
        if (status) {
            status = Files.writeByteArrayToFile((byte[])fill, (String)file);
        }
        fill = null;
        return status;
    }

    public boolean readFromFile(String file) {
        byte[] randomAccess = null;
        File FileName = new File(file);
        int size = (int)FileName.length();
        randomAccess = new byte[size];
        boolean status = Files.readByteArrayFromFile((byte[])randomAccess, (String)file);
        if (!status) {
            return false;
        }
        try {
            ByteArrayInputStream byteIS = new ByteArrayInputStream(randomAccess);
            DataInputStream d = new DataInputStream(byteIS);
            this.readFromStream(d);
            d.close();
            byteIS.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean writeToStream(DataOutputStream d) throws IOException {
        int i;
        int len = this.numTypes;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            d.writeInt(this.typeName[i].length());
            d.writeChars(this.typeName[i]);
        }
        for (i = 0; i < len; ++i) {
            d.writeInt(this.typeNumAttributes[i]);
        }
        for (i = 0; i < len; ++i) {
            int numAttr = this.typeNumAttributes[i];
            d.writeInt(numAttr);
            for (int j = 0; j < numAttr; ++j) {
                int lenName = this.attributeNames[i][j].length();
                d.writeInt(lenName);
                d.writeChars(this.attributeNames[i][j]);
            }
        }
        return true;
    }

    public boolean readFromStream(DataInputStream d) throws IOException {
        int i;
        int len;
        this.numTypes = len = d.readInt();
        this.typeName = new String[len];
        for (i = 0; i < len; ++i) {
            int typeLen = d.readInt();
            char[] temp = new char[typeLen];
            for (int k = 0; k < typeLen; ++k) {
                temp[k] = d.readChar();
            }
            this.typeName[i] = new String(temp);
        }
        this.typeNumAttributes = new int[len];
        for (i = 0; i < len; ++i) {
            this.typeNumAttributes[i] = d.readInt();
        }
        this.attributeNames = new String[len][];
        for (i = 0; i < len; ++i) {
            int numAttr = d.readInt();
            this.attributeNames[i] = new String[numAttr];
            for (int j = 0; j < numAttr; ++j) {
                int lenName = d.readInt();
                char[] temp = new char[lenName];
                for (int k = 0; k < lenName; ++k) {
                    temp[k] = d.readChar();
                }
                this.attributeNames[i][j] = new String(temp);
            }
        }
        this.builtTypeIDMapping();
        this.builtTypeAttributeIDMapping();
        return true;
    }

    public ReefsGrammarCompilationStatus initialize(ArrayList<ReefsGrammarType> types, String typeFileName) {
        ReefsGrammarCompilationStatus status = ReefsGrammarCompilationStatus.createInstance();
        ArrayList<String> newTypes = new ArrayList<String>();
        ArrayList<ArrayList<String>> newAttributes = new ArrayList<ArrayList<String>>();
        HashMap<String, Integer> validTypeAndAttributes = new HashMap<String, Integer>();
        int numTypes = types.size();
        this.setNumTypes(numTypes);
        for (int i = 0; i < numTypes; ++i) {
            ReefsGrammarType type = types.get(i);
            String typeName = type.getTypeName();
            newTypes.add(typeName);
            if (validTypeAndAttributes.containsKey(typeName)) {
                status.addError("[" + typeFileName + "] " + "Multiple declaration of type \"" + typeName + "\" at line: " + type.getBeginLine() + " and column: " + type.getBeginColumn());
            } else {
                validTypeAndAttributes.put(typeName, new Integer(i));
            }
            int numAttributes = type.getNumberAttributes();
            ArrayList<String> newA = new ArrayList<String>();
            for (int j = 0; j < numAttributes; ++j) {
                Attribute attribute = type.getAttribute(j);
                String attributeName = attribute.getName();
                newA.add(attributeName);
                String entryString = typeName + " " + attributeName;
                if (validTypeAndAttributes.containsKey(entryString)) {
                    status.addError("[" + typeFileName + "] " + "Multiple declaration of attribute \"" + attributeName + "\" in type \"" + typeName + "\" at line: " + attribute.getBeginLine() + " and column: " + attribute.getBeginColumn());
                    continue;
                }
                validTypeAndAttributes.put(entryString, new Integer(j));
            }
            newAttributes.add(newA);
        }
        if (status.noErrorsPresent()) {
            this.setTypesAndAttributes(newTypes, newAttributes);
        }
        return status;
    }

    public ReefsGrammarTypes(ReefsGrammarTypes t) {
        this.setNumTypes(t.getNumberTypes());
        this.setTypesAndAttributes(t.typeName, t.attributeNames);
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Types and Attributes");
        out.append(LINE_SEPARATOR);
        out.append("--------------------");
        out.append(LINE_SEPARATOR);
        int len = this.numTypes;
        for (int i = 0; i < len; ++i) {
            out.append(this.typeName[i]);
            out.append(" [");
            int numAttr = this.typeNumAttributes[i];
            for (int j = 0; j < numAttr; ++j) {
                out.append(this.attributeNames[i][j]);
                if (j >= numAttr - 1) continue;
                out.append(",");
            }
            out.append("]");
            out.append(LINE_SEPARATOR);
        }
        return out.toString();
    }
}

