/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.RuleAutomatonInstance;

public class RuleAutomatonInstanceArrayList {
    private transient RuleAutomatonInstance[] elementData;
    private int size;
    private int minCapacity;

    public RuleAutomatonInstanceArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new RuleAutomatonInstance[initialCapacity];
    }

    public RuleAutomatonInstanceArrayList() {
        this(10);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            RuleAutomatonInstance[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new RuleAutomatonInstance[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public RuleAutomatonInstance get(int index) {
        return this.elementData[index];
    }

    public void set(int index, RuleAutomatonInstance value) {
        this.elementData[index] = new RuleAutomatonInstance(value);
    }

    public boolean add(RuleAutomatonInstance o) {
        if (this.size + 1 > this.elementData.length) {
            this.minCapacity = this.size + 1;
            int oldCapacity = this.elementData.length;
            RuleAutomatonInstance[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < this.minCapacity) {
                newCapacity = this.minCapacity;
            }
            this.elementData = new RuleAutomatonInstance[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = o;
        return true;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public RuleAutomatonInstance removeLast() {
        if (this.size > 0) {
            --this.size;
        }
        return this.elementData[this.size];
    }

    public RuleAutomatonInstance remove(int index) {
        if (index == this.size - 1) {
            return this.removeLast();
        }
        RuleAutomatonInstance temp = this.elementData[index];
        this.elementData[index] = this.elementData[--this.size];
        return temp;
    }

    public void clear() {
        this.size = 0;
    }
}

