/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.VariableBinding;

public final class VariableBindingArrayList {
    private transient VariableBinding[] elementData;
    private int size;
    private int minCapacity;

    public VariableBindingArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new VariableBinding[initialCapacity];
    }

    public VariableBindingArrayList() {
        this(10);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            VariableBinding[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new VariableBinding[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public VariableBinding get(int index) {
        return this.elementData[index];
    }

    public void set(int index, VariableBinding value) {
        this.elementData[index] = new VariableBinding(value);
    }

    public boolean add(VariableBinding o) {
        if (this.size + 1 > this.elementData.length) {
            this.minCapacity = this.size + 1;
            int oldCapacity = this.elementData.length;
            VariableBinding[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < this.minCapacity) {
                newCapacity = this.minCapacity;
            }
            this.elementData = new VariableBinding[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = o;
        return true;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public VariableBinding removeLast() {
        if (this.size > 0) {
            --this.size;
        }
        return this.elementData[this.size];
    }

    public VariableBinding remove(int index) {
        if (index == this.size - 1) {
            return this.removeLast();
        }
        VariableBinding temp = this.elementData[index];
        this.elementData[index] = this.elementData[--this.size];
        return temp;
    }

    public void clear() {
        this.size = 0;
    }
}

