/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.VariableBinding;
import it.jrc.lt.regexpfs.VariableBindingArrayList;

public final class VariableBindings {
    private VariableBinding[] bindings;

    public boolean equals(Object o) {
        return this.IsEqualTo((VariableBindings)o);
    }

    public int getNumBindings() {
        return this.bindings != null ? this.bindings.length : 0;
    }

    public void setBindings(VariableBinding[] bindings) {
        if (bindings == null) {
            return;
        }
        int len = bindings.length;
        this.bindings = new VariableBinding[len];
        for (int i = 0; i < len; ++i) {
            this.bindings[i] = new VariableBinding(bindings[i]);
        }
    }

    public void setBindings(VariableBindingArrayList bindingsList) {
        if (bindingsList == null) {
            return;
        }
        int len = bindingsList.size();
        this.bindings = new VariableBinding[len];
        for (int i = 0; i < len; ++i) {
            this.bindings[i] = new VariableBinding(bindingsList.get(i));
        }
    }

    public VariableBinding getBinding(int index) {
        if (this.bindings == null) {
            return null;
        }
        return index < 0 || index >= this.bindings.length ? null : this.bindings[index];
    }

    public byte getVariableIndex(int index) {
        if (this.bindings == null) {
            return -1;
        }
        return index < 0 || index >= this.bindings.length ? (byte)-1 : this.bindings[index].getVariableID();
    }

    public String getValue(int index) {
        if (this.bindings == null) {
            return null;
        }
        return index < 0 || index >= this.bindings.length ? null : this.bindings[index].getValue();
    }

    public VariableBindings() {
        this.bindings = null;
    }

    public VariableBindings(VariableBindings b) {
        int len = b.bindings.length;
        this.bindings = new VariableBinding[len];
        for (int i = 0; i < len; ++i) {
            this.bindings[i] = new VariableBinding(b.getBinding(i));
        }
    }

    public boolean IsEqualTo(VariableBindings b) {
        int equal;
        int n = this.bindings == null ? (b.bindings == null ? 0 : 1) : (equal = b.bindings == null ? 1 : 2);
        if (equal == 0) {
            return true;
        }
        if (equal == 1) {
            return false;
        }
        int len0 = this.bindings.length;
        int len1 = b.bindings.length;
        if (len0 != len1) {
            return false;
        }
        for (int i = 0; i < len0; ++i) {
            VariableBinding currentBinding = this.bindings[i];
            boolean matchFound = false;
            for (int j = 0; j < len0; ++j) {
                VariableBinding currentBinding2 = b.bindings[j];
                if (!currentBinding.isEqualTo(currentBinding2)) continue;
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        if (this.bindings == null) {
            return null;
        }
        output.append("Variable Bindings: ");
        int len = this.bindings.length;
        for (int i = 0; i < len; ++i) {
            output.append(this.bindings[i].getVariableID());
            output.append(":");
            output.append(this.bindings[i].getValue());
        }
        return output.toString();
    }
}

