/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.booleanOperator;

import it.jrc.lt.regexpfs.booleanOperator.BooleanOperator;
import it.jrc.lt.regexpfs.funop.NoSuchOperatorException;
import java.util.HashMap;

public class BooleanOperatorCall {
    private static BooleanOperatorCall instance = null;
    private HashMap<String, BooleanOperator> operators;

    private BooleanOperatorCall() {
        this.setOperators(new HashMap<String, BooleanOperator>());
    }

    public HashMap<String, BooleanOperator> getOperators() {
        return this.operators;
    }

    private void setOperators(HashMap<String, BooleanOperator> aHashMap) {
        this.operators = aHashMap;
    }

    public static BooleanOperatorCall getInstance() {
        if (null == instance) {
            instance = new BooleanOperatorCall();
        }
        return instance;
    }

    private static boolean isRegistered(String operatorName) {
        return BooleanOperatorCall.getInstance().operators.containsKey(operatorName);
    }

    private boolean registerOperator(BooleanOperator m) {
        if (this.operators.containsKey(m.getName())) {
            return false;
        }
        this.operators.put(m.getName(), m);
        return true;
    }

    private BooleanOperator getOperatorViaName(String operatorName) throws NoSuchOperatorException {
        BooleanOperator fO = this.operators.get(operatorName);
        if (null == fO) {
            throw new NoSuchOperatorException("Boolean operator " + operatorName + " not available");
        }
        return fO;
    }

    public boolean callOperator(String operatorName, String[] arguments) throws Exception {
        if (operatorName == null) {
            return false;
        }
        BooleanOperator fOp = null;
        if (!BooleanOperatorCall.isRegistered(operatorName)) {
            fOp = BooleanOperator.getInstance(operatorName);
            if (fOp != null) {
                this.registerOperator(fOp);
            }
        } else {
            fOp = this.getOperatorViaName(operatorName);
        }
        if (fOp == null) {
            throw new NoSuchOperatorException("Boolean operator " + operatorName + " not available");
        }
        return fOp.computeValue(arguments);
    }
}

