/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.funop;

import it.jrc.lt.regexpfs.funop.FunctionalOperator;
import it.jrc.lt.regexpfs.funop.NoSuchOperatorException;
import java.util.HashMap;

public class FunctionalOperatorCall {
    private static FunctionalOperatorCall instance = null;
    private HashMap<String, FunctionalOperator> operators;

    private FunctionalOperatorCall() {
        this.setOperators(new HashMap<String, FunctionalOperator>());
    }

    public HashMap<String, FunctionalOperator> getOperators() {
        return this.operators;
    }

    private void setOperators(HashMap<String, FunctionalOperator> aHashMap) {
        this.operators = aHashMap;
    }

    public static FunctionalOperatorCall getInstance() {
        if (null == instance) {
            instance = new FunctionalOperatorCall();
        }
        return instance;
    }

    private static boolean isRegistered(String operatorName) {
        return FunctionalOperatorCall.getInstance().operators.containsKey(operatorName);
    }

    private boolean registerOperator(FunctionalOperator m) {
        if (this.operators.containsKey(m.getName())) {
            return false;
        }
        this.operators.put(m.getName(), m);
        return true;
    }

    private FunctionalOperator getOperatorViaName(String operatorName) throws NoSuchOperatorException {
        FunctionalOperator fO = this.operators.get(operatorName);
        if (null == fO) {
            throw new NoSuchOperatorException("Operator " + operatorName + " not available");
        }
        return fO;
    }

    public String callOperator(String operatorName, String[] arguments) throws Exception {
        if (operatorName == null) {
            return null;
        }
        FunctionalOperator fOp = null;
        if (!FunctionalOperatorCall.isRegistered(operatorName)) {
            fOp = FunctionalOperator.getInstance(operatorName);
            if (fOp != null) {
                this.registerOperator(fOp);
            }
        } else {
            fOp = this.getOperatorViaName(operatorName);
        }
        if (fOp == null) {
            throw new NoSuchOperatorException("Operator " + operatorName + " not available");
        }
        return fOp.computeValue(arguments);
    }
}

