/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.gazetteer.AbstractDisjunctionOfGazetteerItems;
import it.jrc.lt.core.component.gazetteer.AbstractGazetteer;
import it.jrc.lt.core.component.gazetteer.AbstractGazetteerItem;
import it.jrc.lt.core.component.gazetteer.Attributes;
import it.jrc.lt.core.component.gazetteer.Type;
import it.jrc.lt.core.component.gazetteer.Types;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.module.ProcessingException;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class CorleoneExtendedGazetteer
extends Module {
    private static short GAZETTEER = 0;
    private static String GAZETTEER_TYPE_AS_STRING = "gazetteer";
    private static short UNDEFINED_TYPE = (short)-1;
    private AbstractGazetteer gazetteer = AbstractGazetteer.createInstance((String)"basicGazetteer");
    private String TokenizerName = null;
    private ArrayList<String> gazetteerTypesList = null;
    private HashMap<String, ArrayList<String>> gazetteerAttributeLists = null;
    private HashMap<String, Integer>[] attributeToNumber = null;
    private HashMap<String, Short> typeToNumber = null;
    private boolean usingOnlyGazetteerType;
    private String attributeEncodingType = null;

    private void createTypesAttributes(Types types) {
        if (types == null) {
            Type[] typeArray = new Type[]{Type.createInstance((String)GAZETTEER_TYPE_AS_STRING, (Attributes)this.gazetteer.getAttributes())};
            types = Types.createInstance((Type[])typeArray, null);
        }
        short s = types.getNumberTypes();
        this.attributeEncodingType = types.getAttributeEncodingType();
        this.gazetteerTypesList = new ArrayList();
        this.gazetteerAttributeLists = new HashMap();
        this.attributeToNumber = new HashMap[s];
        this.typeToNumber = new HashMap();
        for (short currentTypeID = 0; currentTypeID < s; currentTypeID = (short)(currentTypeID + 1)) {
            Type currentType = types.getType((int)currentTypeID);
            String currentTypeName = currentType.getName();
            this.gazetteerTypesList.add(currentTypeName);
            this.typeToNumber.put(currentType.getName(), currentTypeID);
            this.attributeToNumber[currentTypeID] = new HashMap();
            String[] attributes = currentType.getAttributes();
            int numAttributes = attributes.length;
            ArrayList<String> attributeNames = new ArrayList<String>();
            for (int k = 0; k < numAttributes; ++k) {
                attributeNames.add(attributes[k]);
                this.attributeToNumber[currentTypeID].put(attributes[k], k);
            }
            this.gazetteerAttributeLists.put(currentTypeName, attributeNames);
        }
    }

    @Override
    protected InputFSArrayList convertResult(Object o, char[] inputText) {
        if (o == null) {
            return null;
        }
        ArrayList gazetteerObjects = (ArrayList)o;
        int numGazetteerObjects = gazetteerObjects.size();
        InputFSArrayList results = new InputFSArrayList(gazetteerObjects.size());
        for (int i = 0; i < numGazetteerObjects; ++i) {
            AbstractDisjunctionOfGazetteerItems singleResult = (AbstractDisjunctionOfGazetteerItems)gazetteerObjects.get(i);
            int singleResultSize = singleResult.getNumberOfItems();
            for (int j = 0; j < singleResultSize; ++j) {
                int k;
                int numAttr;
                AbstractGazetteerItem res = singleResult.getItem(j);
                InputFeatureStructure fs = new InputFeatureStructure();
                fs.setPosition(res.getStart(), res.getEnd());
                short currentType = UNDEFINED_TYPE;
                if (!this.usingOnlyGazetteerType) {
                    numAttr = res.getSize();
                    for (k = 0; k < numAttr; ++k) {
                        String attrName = res.getAttributeName(k);
                        if (attrName.compareTo(this.attributeEncodingType) != 0) continue;
                        String val = res.getValue(k);
                        currentType = this.typeToNumber.containsKey(val) ? this.typeToNumber.get(val) : UNDEFINED_TYPE;
                        break;
                    }
                } else {
                    currentType = GAZETTEER;
                }
                if (currentType == UNDEFINED_TYPE) {
                    Module.loggerWarning("Some feature structure for position : <" + res.getStart() + "," + res.getEnd() + "> returned by: " + this.getComponentName() + " is incompatible with the grammar type hierarchy.");
                    continue;
                }
                fs.setType(currentType);
                numAttr = res.getSize();
                fs.initializeAttributes((byte)this.attributes[currentType].length);
                for (k = 0; k < numAttr; ++k) {
                    Integer attributeIndex = this.attributeToNumber[currentType].get(res.getAttributeName(k));
                    if (attributeIndex == null) continue;
                    fs.setAttribute(attributeIndex, res.getValue(k));
                }
                results.add(fs);
            }
        }
        return results;
    }

    @Override
    protected ArrayList<String> getAttributeNames(String type) {
        return this.gazetteerAttributeLists.get(type);
    }

    @Override
    protected ArrayList<String> getTypes() {
        return this.gazetteerTypesList;
    }

    @Override
    protected boolean initialize() {
        String TokenizerName;
        Properties myProperties = this.getModulesConfiguration();
        this.TokenizerName = TokenizerName = myProperties.getProperty("TokenizerName");
        if (this.TokenizerName == null) {
            Module.loggerMessage("Missing property: \" TokenizerName + \" in configuration file of the module: " + this.getComponentName());
            return false;
        }
        String GazetteerFile = myProperties.getProperty("ResourceFile");
        if (GazetteerFile == null) {
            Module.loggerMessage("Missing property: \"" + GazetteerFile + "\" in configuration file of the module: " + this.getComponentName());
            return false;
        }
        boolean status = this.gazetteer.readFromFile(GazetteerFile);
        if (!status) {
            Module.loggerMessage("Could not initialize the module: " + this.getComponentName() + " via reading the file: " + GazetteerFile);
            return false;
        }
        Configuration myConfig = Configuration.initializeFrom((Properties)myProperties);
        if (myConfig.isNull()) {
            Module.loggerMessage("Could not initialize the configuration for the module: " + this.getComponentName());
            return false;
        }
        this.gazetteer.returnCharacterPositions();
        String TypesFile = myProperties.getProperty("TypesFile");
        this.usingOnlyGazetteerType = TypesFile == null;
        Types types = null;
        if (TypesFile == null) {
            Module.loggerMessage("Property \" TypesFile \"  not defined in configuration file of the module: " + this.getComponentName());
            Module.loggerMessage(this.getComponentName() + " will return structures of one type only, namely: " + GAZETTEER_TYPE_AS_STRING);
        } else {
            Module.loggerMessage(this.getComponentName() + " will be used output types as specified in the file: " + TypesFile);
            StringBuffer errorLog = new StringBuffer();
            types = Types.createFromFile((String)TypesFile, (String)"UTF-8", (StringBuffer)errorLog);
            if (types == null) {
                Module.loggerMessage(errorLog.toString());
                return false;
            }
            Attributes gazAttributes = this.gazetteer.getAttributes();
            if (!gazAttributes.containsAttribute(types.getAttributeEncodingType())) {
                Module.loggerMessage("Attribute for encoding type: " + types.getAttributeEncodingType() + " is not present in the gazetteer");
                return false;
            }
        }
        status = this.gazetteer.applySettings(myConfig);
        if (status) {
            this.createTypesAttributes(types);
        }
        return status;
    }

    @Override
    protected Object performTask(char[] inputText, ResultPool resultPool) throws ProcessingException {
        ArrayList tokens = null;
        try {
            tokens = (ArrayList)resultPool.getCurrentNativeResultsForModule(this.TokenizerName);
        }
        catch (Exception e) {
            Module.loggerMessage(e.getMessage());
            throw new ProcessingException("Processing exception while running tokenizer as a submodule by: " + this.getComponentName());
        }
        ArrayList resList = null;
        if (tokens != null) {
            resList = this.gazetteer.findMatch(tokens, inputText);
        }
        return resList;
    }
}

