/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.gazetteer.AbstractDisjunctionOfGazetteerItems;
import it.jrc.lt.core.component.gazetteer.AbstractGazetteer;
import it.jrc.lt.core.component.gazetteer.AbstractGazetteerItem;
import it.jrc.lt.core.component.gazetteer.Attribute;
import it.jrc.lt.core.component.gazetteer.Attributes;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.module.ProcessingException;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class CorleoneGazetteer
extends Module {
    private static short GAZETTEER = 0;
    private AbstractGazetteer gazetteer = AbstractGazetteer.createInstance((String)"basicGazetteer");
    private String TokenizerName = null;
    private String searchStrategy;
    private static String[] gazetteerTypes = new String[]{"gazetteer"};
    private ArrayList<String> gazetteerTypesList;
    private HashMap<String, ArrayList<String>> gazetteerAttributeLists;
    private HashMap<String, Integer> attributeToNumber;

    private void createTypesAttributes() {
        this.gazetteerTypesList = new ArrayList();
        this.gazetteerTypesList.add(gazetteerTypes[0]);
        this.gazetteerAttributeLists = new HashMap();
        ArrayList<String> attributeNames = new ArrayList<String>();
        Attributes attributes = this.gazetteer.getAttributes();
        int numAttributes = attributes.getNumberAttributes();
        this.attributeToNumber = new HashMap();
        for (int i = 0; i < numAttributes; ++i) {
            Attribute at = attributes.getAttribute(i);
            attributeNames.add(at.getName());
            this.attributeToNumber.put(at.getName(), i);
        }
        this.gazetteerAttributeLists.put(gazetteerTypes[0], attributeNames);
    }

    @Override
    protected InputFSArrayList convertResult(Object o, char[] inputText) {
        if (o == null) {
            return null;
        }
        ArrayList gazetteerObjects = (ArrayList)o;
        int numGazetteerObjects = gazetteerObjects.size();
        InputFSArrayList results = new InputFSArrayList(gazetteerObjects.size());
        for (int i = 0; i < numGazetteerObjects; ++i) {
            AbstractDisjunctionOfGazetteerItems singleResult = (AbstractDisjunctionOfGazetteerItems)gazetteerObjects.get(i);
            int singleResultSize = singleResult.getNumberOfItems();
            for (int j = 0; j < singleResultSize; ++j) {
                AbstractGazetteerItem res = singleResult.getItem(j);
                InputFeatureStructure fs = new InputFeatureStructure();
                fs.setType(GAZETTEER);
                fs.setPosition(res.getStart(), res.getEnd());
                int numAttr = res.getSize();
                fs.initializeAttributes((byte)this.attributes[GAZETTEER].length);
                for (int k = 0; k < numAttr; ++k) {
                    String val = res.getValue(k);
                    fs.setAttribute(this.attributeToNumber.get(res.getAttributeName(k)), val);
                }
                results.add(fs);
            }
        }
        return results;
    }

    @Override
    protected ArrayList<String> getAttributeNames(String type) {
        return this.gazetteerAttributeLists.get(type);
    }

    @Override
    protected ArrayList<String> getTypes() {
        return this.gazetteerTypesList;
    }

    @Override
    protected boolean initialize() {
        String TokenizerName;
        Properties myProperties = this.getModulesConfiguration();
        this.TokenizerName = TokenizerName = myProperties.getProperty("TokenizerName");
        if (this.TokenizerName == null) {
            Module.loggerMessage("Missing property: \" TokenizerName + \" in configuration file of the module: " + this.getComponentName());
            return false;
        }
        String GazetteerFile = myProperties.getProperty("ResourceFile");
        if (GazetteerFile == null) {
            Module.loggerMessage("Missing property: \"" + GazetteerFile + "\" in configuration file of the module: " + this.getComponentName());
            return false;
        }
        boolean status = this.gazetteer.readFromFile(GazetteerFile);
        if (!status) {
            Module.loggerMessage("Could not initialize the module: " + this.getComponentName() + " via reading the file: " + GazetteerFile);
            return false;
        }
        Configuration myConfig = Configuration.initializeFrom((Properties)myProperties);
        if (myConfig.isNull()) {
            Module.loggerMessage("Could not initialize the configuration for the module: " + this.getComponentName());
            return false;
        }
        this.gazetteer.returnCharacterPositions();
        status = this.gazetteer.applySettings(myConfig);
        if (status) {
            this.createTypesAttributes();
        }
        return status;
    }

    @Override
    protected Object performTask(char[] inputText, ResultPool resultPool) throws ProcessingException {
        ArrayList tokens = null;
        try {
            tokens = (ArrayList)resultPool.getCurrentNativeResultsForModule(this.TokenizerName);
        }
        catch (Exception e) {
            Module.loggerMessage(e.getMessage());
            throw new ProcessingException("Processing exception while running tokenizer as a submodule by: " + this.getComponentName());
        }
        ArrayList resList = null;
        if (tokens != null) {
            resList = this.gazetteer.findMatch(tokens, inputText);
        }
        return resList;
    }
}

