/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.morphology.AbstractDisjunctionOfMorphologyItems;
import it.jrc.lt.core.component.morphology.AbstractMorphology;
import it.jrc.lt.core.component.morphology.AbstractMorphologyItem;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.module.ProcessingException;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;

public class CorleoneMorphology
extends Module {
    private AbstractMorphology morphology = AbstractMorphology.createInstance((String)"multextMorphology");
    private String TokenizerName = null;
    private static String[] morphologyTypes = new String[]{"noun", "verb", "adjective", "pronoun", "determiner", "article", "adverb", "adposition", "conjunction", "numeral", "interjection", "residual", "abbreviation", "particle", "unknown"};
    private static char[] morphologyTypesAbbrev = new char[]{'N', 'V', 'A', 'P', 'D', 'T', 'R', 'S', 'C', 'M', 'I', 'X', 'Y', 'Q', 'U'};
    private static short[] abbrevToID;
    private static int ATTR_BASE;
    private static int ATTR_SURFACE;
    private static String[][] morphologyAttrributes;
    private static int[][] morphologyAttrributesID;
    private static ArrayList<String> morphologyTypesList;
    private static HashMap<String, ArrayList<String>> morphologyAttributeLists;

    @Override
    protected InputFSArrayList convertResult(Object o, char[] inputText) {
        if (o == null) {
            return null;
        }
        ArrayList morphItems = (ArrayList)o;
        int numMorphItems = morphItems.size();
        InputFSArrayList results = new InputFSArrayList(morphItems.size() * 2);
        char[] val = new char[1];
        for (int i = 0; i < numMorphItems; ++i) {
            AbstractDisjunctionOfMorphologyItems interpretations = (AbstractDisjunctionOfMorphologyItems)morphItems.get(i);
            int singleResultSize = interpretations.getNumberOfItems();
            for (int j = 0; j < singleResultSize; ++j) {
                AbstractMorphologyItem singleResult = interpretations.getItem(j);
                InputFeatureStructure fs = new InputFeatureStructure();
                int start = singleResult.getStart();
                int end = singleResult.getEnd();
                fs.setPosition(start, end);
                short pos = abbrevToID[singleResult.getPos()];
                if (pos < 0) {
                    System.out.println("DD " + new String(inputText, start, end - start + 1));
                }
                fs.setType(pos);
                int numAttr = morphologyAttrributes[pos].length;
                fs.initializeAttributes((byte)numAttr);
                fs.setAttribute(ATTR_SURFACE, new String(inputText, start, end - start + 1));
                char[] lemma = singleResult.getLemma();
                if (lemma != null) {
                    fs.setAttribute(ATTR_BASE, new String(lemma));
                }
                int numOtherAttributes = numAttr - 2;
                for (int k = 0; k < numOtherAttributes; ++k) {
                    val[0] = singleResult.getTag(morphologyAttrributesID[pos][k + 2]);
                    fs.setAttribute(2 + k, new String(val));
                }
                results.add(fs);
            }
        }
        return results;
    }

    @Override
    protected ArrayList<String> getAttributeNames(String type) {
        return morphologyAttributeLists.get(type);
    }

    @Override
    protected ArrayList<String> getTypes() {
        return morphologyTypesList;
    }

    @Override
    protected boolean initialize() {
        String TokenizerName;
        Properties myProperties = this.getModulesConfiguration();
        this.TokenizerName = TokenizerName = myProperties.getProperty("TokenizerName");
        if (this.TokenizerName == null) {
            Module.loggerMessage("Missing property: \" TokenizerName + \" in configuration file of the module: " + this.getComponentName());
            return false;
        }
        String MorphologyFile = myProperties.getProperty("ResourceFile");
        if (MorphologyFile == null) {
            Module.loggerMessage("Missing property: \"" + MorphologyFile + "\" in configuration file of the module: " + this.getComponentName());
            return false;
        }
        boolean status = this.morphology.readFromFile(MorphologyFile);
        if (!status) {
            Module.loggerMessage("Could not initialize the module: " + this.getComponentName() + " via reading the file: " + MorphologyFile);
            return false;
        }
        Configuration myConfig = Configuration.initializeFrom((Properties)myProperties);
        if (myConfig.isNull()) {
            Module.loggerMessage("Could not initialize the configuration for the module: " + this.getComponentName());
            return false;
        }
        return this.morphology.applySettings(myConfig);
    }

    @Override
    protected Object performTask(char[] inputText, ResultPool resultPool) throws ProcessingException {
        ArrayList tokens = null;
        try {
            tokens = (ArrayList)resultPool.getCurrentNativeResultsForModule(this.TokenizerName);
        }
        catch (Exception e) {
            Module.loggerMessage(e.getMessage());
            throw new ProcessingException("Processing exception while accessing results of the tokenizer by the component: " + this.getComponentName());
        }
        ArrayList result = null;
        if (tokens == null) {
            Module.loggerMessage("Morphology named: " + this.getComponentName() + " requires tokenizer results returned by: " + this.TokenizerName + ". They are not available.");
            throw new ProcessingException("Processing exception while running tokenizer as a submodule by: " + this.getComponentName());
        }
        result = this.morphology.findMatch(tokens, inputText);
        return result;
    }

    static {
        ATTR_BASE = 0;
        ATTR_SURFACE = 1;
        morphologyAttrributes = new String[][]{{"BASE", "SURFACE", "TYPE", "GENDER", "NUMBER", "SEM_1", "SEM_2", "CASE"}, {"BASE", "SURFACE", "TYPE", "VFORM", "TENSE", "PERSON", "NUMBER", "GENDER", "SEM_1", "SEM_2", "ASPECT"}, {"BASE", "SURFACE", "TYPE", "DEGREE", "GENDER", "NUMBER", "CASE"}, {"BASE", "SURFACE", "TYPE", "PERSON", "GENDER", "NUMBER", "CASE"}, {"BASE", "SURFACE", "TYPE", "PERSON", "NUMBER", "GENDER", "CASE"}, {"BASE", "SURFACE", "TYPE", "GENDER", "NUMBER", "CASE"}, {"BASE", "SURFACE", "TYPE", "DEGREE"}, {"BASE", "SURFACE", "TYPE", "CASE", "GENDER", "NUMBER"}, {"BASE", "SURFACE", "TYPE", "COORD_TYPE"}, {"BASE", "SURFACE", "TYPE", "GENDER", "NUMBER", "CASE"}, {"BASE", "SURFACE", "TYPE"}, {"BASE", "SURFACE", "TYPE"}, {"BASE", "SURFACE", "SYNTACTIC_TYPE"}, {"BASE", "SURFACE", "TYPE"}, {"BASE", "SURFACE"}};
        morphologyAttrributesID = new int[][]{{-1, -1, 0, 1, 2, 10, 11, 3}, {-1, -1, 0, 1, 2, 3, 4, 5, 15, 16, 13}, {-1, -1, 0, 1, 2, 3, 4}, {-1, -1, 0, 1, 2, 3, 4}, {-1, -1, 0, 1, 3, 2, 4}, {-1, -1, 0, 1, 2, 3}, {-1, -1, 0, 1}, {-1, -1, 0, 2, 4, 5}, {-1, -1, 0, 2}, {-1, -1, 0, 1, 2, 3}, {-1, -1, 0}, {-1, -1, 0}, {-1, -1, 0}, {-1, -1, 0}, {-1, -1}};
        morphologyTypesList = new ArrayList();
        morphologyAttributeLists = new HashMap();
        int numTypes = morphologyTypes.length;
        for (int i = 0; i < numTypes; ++i) {
            morphologyTypesList.add(morphologyTypes[i]);
            ArrayList<String> attributesForType = new ArrayList<String>();
            int numAttributes = morphologyAttrributes[i].length;
            for (int j = 0; j < numAttributes; ++j) {
                attributesForType.add(morphologyAttrributes[i][j]);
            }
            morphologyAttributeLists.put(morphologyTypes[i], attributesForType);
        }
        abbrevToID = new short[256];
        Arrays.fill(abbrevToID, (short)-1);
        int numPOS = morphologyTypesAbbrev.length;
        for (int i = 0; i < numPOS; ++i) {
            CorleoneMorphology.abbrevToID[CorleoneMorphology.morphologyTypesAbbrev[i]] = (short)i;
        }
    }
}

