/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.ReefsGrammarTypes;
import it.jrc.lt.regexpfs.module.ModulePool;
import it.jrc.lt.regexpfs.module.ProcessingException;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class Module {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String MODULE_NAME_PROPERTY = "MODULE.NAME";
    public static final String MODULE_TYPE_PROPERTY = "MODULE.TYPE";
    public static final String MODULE_ROOT_DIRECTORY = "$ROOT$";
    private String componentName = null;
    private String componentType = null;
    private String[] types = null;
    protected String[][] attributes = null;
    private Properties moduleConfiguration;
    protected static Logger logger = Logger.getLogger(Module.class);

    protected Properties getModulesConfiguration() {
        return this.moduleConfiguration;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentType() {
        return this.componentType;
    }

    protected void setComponentName(String name) {
        this.componentName = name;
    }

    protected void setComponentType(String type) {
        this.componentType = type;
    }

    public void setTypes(ArrayList<String> types) {
        if (types != null) {
            int len = types.size();
            this.types = new String[len];
            for (int i = 0; i < len; ++i) {
                this.types[i] = types.get(i);
            }
        }
    }

    public void setAttributes(ArrayList<ArrayList<String>> attributes) {
        if (attributes != null) {
            int len = attributes.size();
            this.attributes = new String[len][];
            for (int i = 0; i < len; ++i) {
                ArrayList<String> nextA = attributes.get(i);
                int numAttributes = nextA.size();
                this.attributes[i] = new String[numAttributes];
                for (int j = 0; j < len; ++j) {
                    this.attributes[i][j] = nextA.get(j);
                }
            }
        }
    }

    public int getNumberTypes() {
        return this.types != null ? this.types.length : 0;
    }

    public int numAttributesForType(int i) {
        if (this.attributes == null) {
            return 0;
        }
        return i >= 0 && i < this.attributes.length ? (this.attributes[i] != null ? this.attributes[i].length : 0) : 0;
    }

    public String getTypeName(int i) {
        if (this.types == null) {
            return null;
        }
        return i >= 0 && i < this.types.length ? this.types[i] : null;
    }

    public String getAttributeName(int typeID, int attributeID) {
        if (this.attributes == null) {
            return null;
        }
        if (typeID < 0 || typeID >= this.attributes.length) {
            return null;
        }
        return attributeID >= 0 && attributeID < this.attributes[typeID].length ? this.attributes[typeID][attributeID] : null;
    }

    protected static void loggerMessageAndExit(String message) {
        logger.error((Object)message);
        System.exit(0);
    }

    protected static void loggerMessage(String message) {
        logger.info((Object)message);
    }

    protected static void loggerWarning(String message) {
        logger.warn((Object)message);
    }

    private static String PropertyError(String PropertyName) {
        return "Missing Property: " + PropertyName;
    }

    private static Properties expandProperties(Properties props, String replacement) {
        Iterator<Object> it = props.keySet().iterator();
        Properties newProps = new Properties();
        while (it.hasNext()) {
            String prop = (String)it.next();
            String value = props.getProperty(prop);
            String newValue = value.indexOf(MODULE_ROOT_DIRECTORY) != -1 ? value.replace(MODULE_ROOT_DIRECTORY, replacement) : value;
            newProps.setProperty(prop, newValue);
        }
        return newProps;
    }

    public static Module initialize(String ModuleConfigurationDirectory, String fileName, ModulePool myPool) {
        Properties configPropsInit = new Properties();
        Module m = null;
        try {
            FileInputStream FIS = new FileInputStream(fileName);
            configPropsInit.load(FIS);
            FIS.close();
        }
        catch (IOException e) {
            logger.error((Object)("IO ERROR while reading property file " + fileName));
            return null;
        }
        Properties configProps = Module.expandProperties(configPropsInit, ModuleConfigurationDirectory);
        String componentName = configProps.getProperty(MODULE_NAME_PROPERTY);
        if (componentName == null) {
            logger.error((Object)Module.PropertyError(MODULE_NAME_PROPERTY));
            return null;
        }
        String componentType = configProps.getProperty(MODULE_TYPE_PROPERTY);
        if (componentType == null) {
            logger.error((Object)Module.PropertyError(MODULE_TYPE_PROPERTY));
            return null;
        }
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass("it.jrc.lt.regexpfs.module." + componentType);
            m = (Module)c.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)("Can not create an instance of the class: " + componentType));
            return null;
        }
        boolean error = false;
        if (m != null) {
            m.moduleConfiguration = configProps;
            m.setComponentName(componentName);
            boolean bl = error = !m.initialize();
            if (!error) {
                m.setComponentName(componentName);
                m.setComponentType(componentType);
                m.createTypeAttributeArrays();
                if (!myPool.registerModule(m)) {
                    logger.error((Object)("Module named: " + componentName + " already registered."));
                    return null;
                }
                logger.info((Object)("Module named: " + componentName + " has been registered successfully."));
            }
        }
        return error ? null : m;
    }

    protected abstract boolean initialize();

    protected abstract ArrayList<String> getTypes();

    protected abstract ArrayList<String> getAttributeNames(String var1);

    private void createTypeAttributeArrays() {
        int i;
        ArrayList<String> types = this.getTypes();
        int len = types.size();
        this.types = new String[len];
        for (i = 0; i < len; ++i) {
            this.types[i] = new String(types.get(i));
        }
        this.attributes = new String[len][];
        for (i = 0; i < len; ++i) {
            ArrayList<String> currentAttributes = this.getAttributeNames(this.types[i]);
            int numAttr = currentAttributes.size();
            this.attributes[i] = new String[numAttr];
            for (int j = 0; j < numAttr; ++j) {
                this.attributes[i][j] = new String(currentAttributes.get(j));
            }
        }
    }

    public Object process(char[] inputText, ResultPool myResourcePool) {
        Object currentResult = null;
        try {
            currentResult = this.performTask(inputText, myResourcePool);
        }
        catch (ProcessingException e) {
            logger.error((Object)("Error while runing the module: " + this.componentName));
            return null;
        }
        return currentResult;
    }

    public InputFSArrayList convert(Object currentResult, char[] inputText) {
        InputFSArrayList result = this.convertResult(currentResult, inputText);
        if (!this.checkOutput(result)) {
            logger.error((Object)("Invalid output structures returned by the module: " + this.componentName));
            return null;
        }
        if (result == null) {
            result = new InputFSArrayList();
        }
        return result;
    }

    private boolean checkOutput(InputFSArrayList fsList) {
        if (fsList == null) {
            return true;
        }
        int len = fsList.size();
        int maxType = this.types.length;
        for (int i = 0; i < len; ++i) {
            InputFeatureStructure fs = fsList.get(i);
            short typeID = fs.getType();
            if (typeID < 0 || typeID >= maxType) {
                return false;
            }
            byte numAttr = fs.getLen();
            if (this.numAttributesForType(typeID) != numAttr) {
                return false;
            }
            if (fs.getStart() >= 0 && fs.getEnd() >= 0) continue;
            return false;
        }
        return true;
    }

    protected abstract Object performTask(char[] var1, ResultPool var2) throws ProcessingException;

    protected abstract InputFSArrayList convertResult(Object var1, char[] var2);

    protected String getProperty(String aProperty, String aDefault) {
        String val = this.getModulesConfiguration().getProperty(aProperty);
        if (null == val) {
            return aDefault;
        }
        return val;
    }

    protected String getProperty(String aProperty) {
        return this.moduleConfiguration.getProperty(aProperty);
    }

    public boolean checkTypeConsistency(ReefsGrammarTypes types) {
        int numTypes = this.getNumberTypes();
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < numTypes; ++i) {
            int typeID;
            String nextType = this.getTypeName(i);
            Integer tId = types.getTypeID(nextType);
            int n = typeID = tId != null ? tId : ReefsGrammarTypes.UNKNOWN;
            if (typeID != ReefsGrammarTypes.UNKNOWN) {
                int numAttr;
                int numAttributes = types.getNumberAttributesForType(typeID);
                if (numAttributes == (numAttr = this.attributes[i].length)) {
                    for (int j = 0; j < numAttr; ++j) {
                        if (this.attributes[i][j].compareTo(types.getAttributeName(typeID, j)) == 0) continue;
                        errors.add("Attribute: " + this.attributes[i][j] + " for type: " + nextType + " is not defined in the grammar");
                    }
                    continue;
                }
                errors.add("Number of attributes for type: " + nextType + " is inconsistent");
                continue;
            }
            errors.add("Type: " + nextType + " is not defined in the grammar");
        }
        int numErrors = errors.size();
        for (int i = 0; i < numErrors; ++i) {
            Module.loggerMessage((String)errors.get(i));
        }
        return errors.size() <= 0;
    }
}

